/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.gui.screen;

import mods.railcraft.Translations;
import mods.railcraft.client.gui.screen.IngameWindowScreen;
import mods.railcraft.client.util.GuiUtil;
import mods.railcraft.network.NetworkChannel;
import mods.railcraft.network.play.SetEmbarkingTrackAttributesMessage;
import mods.railcraft.world.level.block.track.outfitted.EmbarkingTrackBlock;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.state.BlockState;

public class EmbarkingTrackScreen
extends IngameWindowScreen {
    private final BlockPos blockPos;
    private int radius;
    private Button incrementButton;
    private Button decrementButton;

    public EmbarkingTrackScreen(BlockState blockState, BlockPos blockPos) {
        super((Component)blockState.m_60734_().m_49954_());
        this.blockPos = blockPos;
        this.radius = EmbarkingTrackBlock.getRadius(blockState);
    }

    protected void m_7856_() {
        super.m_7856_();
        int centreX = (this.f_96543_ - this.windowWidth) / 2;
        int centreY = (this.f_96544_ - this.windowHeight) / 2;
        this.decrementButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"-1"), __ -> this.setRadius(this.radius - 1)).m_252987_(centreX + 53, centreY + 50, 30, 20).m_253136_());
        this.incrementButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"+1"), __ -> this.setRadius(this.radius + 1)).m_252987_(centreX + 93, centreY + 50, 30, 20).m_253136_());
        this.updateButtons();
    }

    private void setRadius(int radius) {
        this.radius = radius;
        this.updateButtons();
        NetworkChannel.GAME.sendToServer(new SetEmbarkingTrackAttributesMessage(this.blockPos, this.radius));
    }

    private void updateButtons() {
        this.incrementButton.f_93623_ = this.radius < 5;
        this.decrementButton.f_93623_ = this.radius > 1;
    }

    @Override
    protected void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        MutableComponent componentRadius = Component.m_237110_((String)Translations.Screen.EMBARKING_TRACK_RADIUS, (Object[])new Object[]{this.radius});
        GuiUtil.drawCenteredString(guiGraphics, this.f_96547_, (Component)componentRadius, this.windowWidth, 25);
    }
}

