/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client;

import mods.railcraft.api.signal.TuningAuraHandler;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.client.renderer.blockentity.SignalAuraRenderUtil;
import mods.railcraft.particle.TuningAuraParticleOptions;
import mods.railcraft.world.item.GogglesItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TuningAuraHandlerImpl
implements TuningAuraHandler {
    @Override
    public boolean isTuningAuraActive() {
        return GogglesItem.isGoggleAuraActive(GogglesItem.Aura.TUNING) || GogglesItem.isGoggleAuraActive(GogglesItem.Aura.SIGNALLING);
    }

    @Override
    public void spawnTuningAura(SignalControllerEntity start, BlockEntity dest) {
        Level level = start.asBlockEntity().m_58904_();
        RandomSource random = level.m_213780_();
        if (random.m_188503_(2) != 0) {
            return;
        }
        BlockPos pos = start.asBlockEntity().m_58899_();
        double px = (double)pos.m_123341_() + TuningAuraHandlerImpl.getRandomParticleOffset(random);
        double py = (double)pos.m_123342_() + TuningAuraHandlerImpl.getRandomParticleOffset(random);
        double pz = (double)pos.m_123343_() + TuningAuraHandlerImpl.getRandomParticleOffset(random);
        int color = GogglesItem.isGoggleAuraActive(GogglesItem.Aura.SIGNALLING) ? start.getSignalController().aspect().color() : SignalAuraRenderUtil.rainbow(pos, dest.m_58899_());
        level.m_7106_((ParticleOptions)new TuningAuraParticleOptions(dest.m_58899_().m_252807_(), color), px, py, pz, 0.0, 0.0, 0.0);
    }

    private static double getRandomParticleOffset(RandomSource random) {
        return 0.5 + random.m_188583_() * 0.1;
    }
}

