/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signal;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import org.jetbrains.annotations.Nullable;

public class TrackLocator {
    private final Supplier<Level> level;
    private final BlockPos originPos;
    @Nullable
    private BlockPos trackPos;

    public TrackLocator(Supplier<Level> level, BlockPos originPos) {
        this.level = level;
        this.originPos = originPos;
    }

    @Nullable
    public BlockPos trackPos() {
        if (this.trackPos == null) {
            this.locateTrack();
        }
        return this.trackPos;
    }

    public Status trackStatus() {
        if (this.trackPos == null) {
            return this.locateTrack();
        }
        Level level = this.level.get();
        if (!level.m_46749_(this.trackPos)) {
            return Status.UNKNOWN;
        }
        if (!BaseRailBlock.m_49364_((Level)level, (BlockPos)this.trackPos)) {
            this.trackPos = null;
            return this.locateTrack();
        }
        return Status.VALID;
    }

    private Status locateTrack() {
        int z;
        int y;
        int x = this.originPos.m_123341_();
        Status status = this.testForTrack(x, y = this.originPos.m_123342_(), z = this.originPos.m_123343_());
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x - 1, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x + 1, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z - 1);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z + 1);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x - 2, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x + 2, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z - 2);
        if (status != Status.INVALID) {
            return status;
        }
        return this.testForTrack(x, y, z + 2);
    }

    private Status testForTrack(int x, int y, int z) {
        Level level = this.level.get();
        for (int i = -2; i < 4; ++i) {
            BlockPos pos = new BlockPos(x, y - i, z);
            if (!level.m_46749_(pos)) {
                return Status.UNKNOWN;
            }
            if (!BaseRailBlock.m_49364_((Level)level, (BlockPos)pos)) continue;
            this.trackPos = pos;
            return Status.VALID;
        }
        return Status.INVALID;
    }

    public static enum Status {
        VALID,
        INVALID,
        UNKNOWN;


        public boolean invalid() {
            return this == INVALID;
        }
    }
}

