/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.FluidTools;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.xnet.apiimpl.energy.EnergyChannelSettings;
import mcjty.xnet.apiimpl.fluids.FluidChannelSettings;
import mcjty.xnet.apiimpl.items.ItemChannelSettings;
import mcjty.xnet.apiimpl.logic.LogicConnectorSettings;
import mcjty.xnet.apiimpl.logic.enums.Operator;
import mcjty.xnet.apiimpl.logic.enums.SensorMode;
import mcjty.xnet.compat.RFToolsSupport;
import mcjty.xnet.utils.CastTools;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class RSSensor {
    private final int index;
    private SensorMode sensorMode = SensorMode.OFF;
    private Operator operator = Operator.EQUAL;
    private int amount = 0;
    private Color outputColor = Color.OFF;
    private ItemStack filter = ItemStack.f_41583_;

    public RSSensor(int index) {
        this.index = index;
    }

    public SensorMode getSensorMode() {
        return this.sensorMode;
    }

    public void setSensorMode(SensorMode sensorMode) {
        this.sensorMode = sensorMode;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public Color getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(Color outputColor) {
        this.outputColor = outputColor;
    }

    public boolean isEnabled(String tag) {
        if (("mode" + this.index).equals(tag)) {
            return true;
        }
        if (("op" + this.index).equals(tag)) {
            return true;
        }
        if (("amount" + this.index).equals(tag)) {
            return true;
        }
        if (("scolor" + this.index).equals(tag)) {
            return true;
        }
        if (("stack" + this.index).equals(tag)) {
            return this.sensorMode == SensorMode.FLUID || this.sensorMode == SensorMode.ITEM;
        }
        return false;
    }

    public void createGui(IEditorGui gui) {
        gui.translatableChoices("mode" + this.index, (ITranslatableEnum)this.sensorMode, (ITranslatableEnum[])SensorMode.values());
        gui.choices("op" + this.index, I18nConstants.LOGIC_SENSOR_OPERATOR_TOOLTIP.i18n(new Object[0]), (Enum)this.operator, (Enum[])Operator.values()).integer("amount" + this.index, I18nConstants.LOGIC_SENSOR_AMOUNT_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.amount), 46).colors("scolor" + this.index, I18nConstants.LOGIC_SENSOR_OUT_COLOR_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.outputColor.getColor()), Color.COLORS).ghostSlot("stack" + this.index, this.filter).nl();
    }

    public boolean test(@Nullable BlockEntity te, @Nonnull Level world, @Nonnull BlockPos pos, LogicConnectorSettings settings) {
        switch (this.sensorMode) {
            case ITEM: {
                if (RFToolsSupport.isStorageScanner(te)) {
                    int cnt = RFToolsSupport.countItems(te, this.filter, this.amount + 1);
                    return this.operator.match(cnt, this.amount);
                }
                IItemHandler handler = ItemChannelSettings.getItemHandlerAt(te, settings.getFacing());
                if (handler == null) {
                    return false;
                }
                int cnt = this.countItem(handler, this.filter, this.amount + 1);
                return this.operator.match(cnt, this.amount);
            }
            case FLUID: {
                return FluidChannelSettings.getFluidHandlerAt(te, settings.getFacing()).map(h -> {
                    int cnt = this.countFluid((IFluidHandler)h, this.filter, this.amount + 1);
                    return this.operator.match(cnt, this.amount);
                }).orElse(false);
            }
            case ENERGY: {
                if (!EnergyChannelSettings.isEnergyTE(te, settings.getFacing())) break;
                int cnt = EnergyChannelSettings.getEnergyLevel(te, settings.getFacing());
                return this.operator.match(cnt, this.amount);
            }
            case RS: {
                int cnt = world.m_277185_(pos, settings.getFacing());
                return this.operator.match(cnt, this.amount);
            }
        }
        return false;
    }

    public void update(Map<String, Object> data) {
        this.sensorMode = CastTools.safeSensorMode(data.get("mode" + this.index));
        this.operator = CastTools.safeOperator(data.get("op" + this.index));
        this.amount = CastTools.safeInt(data.get("amount" + this.index));
        this.outputColor = CastTools.safeColor(data.get("scolor" + this.index));
        this.filter = CastTools.safeItemStack(data.get("stack" + this.index));
    }

    public void readFromNBT(CompoundTag tag) {
        this.sensorMode = SensorMode.values()[tag.m_128445_("sensorMode" + this.index)];
        this.operator = Operator.values()[tag.m_128445_("operator" + this.index)];
        this.amount = tag.m_128451_("amount" + this.index);
        this.outputColor = Color.values()[tag.m_128445_("scolor" + this.index)];
        if (tag.m_128441_("filter" + this.index)) {
            CompoundTag itemTag = tag.m_128469_("filter" + this.index);
            this.filter = ItemStack.m_41712_((CompoundTag)itemTag);
        } else {
            this.filter = ItemStack.f_41583_;
        }
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128344_("sensorMode" + this.index, (byte)this.sensorMode.ordinal());
        tag.m_128344_("operator" + this.index, (byte)this.operator.ordinal());
        tag.m_128405_("amount" + this.index, this.amount);
        tag.m_128344_("scolor" + this.index, (byte)this.outputColor.ordinal());
        if (!this.filter.m_41619_()) {
            CompoundTag itemTag = new CompoundTag();
            this.filter.m_41739_(itemTag);
            tag.m_128365_("filter" + this.index, (Tag)itemTag);
        }
    }

    private int countItem(@Nonnull IItemHandler handler, ItemStack matcher, int maxNeeded) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || !(!matcher.m_41619_() ? ItemStack.m_41656_((ItemStack)matcher, (ItemStack)stack) && (cnt += stack.m_41613_()) >= maxNeeded : (cnt += stack.m_41613_()) >= maxNeeded)) continue;
            return cnt;
        }
        return cnt;
    }

    private int countFluid(@Nonnull IFluidHandler handler, ItemStack matcher, int maxNeeded) {
        FluidStack fluidStack = !matcher.m_41619_() ? FluidTools.convertBucketToFluid((ItemStack)matcher) : null;
        int cnt = 0;
        for (int i = 0; i < handler.getTanks(); ++i) {
            FluidStack contents = handler.getFluidInTank(i);
            if (contents.isEmpty() || !(fluidStack != null ? fluidStack.isFluidEqual(contents) && (cnt += contents.getAmount()) >= maxNeeded : (cnt += contents.getAmount()) >= maxNeeded)) continue;
            return cnt;
        }
        return cnt;
    }
}

