/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.client.model.utils;

import com.ldtteam.domumornamentum.client.model.utils.ModelSpriteQuadTransformerData;
import com.ldtteam.domumornamentum.util.SingleBlockLevelReader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class ModelSpriteQuadTransformer
implements IQuadTransformer {
    private final ModelSpriteQuadTransformerData target;

    public static IQuadTransformer create(ModelSpriteQuadTransformerData target) {
        return new ModelSpriteQuadTransformer(target);
    }

    private ModelSpriteQuadTransformer(ModelSpriteQuadTransformerData target) {
        this.target = target;
    }

    public void processInPlace(BakedQuad quad) {
        float minU = quad.m_173410_().m_118409_();
        float uDelta = quad.m_173410_().m_118410_() - minU;
        float minV = quad.m_173410_().m_118411_();
        float vDelta = quad.m_173410_().m_118412_() - minV;
        quad.f_111295_ = this.target.quad().f_111295_;
        for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
            float[] uv = new float[2];
            int offset = vertexIndex * STRIDE + UV0;
            uv[0] = Float.intBitsToFloat(quad.m_111303_()[offset]);
            uv[1] = Float.intBitsToFloat(quad.m_111303_()[offset + 1]);
            float u = (uv[0] - minU) / uDelta;
            float v = (uv[1] - minV) / vDelta;
            float newU = this.target.quad().f_111295_.m_118367_((double)(u * 16.0f));
            float newV = this.target.quad().f_111295_.m_118393_((double)(v * 16.0f));
            quad.m_111303_()[offset] = Float.floatToRawIntBits(newU);
            quad.m_111303_()[offset + 1] = Float.floatToRawIntBits(newV);
        }
        int color = this.getColorFor(this.target.state());
        int tint = this.target.quad().f_111293_;
        int n = color = tint != -1 ? color : -1;
        if (0 <= tint && tint <= 255) {
            color = -1;
            tint = Block.m_49956_((BlockState)this.target.state()) << 8 | tint;
        } else {
            tint = -1;
        }
        if (color != -1) {
            QuadTransformers.applyingColor((int)color).processInPlace(quad);
        }
        if (tint != -1) {
            quad.f_111293_ = tint;
        }
    }

    private int getColorFor(BlockState state) {
        ItemStack target;
        Fluid fluid = state.m_60819_().m_76152_();
        int out = fluid != Fluids.f_76191_ ? IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor(new FluidStack(fluid, 1)) : ((target = ModelSpriteQuadTransformer.getItemStackFromBlockState(state)).m_41619_() ? 0xFFFFFF : Minecraft.m_91087_().getItemColors().m_92676_(target, 0));
        return out;
    }

    private static ItemStack getItemStackFromBlockState(BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            return new ItemStack((ItemLike)liquidBlock.m_5888_(state).m_76152_().m_6859_());
        }
        Item item = ModelSpriteQuadTransformer.getItem(state);
        if (item != Items.f_41852_ && item != null) {
            return new ItemStack((ItemLike)item, 1);
        }
        return new ItemStack((ItemLike)state.m_60734_(), 1);
    }

    private static Item getItem(@NotNull BlockState state) {
        Block block = state.m_60734_();
        if (block.equals(Blocks.f_49991_)) {
            return Items.f_42448_;
        }
        if (block instanceof CropBlock) {
            ItemStack stack = block.m_7397_((BlockGetter)new SingleBlockLevelReader(state), BlockPos.f_121853_, state);
            if (!stack.m_41619_()) {
                return stack.m_41720_();
            }
            return Items.f_42404_;
        }
        if (block instanceof FarmBlock || block instanceof DirtPathBlock) {
            return Blocks.f_50493_.m_5456_();
        }
        if (block instanceof FireBlock) {
            return Items.f_42409_;
        }
        if (block instanceof FlowerPotBlock) {
            return Items.f_42618_;
        }
        if (block == Blocks.f_50570_) {
            return Items.f_41911_;
        }
        return block.m_5456_();
    }
}

