/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.io.energy;

import com.enderio.api.io.IIOConfig;
import com.enderio.api.io.energy.EnergyIOMode;
import com.enderio.machines.common.io.energy.ILargeMachineEnergyStorage;
import com.enderio.machines.common.io.energy.IMachineEnergyStorage;
import org.apache.commons.lang3.NotImplementedException;

public class LargeImmutableMachineEnergyStorage
implements IMachineEnergyStorage,
ILargeMachineEnergyStorage {
    public static final LargeImmutableMachineEnergyStorage EMPTY = new LargeImmutableMachineEnergyStorage(0L, 0L);
    private final long energyStored;
    private final long maxEnergyStored;

    public LargeImmutableMachineEnergyStorage(long energyStored, long maxEnergyStored) {
        this.energyStored = energyStored;
        this.maxEnergyStored = maxEnergyStored;
    }

    public int getEnergyStored() {
        return (int)Math.min(this.energyStored, Integer.MAX_VALUE);
    }

    @Override
    public long getLargeEnergyStored() {
        return this.energyStored;
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.maxEnergyStored, Integer.MAX_VALUE);
    }

    @Override
    public long getLargeMaxEnergyStored() {
        return this.maxEnergyStored;
    }

    @Override
    public int getMaxEnergyUse() {
        return 0;
    }

    @Override
    public IIOConfig getConfig() {
        throw new NotImplementedException();
    }

    @Override
    public EnergyIOMode getIOMode() {
        throw new NotImplementedException();
    }

    @Deprecated
    public int receiveEnergy(int maxReceive, boolean simulate) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public int extractEnergy(int maxExtract, boolean simulate) {
        throw new UnsupportedOperationException();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return false;
    }

    @Override
    @Deprecated
    public void setEnergyStored(int energy) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int addEnergy(int energy) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int addEnergy(int energy, boolean simulate) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int takeEnergy(int energy) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int consumeEnergy(int energy, boolean simulate) {
        throw new UnsupportedOperationException();
    }
}

