/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei.transfer;

import com.enderio.EnderIO;
import com.enderio.core.common.network.CoreNetwork;
import com.enderio.machines.common.init.MachineMenus;
import com.enderio.machines.common.menu.CrafterMenu;
import com.enderio.machines.common.network.UpdateCrafterTemplatePacket;
import java.util.ArrayList;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CrafterRecipeTransferHandler
implements IRecipeTransferHandler<CrafterMenu, CraftingRecipe> {
    private final IRecipeTransferHandlerHelper handlerHelper;

    public CrafterRecipeTransferHandler(IRecipeTransferHandlerHelper handlerHelper) {
        this.handlerHelper = handlerHelper;
    }

    public Class<? extends CrafterMenu> getContainerClass() {
        return CrafterMenu.class;
    }

    public Optional<MenuType<CrafterMenu>> getMenuType() {
        return Optional.of((MenuType)MachineMenus.CRAFTER.get());
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(CrafterMenu container, CraftingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        ArrayList<ItemStack> placedStacks = new ArrayList<ItemStack>();
        NonNullList ingredients = recipe.m_7527_();
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    int ingredientIndex = x + y * shapedRecipe.m_44220_();
                    if (x >= shapedRecipe.m_44220_() || y >= shapedRecipe.m_44221_()) {
                        placedStacks.add(ItemStack.f_41583_);
                        continue;
                    }
                    Ingredient ingredient = (Ingredient)ingredients.get(ingredientIndex);
                    if (ingredient.m_43947_()) {
                        placedStacks.add(ItemStack.f_41583_);
                        continue;
                    }
                    placedStacks.add(this.getIngredientItem(player, ingredient));
                }
            }
        } else if (recipe instanceof ShapelessRecipe) {
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 3; ++x) {
                    int ingredientIndex = x + y * 3;
                    if (ingredientIndex < ingredients.size()) {
                        placedStacks.add(this.getIngredientItem(player, (Ingredient)ingredients.get(ingredientIndex)));
                        continue;
                    }
                    placedStacks.add(ItemStack.f_41583_);
                }
            }
        } else {
            EnderIO.LOGGER.warn("JEI Failure: tried to use a non shaped or shapeless recipe with crafter: " + recipe.getClass().getName());
            return this.handlerHelper.createInternalError();
        }
        if (doTransfer) {
            CoreNetwork.sendToServer(new UpdateCrafterTemplatePacket(placedStacks));
        }
        return null;
    }

    private ItemStack getIngredientItem(Player player, Ingredient ingredient) {
        for (ItemStack item : player.m_150109_().f_35974_) {
            if (!ingredient.test(item)) continue;
            return new ItemStack((ItemLike)item.m_41720_(), 1);
        }
        return ingredient.m_43908_()[0];
    }
}

