/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.machines.common.integrations.jei.category;

import com.enderio.machines.client.gui.screen.FluidTankScreen;
import com.enderio.machines.common.init.MachineBlocks;
import com.enderio.machines.common.lang.MachineLang;
import com.enderio.machines.common.recipe.TankRecipe;
import java.util.List;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TankCategory
implements IRecipeCategory<TankRecipe> {
    public static final RecipeType<TankRecipe> TYPE = RecipeType.create((String)"enderio", (String)"tank", TankRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public TankCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(FluidTankScreen.BG_TEXTURE, 41, 18, 94, 53);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)MachineBlocks.FLUID_TANK.get()));
    }

    public RecipeType<TankRecipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return MachineLang.CATEGORY_TANK;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TankRecipe recipe, IFocusGroup focuses) {
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 39, 3).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(recipe.getFluid()))).setFluidRenderer(16000L, false, 16, 47);
        if (recipe.isEmptying()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 3, 3).addIngredients(recipe.getInput());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 3, 34).addItemStack(recipe.getOutput().m_41777_());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 39, 3).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(recipe.getFluid()))).setFluidRenderer(16000L, false, 16, 47);
        } else {
            builder.addSlot(RecipeIngredientRole.INPUT, 75, 3).addIngredients(recipe.getInput());
            builder.addSlot(RecipeIngredientRole.OUTPUT, 75, 34).addItemStack(recipe.getOutput().m_41777_());
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 39, 3).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, List.of(recipe.getFluid()))).setFluidRenderer(16000L, false, 16, 47);
        }
    }
}

