/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.redstone;

import com.enderio.api.misc.ColorControl;
import com.enderio.conduits.common.conduit.type.redstone.RedstoneConduitData;
import com.enderio.conduits.common.network.CountFilterPacket;
import com.enderio.conduits.common.redstone.RedstoneInsertFilter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class RedstoneCountFilter
implements RedstoneInsertFilter {
    private static final String CHANNEL_KEY = "Channel";
    private static final String MAX_COUNT_KEY = "MaxCount";
    private static final String TICKS_KEY = "Ticks";
    private static final String DEACTIVATED_KEY = "Deactivated";
    private final ItemStack stack;

    public RedstoneCountFilter(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public int getOutputSignal(RedstoneConduitData data, ColorControl control) {
        ColorControl channel = this.getChannel();
        int maxCount = this.getMaxCount();
        boolean deactivated = this.isDeactivated();
        int count = this.getCount();
        if (data.isActive(channel) && deactivated) {
            ++count;
            deactivated = false;
        }
        if (!data.isActive(channel)) {
            deactivated = true;
        }
        if (count > maxCount) {
            count = 1;
        }
        this.setCount(count);
        this.setDeactivated(deactivated);
        return count == maxCount ? 15 : 0;
    }

    public ColorControl getChannel() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128425_(CHANNEL_KEY, 8) ? ColorControl.valueOf(tag.m_128461_(CHANNEL_KEY)) : ColorControl.GREEN;
    }

    public int getMaxCount() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128425_(MAX_COUNT_KEY, 3) ? tag.m_128451_(MAX_COUNT_KEY) : 8;
    }

    public void setMaxCount(int count) {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128405_(MAX_COUNT_KEY, count);
    }

    public int getCount() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128425_(TICKS_KEY, 3) ? tag.m_128451_(TICKS_KEY) : 0;
    }

    public void setCount(int count) {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128405_(TICKS_KEY, count);
    }

    public boolean isDeactivated() {
        CompoundTag tag = this.stack.m_41784_();
        return tag.m_128425_(DEACTIVATED_KEY, 1) && tag.m_128471_(DEACTIVATED_KEY);
    }

    public void setDeactivated(boolean lastActive) {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128379_(DEACTIVATED_KEY, lastActive);
    }

    public void setState(CountFilterPacket packet) {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128359_(CHANNEL_KEY, packet.channel().name());
        tag.m_128405_(MAX_COUNT_KEY, packet.maxCount());
        tag.m_128405_(TICKS_KEY, packet.count());
        tag.m_128379_(DEACTIVATED_KEY, packet.active());
    }

    public void setChannel(ColorControl channel) {
        CompoundTag tag = this.stack.m_41784_();
        tag.m_128359_(CHANNEL_KEY, channel.name());
    }
}

