/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.items;

import com.enderio.api.conduit.ConduitType;
import com.enderio.api.misc.ColorControl;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.base.common.lang.EIOLang;
import com.enderio.conduits.common.conduit.ConduitBundle;
import com.enderio.conduits.common.conduit.block.ConduitBlockEntity;
import com.enderio.conduits.common.conduit.connection.ConnectionState;
import com.enderio.conduits.common.conduit.connection.DynamicConnectionState;
import com.enderio.conduits.common.conduit.type.item.ItemConduitData;
import com.enderio.conduits.common.conduit.type.item.ItemConduitType;
import com.enderio.conduits.common.network.C2SSyncProbeState;
import com.enderio.conduits.common.util.InteractionUtil;
import com.enderio.core.common.network.CoreNetwork;
import com.enderio.core.common.util.TooltipUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class ConduitProbeItem
extends Item {
    public static final String STATE_FIELD = "STATE";
    public static final String CONDUIT_DATA = "CONDUIT_DATA";
    public static final String IS_INSERT = "IS_INSERT";
    public static final String IS_EXTRACT = "IS_EXTRACT";
    public static final String INSERT_CHANNEL = "INSERT_CHANNEL";
    public static final String EXTRACT_CHANNEL = "EXTRACT_CHANNEL";
    public static final String REDSTONE_CONTROL = "REDSTONE_CONTROL";
    public static final String REDSTONE_CHANNEL = "REDSTONE_CHANNEL";
    public static final String ROUND_ROBIN = "ROUND_ROBIN";
    public static final String SELF_FEED = "SELF_FEED";
    public static final String PRIORITY = "PRIORITY";
    public static final Set<String> BOOL_TAG = Set.of("IS_INSERT", "IS_EXTRACT", "ROUND_ROBIN", "SELF_FEED");
    public static final Set<String> COLOR_CONTROL_TAG = Set.of("INSERT_CHANNEL", "EXTRACT_CHANNEL", "REDSTONE_CHANNEL");

    public ConduitProbeItem(Item.Properties properties) {
        super(properties);
    }

    public static State getState(ItemStack stack) {
        return State.values()[stack.m_41784_().m_128451_(STATE_FIELD)];
    }

    public static void setState(ItemStack stack, State state, boolean syncToServer) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(STATE_FIELD, state.ordinal());
        if (syncToServer) {
            CoreNetwork.sendToServer(new C2SSyncProbeState(state));
        }
    }

    public static void switchState(ItemStack stack, boolean syncToServer) {
        CompoundTag tag = stack.m_41784_();
        int newState = (tag.m_128451_(STATE_FIELD) + 1) % State.values().length;
        ConduitProbeItem.setState(stack, State.values()[newState], syncToServer);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockEntity block = context.m_43725_().m_7702_(context.m_8083_());
        Player player = context.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (context.m_43725_().m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (!(block instanceof ConduitBlockEntity)) {
            return super.onItemUseFirst(stack, context);
        }
        ConduitBlockEntity conduit = (ConduitBlockEntity)block;
        switch (ConduitProbeItem.getState(stack)) {
            case COPY_PASTE: {
                if (context.m_7078_()) {
                    this.handleCopy(conduit, InteractionUtil.fromClickLocation(context.m_43720_(), context.m_8083_().m_252807_()), stack, player);
                    break;
                }
                this.handlePaste(conduit, InteractionUtil.fromClickLocation(context.m_43720_(), context.m_8083_().m_252807_()), stack, player);
                break;
            }
            case PROBE: {
                player.m_213846_((Component)Component.m_237113_((String)"This feature isn't implemented yet.").m_130940_(ChatFormatting.RED));
            }
        }
        return InteractionResult.SUCCESS;
    }

    private void handleCopy(ConduitBlockEntity conduitBlock, Direction face, ItemStack itemStack, Player player) {
        CompoundTag tag = itemStack.m_41784_();
        CompoundTag conduitData = new CompoundTag();
        tag.m_128365_(CONDUIT_DATA, (Tag)conduitData);
        ConduitBundle bundle = conduitBlock.getBundle();
        if (bundle.getConnectedTypes(face).isEmpty()) {
            return;
        }
        MutableComponent message = Component.m_237119_();
        bundle.getTypes().forEach(conduit -> {
            String conduitKey = ConduitType.getKey(conduit).toString();
            ConnectionState connectionState = bundle.getConnectionState(face, (ConduitType<?>)conduit);
            CompoundTag typeTag = new CompoundTag();
            if (connectionState instanceof DynamicConnectionState) {
                DynamicConnectionState dynamic = (DynamicConnectionState)connectionState;
                typeTag.m_128379_(IS_INSERT, dynamic.isInsert());
                typeTag.m_128379_(IS_EXTRACT, dynamic.isExtract());
                typeTag.m_128405_(INSERT_CHANNEL, dynamic.insertChannel().ordinal());
                typeTag.m_128405_(EXTRACT_CHANNEL, dynamic.extractChannel().ordinal());
                typeTag.m_128405_(REDSTONE_CONTROL, dynamic.control().ordinal());
                typeTag.m_128405_(REDSTONE_CHANNEL, dynamic.redstoneChannel().ordinal());
                if (conduit instanceof ItemConduitType) {
                    ItemConduitType itemConduitType = (ItemConduitType)conduit;
                    ItemConduitData.ItemSidedData sidedData = bundle.getNodeFor(itemConduitType).getConduitData().get(face);
                    typeTag.m_128379_(ROUND_ROBIN, sidedData.isRoundRobin);
                    typeTag.m_128379_(SELF_FEED, sidedData.isSelfFeed);
                    typeTag.m_128405_(PRIORITY, sidedData.getPriority());
                }
            } else {
                typeTag.m_128379_(IS_INSERT, false);
                typeTag.m_128379_(IS_EXTRACT, false);
            }
            conduitData.m_128365_(conduitKey, (Tag)typeTag);
            message.m_7220_((Component)Component.m_237113_((String)("\n" + this.conduitKeyToDisplayName(conduitKey).getString() + ":\n")).m_130940_(ChatFormatting.UNDERLINE));
            typeTag.m_128431_().forEach(key -> {
                StringBuilder sb = new StringBuilder();
                sb.append(" - " + key + ": ");
                if (BOOL_TAG.contains(key)) {
                    sb.append(typeTag.m_128471_(key));
                } else if (COLOR_CONTROL_TAG.contains(key)) {
                    sb.append(ColorControl.values()[typeTag.m_128451_(key)]);
                } else if (key.equals(REDSTONE_CONTROL)) {
                    sb.append(RedstoneControl.values()[typeTag.m_128451_(key)]);
                } else {
                    sb.append(typeTag.m_128423_(key));
                }
                sb.append("\n");
                message.m_7220_((Component)Component.m_237113_((String)sb.toString()).m_130940_(ChatFormatting.GRAY));
            });
        });
        player.m_213846_((Component)TooltipUtil.withArgs(EIOLang.CONDUIT_PROBE_MESSAGE_COPIED, message));
    }

    public void handlePaste(ConduitBlockEntity conduitBlock, Direction face, ItemStack itemStack, Player player) {
        Tag tag;
        CompoundTag tag2 = itemStack.m_41783_();
        if (tag2 == null || !((tag = tag2.m_128423_(CONDUIT_DATA)) instanceof CompoundTag)) {
            return;
        }
        CompoundTag conduitData = (CompoundTag)tag;
        ArrayList pastedConduits = new ArrayList();
        ConduitBundle bundle = conduitBlock.getBundle();
        bundle.getTypes().forEach(conduit -> {
            String conduitKey = ConduitType.getKey(conduit).toString();
            CompoundTag typeTag = conduitData.m_128469_(conduitKey);
            if (typeTag == null || typeTag.m_128456_()) {
                return;
            }
            ConnectionState prevConnectionState = bundle.getConnectionState(face, (ConduitType<?>)conduit);
            DynamicConnectionState connectionState = null;
            if (prevConnectionState instanceof DynamicConnectionState) {
                connectionState = (DynamicConnectionState)prevConnectionState;
            }
            boolean wasConnected = connectionState != null;
            boolean isInsert = typeTag.m_128471_(IS_INSERT);
            boolean isExtract = typeTag.m_128471_(IS_EXTRACT);
            DynamicConnectionState newState = new DynamicConnectionState(isInsert, ColorControl.values()[typeTag.m_128451_(INSERT_CHANNEL)], isExtract, ColorControl.values()[typeTag.m_128451_(EXTRACT_CHANNEL)], RedstoneControl.values()[typeTag.m_128451_(REDSTONE_CONTROL)], ColorControl.values()[typeTag.m_128451_(REDSTONE_CHANNEL)], wasConnected ? connectionState.filterInsert() : ItemStack.f_41583_, wasConnected ? connectionState.filterExtract() : ItemStack.f_41583_, wasConnected ? connectionState.upgradeExtract() : ItemStack.f_41583_);
            conduitBlock.handleConnectionStateUpdate(face, (ConduitType<?>)conduit, newState);
            if (conduit instanceof ItemConduitType) {
                ItemConduitType itemConduitType = (ItemConduitType)conduit;
                if (typeTag.m_128441_(ROUND_ROBIN)) {
                    ItemConduitData.ItemSidedData sidedData = bundle.getNodeFor(itemConduitType).getConduitData().compute(face);
                    sidedData.isRoundRobin = typeTag.m_128471_(ROUND_ROBIN);
                    sidedData.isSelfFeed = typeTag.m_128471_(SELF_FEED);
                    sidedData.setPriority(typeTag.m_128451_(PRIORITY));
                }
            }
            pastedConduits.add(this.conduitKeyToDisplayName(conduitKey).getString());
        });
        if (!pastedConduits.isEmpty()) {
            String pastedConduitsString = String.join((CharSequence)", ", pastedConduits);
            player.m_213846_((Component)TooltipUtil.withArgs(EIOLang.CONDUIT_PROBE_MESSAGE_PASTED, pastedConduitsString));
        }
        conduitBlock.m_6596_();
        conduitBlock.updateClient();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        CompoundTag conduitData;
        Tag tag;
        if (!(stack.m_41720_() instanceof ConduitProbeItem)) {
            return;
        }
        tooltipComponents.add(TooltipUtil.styledWithArgs(EIOLang.CONDUIT_PROBE_MODE, ConduitProbeItem.getState(stack).getStateText()));
        CompoundTag tag2 = stack.m_41783_();
        if (tag2 != null && (tag = tag2.m_128423_(CONDUIT_DATA)) instanceof CompoundTag && !(conduitData = (CompoundTag)tag).m_128431_().isEmpty()) {
            tooltipComponents.add((Component)EIOLang.CONDUIT_PROBE_CONTAINS_COPIED.m_130940_(ChatFormatting.GRAY));
            conduitData.m_128431_().forEach(conduitKey -> tooltipComponents.add((Component)Component.m_237113_((String)("- " + this.conduitKeyToDisplayName((String)conduitKey).getString())).m_130940_(ChatFormatting.DARK_GRAY)));
        }
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
    }

    private Component conduitKeyToDisplayName(String conduitKey) {
        String translationKey = "item." + conduitKey.replace(":", ".");
        return Component.m_237115_((String)translationKey);
    }

    public static enum State {
        PROBE,
        COPY_PASTE;


        public Component getStateText() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case PROBE -> EIOLang.CONDUIT_PROBE_PROBE;
                case COPY_PASTE -> EIOLang.CONDUIT_PROBE_COPY_PASTE;
            };
        }
    }
}

