/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.conduits.common.integrations.mekanism;

import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitData;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ticker.IOAwareConduitTicker;
import com.enderio.api.conduit.upgrade.ConduitUpgrade;
import com.enderio.api.filter.ResourceFilter;
import com.enderio.api.misc.ColorControl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public abstract class MultiCapabilityAwareConduitTicker<TType extends ConduitData<TType>, TCap>
implements IOAwareConduitTicker<TType> {
    private final Capability<? extends TCap>[] capabilities;

    public MultiCapabilityAwareConduitTicker(Capability<? extends TCap>[] capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    public boolean canConnectTo(Level level, BlockPos conduitPos, Direction direction) {
        for (Capability cap : this.capabilities) {
            boolean hasCap = Optional.ofNullable(level.m_7702_(conduitPos.m_121945_(direction))).flatMap(be -> be.getCapability(cap, direction.m_122424_()).resolve()).isPresent();
            if (!hasCap) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tickColoredGraph(ServerLevel level, ConduitType<TType> type, List<IOAwareConduitTicker.Connection<TType>> inserts, List<IOAwareConduitTicker.Connection<TType>> extracts, ColorControl color, ConduitGraph<TType> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        ArrayList insertCaps = new ArrayList();
        for (IOAwareConduitTicker.Connection insert : inserts) {
            for (Capability cap : this.capabilities) {
                Optional.ofNullable(level.m_7702_(insert.move())).flatMap(b -> b.getCapability(cap, insert.dir().m_122424_()).resolve()).ifPresent(c -> insertCaps.add(new CapabilityConnection(c, insert.data(), insert.dir(), insert.upgrade(), insert.extractFilter(), insert.insertFilter())));
            }
        }
        if (!insertCaps.isEmpty()) {
            ArrayList extractCaps = new ArrayList();
            for (IOAwareConduitTicker.Connection extract : extracts) {
                for (Capability cap : this.capabilities) {
                    Optional.ofNullable(level.m_7702_(extract.move())).flatMap(b -> b.getCapability(cap, extract.dir().m_122424_()).resolve()).ifPresent(c -> extractCaps.add(new CapabilityConnection(c, extract.data(), extract.dir(), extract.upgrade(), extract.extractFilter(), extract.insertFilter())));
                }
            }
            if (!extractCaps.isEmpty()) {
                this.tickCapabilityGraph(type, insertCaps, extractCaps, level, graph, coloredRedstoneProvider);
            }
        }
    }

    protected abstract void tickCapabilityGraph(ConduitType<TType> var1, List<CapabilityConnection<TType, TCap>> var2, List<CapabilityConnection<TType, TCap>> var3, ServerLevel var4, ConduitGraph<TType> var5, ColoredRedstoneProvider var6);

    public record CapabilityConnection<TType extends ConduitData<TType>, TCap>(TCap capability, TType data, Direction direction, @Nullable ConduitUpgrade upgrade, @Nullable ResourceFilter extractFilter, @Nullable ResourceFilter insertFilter) {
    }
}

