/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.general_features.structures.villages;

import com.google.common.collect.ImmutableMap;
import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageProfessions;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawPoolBuilder;
import com.legacy.structure_gel.api.structure.jigsaw.JigsawRegistryHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class SkiesVillagePools {
    public static final ResourceKey<StructureTemplatePool> CALMING_SKIES = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)BlueSkies.locate("village/" + SkiesVillageBiomes.CALMING_SKIES.toString() + "/town_centers"));
    public static final ResourceKey<StructureTemplatePool> BRIGHTLANDS = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)BlueSkies.locate("village/" + SkiesVillageBiomes.BRIGHTLANDS.toString() + "/town_centers"));
    public static final ResourceKey<StructureTemplatePool> SLUSHLANDS = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)BlueSkies.locate("village/" + SkiesVillageBiomes.SLUSHLANDS.toString() + "/town_centers"));
    public static final ResourceKey<StructureTemplatePool> SHADED_WOODLANDS = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)BlueSkies.locate("village/" + SkiesVillageBiomes.SHADED_WOODLANDS.toString() + "/town_centers"));
    public static final ResourceKey<StructureTemplatePool> SUNSET_MAPLE_FOREST = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)BlueSkies.locate("village/" + SkiesVillageBiomes.SUNSET_MAPLE_FOREST.toString() + "/town_centers"));
    public static final ResourceKey<StructureTemplatePool> CRYSTAL_DUNES = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)BlueSkies.locate("village/" + SkiesVillageBiomes.CRYSTAL_DUNES.toString() + "/town_centers"));

    public static void bootstrap(BootstapContext<StructureTemplatePool> bootstrap) {
        JigsawPoolBuilder empty = new JigsawRegistryHelper("minecraft", "", bootstrap).poolBuilder().namesR(new ResourceLocation[]{new ResourceLocation("empty")});
        String calmingSkies = SkiesVillageBiomes.CALMING_SKIES.toString();
        SkiesVillagePools.createVillagePools(bootstrap, calmingSkies, 3, 1, 6, 3, 6, (ResourceKey<StructureProcessorList>)SkiesStructures.ProcessorLists.CALMING_SKIES_STREET.getKey(), 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.SHOVELER));
        JigsawRegistryHelper registryCalmingSkies = new JigsawRegistryHelper("blue_skies", "village/" + calmingSkies + "/", bootstrap);
        registryCalmingSkies.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registryCalmingSkies.setPrefix(registryCalmingSkies.prefix + "decor/").poolBuilder().names(new String[]{"log_pile", "lamp", "flower_bed", "rock", "shrub"}), empty.clone()}));
        String brightlands = SkiesVillageBiomes.BRIGHTLANDS.toString();
        SkiesVillagePools.createVillagePools(bootstrap, brightlands, 3, 1, 6, 3, 6, (ResourceKey<StructureProcessorList>)SkiesStructures.ProcessorLists.BRIGHTLANDS_STREET.getKey(), 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.TOOLSMITH));
        JigsawRegistryHelper registryBrightlands = new JigsawRegistryHelper("blue_skies", "village/" + brightlands + "/", bootstrap);
        registryBrightlands.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registryBrightlands.setPrefix(registryBrightlands.prefix + "decor/").poolBuilder().names(new String[]{"campfire", "lamp", "tree", "ice_spike"}), empty.clone()}));
        String slushlands = SkiesVillageBiomes.SLUSHLANDS.toString();
        SkiesVillagePools.createVillagePools(bootstrap, slushlands, 3, 1, 6, 3, 6, (ResourceKey<StructureProcessorList>)SkiesStructures.ProcessorLists.SLUSHLANDS_STREET.getKey(), 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.SHOVELER));
        JigsawRegistryHelper registrySlushlands = new JigsawRegistryHelper("blue_skies", "village/" + slushlands + "/", bootstrap);
        registrySlushlands.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registrySlushlands.setPrefix(registrySlushlands.prefix + "decor/").poolBuilder().names((Map)ImmutableMap.of((Object)"mushroom_basket", (Object)2, (Object)"lamp", (Object)3, (Object)"small_mushroom", (Object)3, (Object)"oven", (Object)1)), empty.clone()}));
        String woodlands = SkiesVillageBiomes.SHADED_WOODLANDS.toString();
        SkiesVillagePools.createVillagePools(bootstrap, woodlands, 3, 1, 6, 3, 6, (ResourceKey<StructureProcessorList>)SkiesStructures.ProcessorLists.SHADED_WOODLANDS_STREET.getKey(), 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.SHOVELER, SkiesVillageProfessions.SHEPHERD));
        JigsawRegistryHelper registryWoodlands = new JigsawRegistryHelper("blue_skies", "village/" + woodlands + "/", bootstrap);
        registryWoodlands.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registryWoodlands.setPrefix(registryWoodlands.prefix + "decor/").poolBuilder().names(new String[]{"lamp", "campfire", "chairs", "farm"}), empty.clone()}));
        String maple = SkiesVillageBiomes.SUNSET_MAPLE_FOREST.toString();
        SkiesVillagePools.createVillagePools(bootstrap, maple, 3, 1, 6, 3, 6, (ResourceKey<StructureProcessorList>)SkiesStructures.ProcessorLists.SUNSET_MAPLE_FOREST_STREET.getKey(), 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.SHOVELER, SkiesVillageProfessions.SHEPHERD));
        JigsawRegistryHelper registryMaple = new JigsawRegistryHelper("blue_skies", "village/" + maple + "/", bootstrap);
        registryMaple.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registryMaple.setPrefix(registryMaple.prefix + "decor/").poolBuilder().names((Map)ImmutableMap.of((Object)"lamp", (Object)6, (Object)"campfire", (Object)1)), empty.clone().weight(20)}));
        registryMaple.register("town_centers/well_bottom", (List)registryMaple.poolBuilder().names(new String[]{"town_centers/well_bottom"}).build());
        String dunes = SkiesVillageBiomes.CRYSTAL_DUNES.toString();
        SkiesVillagePools.createVillagePools(bootstrap, dunes, 3, 1, 6, 3, 6, (ResourceKey<StructureProcessorList>)SkiesStructures.ProcessorLists.CRYSTAL_DUNES.getKey(), 8, 2, 1, SkiesVillageProfessions.getWithout(SkiesVillageProfessions.SHOVELER, SkiesVillageProfessions.SHEPHERD, SkiesVillageProfessions.FISHER));
        JigsawRegistryHelper registryDunes = new JigsawRegistryHelper("blue_skies", "village/" + dunes + "/", bootstrap);
        registryDunes.register("decor", (List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{registryDunes.setPrefix(registryDunes.prefix + "decor/").poolBuilder().names((Map)ImmutableMap.of((Object)"lamp", (Object)5, (Object)"campfire", (Object)1)), empty.clone().weight(15)}));
        registryDunes.register("town_centers/oasis_bottom", (List)registryDunes.poolBuilder().names(new String[]{"town_centers/oasis_bottom"}).build());
    }

    private static void createVillagePools(BootstapContext<StructureTemplatePool> bootstrap, String biome, int townCenters, int terminators, int straightStreets, int streetCorners, int streetIntersections, ResourceKey<StructureProcessorList> resourceKey, int smallHouses, int medHouses, int largeHouses, List<SkiesVillageProfessions> jobSiteNames) {
        JigsawRegistryHelper registry = new JigsawRegistryHelper("blue_skies", "village/" + biome + "/", bootstrap);
        registry.register("town_centers", SkiesVillagePools.makeBuilder(registry, "town_centers/", townCenters).maintainWater(false));
        registry.register("terminators", registry.registerBuilder().pools((List)SkiesVillagePools.makeBuilder(registry, "terminators/", terminators).processors(resourceKey).build()).projection(StructureTemplatePool.Projection.TERRAIN_MATCHING));
        JigsawRegistryHelper streetRegistry = registry.setPrefix(registry.prefix + "streets/");
        JigsawPoolBuilder streets = SkiesVillagePools.makeBuilder(streetRegistry, "straight_", straightStreets).weight(10).processors(resourceKey);
        JigsawPoolBuilder corners = SkiesVillagePools.makeBuilder(streetRegistry, "corner_", streetCorners).weight(8).processors(resourceKey);
        JigsawPoolBuilder intersections = SkiesVillagePools.makeBuilder(streetRegistry, "intersection_", streetIntersections).weight(2).processors(resourceKey);
        registry.register("streets", registry.registerBuilder().pools((List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{streets, corners, intersections})).projection(StructureTemplatePool.Projection.TERRAIN_MATCHING).fallback("terminators"));
        JigsawRegistryHelper houseRegistry = registry.setPrefix(registry.prefix + "houses/");
        JigsawPoolBuilder sHouses = SkiesVillagePools.makeBuilder(houseRegistry, "small_", smallHouses);
        JigsawPoolBuilder mHouses = SkiesVillagePools.makeBuilder(houseRegistry, "medium_", medHouses);
        JigsawPoolBuilder lHouses = SkiesVillagePools.makeBuilder(houseRegistry, "large_", largeHouses);
        JigsawPoolBuilder jobSites = houseRegistry.poolBuilder().names((Collection)jobSiteNames.stream().map(SkiesVillageProfessions::toString).collect(Collectors.toList()));
        registry.register("houses", registry.registerBuilder().pools((List)JigsawPoolBuilder.collect((JigsawPoolBuilder[])new JigsawPoolBuilder[]{sHouses, mHouses, lHouses, jobSites})).fallback("terminators"));
    }

    private static JigsawPoolBuilder makeBuilder(JigsawRegistryHelper registry, String name, int count) {
        String[] names = new String[count];
        for (int i = 0; i < count; ++i) {
            names[i] = name + i;
        }
        return registry.poolBuilder().names(names);
    }
}

