/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.world.biome_provider.biomes;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.world.biome_provider.biomes.BiomeBasedChunkGen;
import com.legacy.blue_skies.world.biome_provider.biomes.BiomeData;
import com.legacy.blue_skies.world.biome_provider.pixel_functions.HeightFuncs;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeIds {
    private static final List<ResourceLocation> BIOME_NAMES = new ArrayList<ResourceLocation>();
    private static final List<BiomeData> BIOME_DATA = new ArrayList<BiomeData>();
    private static final Object2IntOpenHashMap<ResourceLocation> BIOME_NAMES_TO_ID = new Object2IntOpenHashMap();
    private static int nextId = 0;
    public static final int PLAINS = BiomeIds.register("minecraft:plains", BiomeData.builder(70, 5));
    public static final int OCEAN = BiomeIds.register("minecraft:ocean", BiomeData.builder(40, 5));
    public static final int DEEP_OCEAN = BiomeIds.register("minecraft:deep_ocean", BiomeData.builder(20, 5));
    public static final int CALMING_SKIES = BiomeIds.register(SkiesBiomes.CALMING_SKIES, BiomeData.builder(83, 7).temperatures(Temperature.NEUTRAL).roughness(4));
    public static final int BRIGHTLANDS = BiomeIds.register(SkiesBiomes.BRIGHTLANDS, BiomeData.builder(150, 70).temperatures(Temperature.FROZEN).pointiness(25).roughness(9).steps(16, 7, 0.0));
    public static final int SLUSHLANDS = BiomeIds.register(SkiesBiomes.SLUSHLANDS, BiomeData.builder(66, 7).temperatures(Temperature.HOT).valleyDepth(6).roughness(7).noBeaches().cantBecomeRiver());
    public static final int FROSTBITTEN_FOREST = BiomeIds.register(SkiesBiomes.FROSTBITTEN_FOREST, BiomeData.builder(75, 6).temperatures(Temperature.FROZEN));
    public static final int SNOW_COVERED_PINES = BiomeIds.register(SkiesBiomes.SNOW_COVERED_PINES, BiomeData.builder(90, 8).temperatures(Temperature.FROZEN, Temperature.NEUTRAL));
    public static final int BRISK_MEADOW = BiomeIds.register(SkiesBiomes.BRISK_MEADOW, BiomeData.builder(78, 5).temperatures(Temperature.HOT));
    public static final int POLAR_HIGHLAND = BiomeIds.register(SkiesBiomes.POLAR_HIGHLAND, BiomeData.builder(87, 20).temperatures(Temperature.NEUTRAL, Temperature.HOT).pointiness(8).valleyDepth(12));
    public static final int PEEKING_OCEAN = BiomeIds.register(SkiesBiomes.PEEKING_OCEAN, BiomeData.builder(40, 5).temperatures(Temperature.NEUTRAL).isShallowOcean(BiomeIds::deepPeekingOcean));
    public static final int DEEP_PEEKING_OCEAN = BiomeIds.register(SkiesBiomes.DEEP_PEEKING_OCEAN, BiomeData.builder(25, 5).temperatures(Temperature.NEUTRAL).isDeepOcean(BiomeIds::peekingOcean));
    public static final int SHALLOW_BRIGHTLANDS = BiomeIds.register(BlueSkies.locate("shallow_brightlands"), BiomeData.builder(110, 20).pointiness(12).roughness(6).steps(11, 8, 0.4).alias(BRIGHTLANDS));
    public static final int FROSTBITTEN_FOREST_CLEARING = BiomeIds.register(SkiesBiomes.FROSTBITTEN_FOREST_CLEARING, BiomeData.builder(72, 5));
    public static final int MIDDAY_SHORE = BiomeIds.register(SkiesBiomes.MIDDAY_SHORE, BiomeData.builder(65, 2).valleyDepth(0));
    public static final int BRUMBLE_FOREST = BiomeIds.register(SkiesBiomes.BRUMBLE_FOREST, BiomeData.builder(25, 10).pointiness(4).valleyDepth(4).roughness(6).isDeepOcean(BiomeIds::peekingOcean));
    public static final int UNORTHODOX_VALLEY = BiomeIds.register(SkiesBiomes.UNORTHODOX_VALLEY, BiomeData.builder(85, 120).biomeBasedChunkGen(BiomeBasedChunkGen.UNORTHODX_VALLEY).mainHeightFunc(HeightFuncs::unorthodoxHeightFunc).temperatures(Temperature.FROZEN).valleyDepth(40).roughness(15).pointiness(5).steps(5, 2, 0.3));
    public static final int SHADED_WOODLANDS = BiomeIds.register(SkiesBiomes.SHADED_WOODLANDS, BiomeData.builder(68, 5).temperatures(Temperature.FROZEN));
    public static final int CRYSTAL_DUNES = BiomeIds.register(SkiesBiomes.CRYSTAL_DUNES, BiomeData.builder(70, 5).temperatures(Temperature.HOT).pointiness(6));
    public static final int SUNSET_MAPLE_FOREST = BiomeIds.register(SkiesBiomes.SUNSET_MAPLE_FOREST, BiomeData.builder(70, 6).temperatures(Temperature.NEUTRAL));
    public static final int MOONLIT_RESERVOIR = BiomeIds.register(SkiesBiomes.MOONLIT_RESERVOIR, BiomeData.builder(64, 8).temperatures(Temperature.NEUTRAL).noBeaches().cantBecomeRiver());
    public static final int CRYSTAL_ROUGHS = BiomeIds.register(SkiesBiomes.CRYSTAL_ROUGHS, BiomeData.builder(78, 10).temperatures(Temperature.HOT).pointiness(8).steps(4, 2, 0.0));
    public static final int SEARING_GRASSLAND = BiomeIds.register(SkiesBiomes.SEARING_GRASSLAND, BiomeData.builder(70, 4).temperatures(Temperature.NEUTRAL));
    public static final int CRESCENT_ORCHARD = BiomeIds.register(SkiesBiomes.CRESCENT_ORCHARD, BiomeData.builder(68, 5).temperatures(Temperature.FROZEN));
    public static final int CRYSTAL_DUNES_SPIKES = BiomeIds.register(SkiesBiomes.CRYSTAL_DUNES_SPIKES, BiomeData.builder(75, 9).pointiness(3));
    public static final int CRESCENT_ORCHARD_LAKE = BiomeIds.register(SkiesBiomes.CRESCENT_ORCHARD_LAKE, BiomeData.builder(55, 2));
    public static final int RISING_CREEK = BiomeIds.register(SkiesBiomes.RISING_CREEK, BiomeData.builder(55, 6));
    public static final int RISING_CREEK_EDGE = BiomeIds.register(BlueSkies.locate("rising_creek_edge"), BiomeData.builder(64, 3).valleyDepth(2).alias(RISING_CREEK));
    public static final int FROZ = BiomeIds.register("blue_skies_debug:frozen", BiomeData.builder(1, 1).temperatures(Temperature.FROZEN));
    public static final int COLD = BiomeIds.register("blue_skies_debug:cold", BiomeData.builder(1, 1).temperatures(Temperature.FROZEN));
    public static final int NEUT = BiomeIds.register("blue_skies_debug:neutral", BiomeData.builder(1, 1).temperatures(Temperature.NEUTRAL));
    public static final int WARM = BiomeIds.register("blue_skies_debug:warm", BiomeData.builder(1, 1).temperatures(Temperature.FROZEN));
    public static final int HOTT = BiomeIds.register("blue_skies_debug:hot", BiomeData.builder(1, 1).temperatures(Temperature.HOT));

    public static int register(Registrar.Pointer<Biome> shadedWoodlands, BiomeData.Builder data) {
        return BiomeIds.register(shadedWoodlands.getName(), data);
    }

    public static int register(String name, BiomeData.Builder data) {
        return BiomeIds.register(new ResourceLocation(name), data);
    }

    public static int register(ResourceLocation name, BiomeData.Builder data) {
        int id = nextId++;
        BIOME_NAMES.add(name);
        BIOME_DATA.add(data.build(id, name));
        BIOME_NAMES_TO_ID.put((Object)name, id);
        return id;
    }

    public static ResourceLocation getName(int id) {
        return BIOME_NAMES.get(id);
    }

    public static BiomeData getData(int id) {
        return BIOME_DATA.get(id);
    }

    public static int getId(ResourceLocation name) {
        return BIOME_NAMES_TO_ID.getInt((Object)name);
    }

    private static int peekingOcean() {
        return PEEKING_OCEAN;
    }

    private static int deepPeekingOcean() {
        return DEEP_PEEKING_OCEAN;
    }

    static {
        BIOME_NAMES_TO_ID.defaultReturnValue(PLAINS);
    }

    public static enum Temperature {
        FROZEN,
        COLD,
        NEUTRAL,
        WARM,
        HOT;

    }
}

