/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.ai;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.registries.SkiesSounds;
import com.legacy.blue_skies.registries.SkiesVillagers;
import com.legacy.blue_skies.util.EntityUtil;
import com.legacy.blue_skies.util.GeometryHelper;
import com.legacy.structure_gel.api.util.Positions;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NightwatcherRobGoal
extends Goal {
    private final Villager villager;
    private final double speed;
    private Villager targetVillager;
    private Task task = Task.ROBBING;
    private Vec3 awayVec = null;
    private List<UUID> robbedVilagers = Lists.newArrayList();
    private int robbingDelay = 0;
    private BlockPos prevPos;

    public NightwatcherRobGoal(Villager creatureIn, double speedIn) {
        this.speed = speedIn;
        this.villager = creatureIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void m_8056_() {
        Villager target;
        AABB radiusCheck = new AABB(this.villager.m_20183_()).m_82377_(35.0, 5.0, 35.0);
        List entityList = this.villager.m_9236_().m_6249_((Entity)this.villager, radiusCheck, entity -> {
            Villager villager;
            return entity instanceof Villager && (villager = (Villager)entity).m_5803_() && villager.m_20270_((Entity)this.villager) <= 33.0f;
        });
        entityList.sort(new Comparator<Entity>(){

            @Override
            public int compare(Entity p1, Entity p2) {
                return (int)(p1.m_20270_((Entity)NightwatcherRobGoal.this.villager) - p2.m_20270_((Entity)NightwatcherRobGoal.this.villager));
            }
        });
        if (!entityList.isEmpty() && this.robbingDelay <= 0 && !this.robbedVilagers.contains((target = (Villager)entityList.get(this.villager.m_9236_().f_46441_.m_188503_(entityList.size()))).m_20148_())) {
            this.targetVillager = target;
        }
    }

    public void m_8037_() {
        if (this.robbingDelay > 0) {
            --this.robbingDelay;
        }
        if (this.villager.m_9236_().m_46461_() || this.villager.m_9236_().m_46468_() % 6000L == 0L) {
            this.robbedVilagers.clear();
        }
        Optional jobSite = this.villager.m_6274_().m_21952_(MemoryModuleType.f_26360_);
        if (this.targetVillager != null) {
            if (!this.targetVillager.m_6084_()) {
                this.m_8041_();
                return;
            }
            if (this.targetVillager.m_5803_() && (!jobSite.isPresent() || jobSite.isPresent() && GeometryHelper.calcDistance(Vec3.m_82512_((Vec3i)((GlobalPos)jobSite.get()).m_122646_()), this.villager.m_20182_()) <= 38.0)) {
                if (this.task == Task.ROBBING) {
                    for (BlockPos pos : BlockPos.m_121921_((AABB)this.villager.m_20191_().m_82400_((double)0.1f)).map(BlockPos::m_7949_).toList()) {
                        BlockState state = this.villager.m_9236_().m_8055_(pos);
                        Block block = state.m_60734_();
                        if (!(block instanceof DoorBlock)) continue;
                        DoorBlock door = (DoorBlock)block;
                        if (!state.m_204336_(BlockTags.f_13095_)) continue;
                        door.m_153165_((Entity)this.villager, this.villager.m_9236_(), state, pos, this.task == Task.ROBBING);
                    }
                } else if (this.prevPos != this.villager.m_20183_()) {
                    BlockState state;
                    Block block;
                    if (this.prevPos != null && (block = (state = this.villager.m_9236_().m_8055_(this.prevPos)).m_60734_()) instanceof DoorBlock) {
                        DoorBlock door = (DoorBlock)block;
                        if (state.m_204336_(BlockTags.f_13095_)) {
                            door.m_153165_((Entity)this.villager, this.villager.m_9236_(), state, this.prevPos, this.task == Task.ROBBING);
                        }
                    }
                    this.prevPos = this.villager.m_20183_();
                }
                if (this.task == Task.ROBBING) {
                    double distance = this.targetVillager.m_20270_((Entity)this.villager);
                    if (distance < 3.0) {
                        this.villager.m_21566_().m_6849_(this.targetVillager.m_20185_(), this.targetVillager.m_20186_(), this.targetVillager.m_20189_(), this.speed);
                    }
                    this.villager.m_21573_().m_5624_((Entity)this.targetVillager, this.speed);
                    this.villager.m_21563_().m_24960_((Entity)this.targetVillager, 40.0f, 40.0f);
                    if (distance < 1.0) {
                        this.robbedVilagers.add(this.targetVillager.m_20148_());
                        this.villager.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                        this.task = Task.RUNNING;
                    }
                } else if (this.task == Task.RUNNING) {
                    if (this.awayVec == null) {
                        this.awayVec = jobSite.isPresent() ? Vec3.m_82512_((Vec3i)((GlobalPos)jobSite.get()).m_122646_()) : LandRandomPos.m_148521_((PathfinderMob)this.villager, (int)20, (int)7, (Vec3)this.targetVillager.m_20182_());
                    } else if (EntityUtil.getDistanceToPos((Vec3i)this.villager.m_20183_(), (Vec3i)Positions.blockPos((Position)this.awayVec)) > 1.3f) {
                        this.villager.m_21573_().m_26519_(this.awayVec.f_82479_, this.awayVec.f_82480_, this.awayVec.f_82481_, (double)0.7f);
                    } else {
                        this.villager.m_5496_(SkiesSounds.ENTITY_VILLAGER_WORK_NIGHTWATCHER, 1.0f, 1.0f);
                        this.m_8041_();
                    }
                }
            } else {
                this.m_8041_();
            }
        }
    }

    public void m_8041_() {
        this.targetVillager = null;
        this.awayVec = null;
        this.task = Task.ROBBING;
    }

    public boolean m_8036_() {
        if (this.villager.m_7141_().m_35571_() != SkiesVillagers.NIGHTWATCHER.get()) {
            return false;
        }
        return EntityUtil.isVillagerWorkTime(this.villager);
    }

    public boolean m_8045_() {
        return this.targetVillager != null && this.task.ordinal() < 2 && EntityUtil.isVillagerWorkTime(this.villager) && this.villager.m_7141_().m_35571_() == SkiesVillagers.NIGHTWATCHER.get() && super.m_8045_();
    }

    public boolean m_183429_() {
        return true;
    }

    private static enum Task {
        ROBBING,
        RUNNING;

    }
}

