/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.data.providers;

import com.legacy.blue_skies.blocks.natural.LargeFlowerBlock;
import com.legacy.blue_skies.data.objects.tags.SkiesBiomeTags;
import com.legacy.blue_skies.data.objects.tags.SkiesBlockTags;
import com.legacy.blue_skies.data.objects.tags.SkiesEntityTags;
import com.legacy.blue_skies.data.objects.tags.SkiesItemTags;
import com.legacy.blue_skies.data.objects.tags.SkiesPoiTags;
import com.legacy.blue_skies.data.objects.tags.SkiesStructureTags;
import com.legacy.blue_skies.registries.SkiesBiomes;
import com.legacy.blue_skies.registries.SkiesBlocks;
import com.legacy.blue_skies.registries.SkiesDamageTypes;
import com.legacy.blue_skies.registries.SkiesEntityTypes;
import com.legacy.blue_skies.registries.SkiesItems;
import com.legacy.blue_skies.registries.SkiesPoiTypes;
import com.legacy.blue_skies.registries.SkiesStructures;
import com.legacy.blue_skies.world.general_features.structures.villages.SkiesVillageBiomes;
import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.BiomeTagsProvider;
import net.minecraft.data.tags.EntityTypeTagsProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.PoiTypeTagsProvider;
import net.minecraft.data.tags.StructureTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.RecordItem;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.BlockTagsProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class SkiesTagProv {

    public static class DamageTypeProv
    extends TagsProvider<DamageType> {
        public DamageTypeProv(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookup, ExistingFileHelper existingFileHelper) {
            super(packOutput, Registries.f_268580_, lookup, "blue_skies", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider lookup) {
            this.m_206424_(DamageTypeTags.f_268524_).m_211101_(new ResourceKey[]{SkiesDamageTypes.FALLING_SPIKE.getKey(), SkiesDamageTypes.FALLING_SPIKE_INDIRECT.getKey(), SkiesDamageTypes.VENOM_SPIT_INDIRECT.getKey()});
            this.m_206424_(DamageTypeTags.f_268490_).m_211101_(new ResourceKey[]{SkiesDamageTypes.STRANGE_LIGHTNING.getKey(), SkiesDamageTypes.VENOM_SPIT.getKey(), SkiesDamageTypes.FALLING_SPIKE.getKey(), SkiesDamageTypes.SLAM.getKey()});
            this.m_206424_(DamageTypeTags.f_268413_).m_255204_(SkiesDamageTypes.VENOM_SPIT.getKey());
            this.m_206424_(DamageTypeTags.f_268627_).m_211101_(new ResourceKey[]{SkiesDamageTypes.FALLING_SPIKE.getKey(), SkiesDamageTypes.FALLING_SPIKE_INDIRECT.getKey()});
            this.m_206424_(DamageTypeTags.f_268725_).m_255204_(SkiesDamageTypes.STRANGE_LIGHTNING.getKey());
            this.m_206424_(DamageTypeTags.f_268745_).m_255204_(SkiesDamageTypes.EMBER.getKey());
            this.m_206424_(DamageTypeTags.f_276146_).m_211101_(new ResourceKey[]{SkiesDamageTypes.FLUCTUANT_SPHERE.getKey(), SkiesDamageTypes.SLAM.getKey(), SkiesDamageTypes.CRUSHER_ROOT.getKey(), SkiesDamageTypes.FALLING_SPIKE.getKey(), SkiesDamageTypes.FALLING_SPIKE_INDIRECT.getKey(), SkiesDamageTypes.STRANGE_LIGHTNING.getKey()});
        }
    }

    public static class PoiTagProv
    extends PoiTypeTagsProvider {
        public PoiTagProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "blue_skies", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.blueSkies();
            this.vanilla();
            this.forge();
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            SkiesPoiTags.init();
            return super.m_213708_(cache);
        }

        private void blueSkies() {
        }

        private void vanilla() {
            this.add((TagKey<PoiType>)PoiTypeTags.f_215875_, SkiesPoiTypes.STAR_EMITTER, SkiesPoiTypes.TROUGH, SkiesPoiTypes.TOOL_BOX, SkiesPoiTypes.BAG_OF_SPOILS, SkiesPoiTypes.SUMMONING_TABLE, SkiesPoiTypes.ALCHEMY_TABLE);
        }

        private void add(TagKey<PoiType> tag, Registrar.Static<PoiType> ... pois) {
            this.m_206424_(tag).m_211101_((ResourceKey[])List.of(pois).stream().map(r -> r.getKey()).toArray(ResourceKey[]::new));
        }

        private void forge() {
        }

        public String m_6055_() {
            return "Blue Skies PoiType Tags";
        }
    }

    public static class BiomeTagProv
    extends BiomeTagsProvider {
        public BiomeTagProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "blue_skies", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.blueSkies();
            this.vanilla();
            this.forge();
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            SkiesEntityTags.init();
            return super.m_213708_(cache);
        }

        private void blueSkies() {
            this.add(SkiesBiomeTags.EVERBRIGHT, SkiesBiomes.EVERBRIGHT_BIOMES);
            this.add(SkiesBiomeTags.EVERDAWN, SkiesBiomes.EVERDAWN_BIOMES);
            this.add(SkiesBiomeTags.HAS_SANDSTORMS, SkiesBiomes.CRYSTAL_DUNES, SkiesBiomes.CRYSTAL_DUNES_SPIKES);
            this.m_206424_(SkiesBiomeTags.DRIPSTONES_DRIP_LAVA).m_211101_(new ResourceKey[]{SkiesBiomes.SEARING_GRASSLAND.getKey(), SkiesBiomes.SUNSET_MAPLE_FOREST.getKey()}).m_206428_(BiomeTags.f_207612_);
            this.add(SkiesBiomeTags.SHADE_MONITOR_PURPLE, SkiesBiomes.UNORTHODOX_VALLEY);
            this.add(SkiesBiomeTags.SHADE_MONITOR_WHITE, SkiesBiomes.CRYSTAL_DUNES, SkiesBiomes.CRYSTAL_DUNES_SPIKES);
            this.add(SkiesBiomeTags.SHADE_MONITOR_WHITE_AND_PURPLE, SkiesBiomes.CRYSTAL_ROUGHS);
            this.add(SkiesBiomeTags.SHADE_MONITOR_RED, SkiesBiomes.SUNSET_MAPLE_FOREST, SkiesBiomes.SEARING_GRASSLAND);
            this.add(SkiesBiomeTags.SHADE_MONITOR_PINK, SkiesBiomes.SHADED_WOODLANDS);
            this.add(SkiesBiomeTags.SHADE_MONITOR_MUDDY_PURPLE, SkiesBiomes.MOONLIT_RESERVOIR);
            this.m_206424_(SkiesBiomeTags.SHADE_MONITOR_SNOWY_BLUE).m_206428_(SkiesBiomeTags.EVERBRIGHT);
        }

        private void vanilla() {
            this.add((TagKey<Biome>)BiomeTags.f_263839_, SkiesBiomes.RISING_CREEK, SkiesBiomes.MOONLIT_RESERVOIR, SkiesBiomes.BRIGHTLANDS);
            this.m_206424_(BiomeTags.f_263828_).m_206428_(SkiesBiomeTags.EVERDAWN);
            this.m_206424_(BiomeTags.f_215809_).m_206428_(SkiesBiomeTags.EVERDAWN);
            this.m_206424_(BiomeTags.f_215808_).m_206428_(SkiesBiomeTags.EVERBRIGHT);
            this.m_206424_(BiomeTags.f_263748_).m_206428_(SkiesBiomeTags.EVERBRIGHT);
            this.m_206424_(BiomeTags.f_263794_).m_206428_(SkiesBiomeTags.EVERBRIGHT);
            this.add((TagKey<Biome>)BiomeTags.f_215803_, SkiesBiomes.PEEKING_OCEAN, SkiesBiomes.DEEP_PEEKING_OCEAN, SkiesBiomes.BRUMBLE_FOREST, SkiesBiomes.RISING_CREEK, SkiesBiomes.MOONLIT_RESERVOIR);
        }

        private void forge() {
        }

        private void add(TagKey<Biome> tag, Collection<Registrar.Pointer<Biome>> list) {
            this.m_206424_(tag).m_211101_((ResourceKey[])list.stream().map(r -> r.getKey()).toArray(ResourceKey[]::new));
        }

        private void add(TagKey<Biome> tag, Registrar.Pointer<Biome> ... registrars) {
            this.m_206424_(tag).m_211101_((ResourceKey[])Arrays.stream(registrars).map(r -> r.getKey()).toArray(ResourceKey[]::new));
        }

        public String m_6055_() {
            return "Blue Skies Biome Tags";
        }
    }

    public static class StructureTagProv
    extends StructureTagsProvider {
        public StructureTagProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "blue_skies", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.blueSkies();
            this.vanilla();
            this.forge();
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            SkiesEntityTags.init();
            return super.m_213708_(cache);
        }

        private void blueSkies() {
            this.allConfigured(SkiesStructureTags.ON_BLINDING_MAPS, SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON, SkiesStructures.EVERDAWN_BLINDING_DUNGEON);
            this.allConfigured(SkiesStructureTags.ON_NATURE_MAPS, SkiesStructures.NATURE_DUNGEON);
            this.allConfigured(SkiesStructureTags.ON_POISON_MAPS, SkiesStructures.POISON_DUNGEON);
            this.allConfigured(SkiesStructureTags.ON_BUNKER_MAPS, SkiesStructures.FROZEN_BUNKER);
            this.allConfigured(SkiesStructureTags.GATEKEEPER_HOUSES, SkiesStructures.GATEKEEPER_HOUSE);
            this.allConfigured(SkiesStructureTags.DUNGEONS, SkiesStructures.EVERBRIGHT_BLINDING_DUNGEON, SkiesStructures.EVERDAWN_BLINDING_DUNGEON, SkiesStructures.NATURE_DUNGEON, SkiesStructures.POISON_DUNGEON);
            this.m_206424_(SkiesStructureTags.TREE_DISALLOWED).addTags(new TagKey[]{SkiesStructureTags.ON_NATURE_MAPS}).m_211101_((ResourceKey[])SkiesStructures.BLUE_SKIES_VILLAGE.getStructures().entrySet().stream().filter(e -> e.getKey() != SkiesVillageBiomes.SHADED_WOODLANDS.toString()).map(e -> ((Registrar.Pointer)e.getValue()).getKey()).toArray(ResourceKey[]::new));
        }

        private void vanilla() {
            this.allConfigured((TagKey<Structure>)StructureTags.f_215889_, SkiesStructures.BLUE_SKIES_VILLAGE);
        }

        private void forge() {
        }

        private void allConfigured(TagKey<Structure> tagKey, StructureRegistrar<?> ... registrars) {
            TagsProvider.TagAppender appender = this.m_206424_(tagKey);
            for (StructureRegistrar<?> entry : registrars) {
                entry.getStructures().values().forEach(r -> appender.m_255204_(r.getKey()));
            }
        }

        public String m_6055_() {
            return "Blue Skies Structure Tags";
        }
    }

    public static class EntityTagProv
    extends EntityTypeTagsProvider {
        public EntityTagProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "blue_skies", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.blueSkies();
            this.vanilla();
            this.forge();
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            SkiesEntityTags.init();
            return super.m_213708_(cache);
        }

        private void blueSkies() {
            this.m_206424_(SkiesEntityTags.FROST_SPIRITS).m_255179_((Object[])new EntityType[]{SkiesEntityTypes.FROST_SPIRIT, SkiesEntityTypes.ARMORED_FROST_SPIRIT, SkiesEntityTypes.CRYNOCEROUS});
            this.m_206424_(SkiesEntityTags.BOSSES).m_255179_((Object[])new EntityType[]{SkiesEntityTypes.SUMMONER, SkiesEntityTypes.ALCHEMIST, SkiesEntityTypes.STARLIT_CRUSHER, SkiesEntityTypes.ARACHNARCH});
            this.m_206424_(SkiesEntityTags.NATURE_ALLIES).m_255179_((Object[])new EntityType[]{SkiesEntityTypes.STARLIT_CRUSHER, SkiesEntityTypes.SPEWTER, SkiesEntityTypes.SNOW_OWL, SkiesEntityTypes.ENT_WALL, SkiesEntityTypes.ENT_ROOT, SkiesEntityTypes.ENT_LEAF, SkiesEntityTypes.STONELET});
            this.m_206424_(SkiesEntityTags.POISON_ALLIES).m_255179_((Object[])new EntityType[]{SkiesEntityTypes.ARACHNARCH, SkiesEntityTypes.NESTED_SPIDER, SkiesEntityTypes.VENOM_SPIT, SkiesEntityTypes.VENOM_SPIDER, EntityType.f_20479_, EntityType.f_20554_});
        }

        private void vanilla() {
            this.m_206424_(EntityTypeTags.f_13121_).m_255179_((Object[])new EntityType[]{SkiesEntityTypes.SUMMONER, SkiesEntityTypes.ALCHEMIST});
            this.m_206424_(EntityTypeTags.f_13124_).m_255179_((Object[])new EntityType[]{SkiesEntityTypes.SPEAR, SkiesEntityTypes.VENOM_SPIT, SkiesEntityTypes.ENT_LEAF});
            this.m_206424_(EntityTypeTags.f_144294_).m_255179_((Object[])new EntityType[]{SkiesEntityTypes.POLARGEIST, SkiesEntityTypes.SNOW_OWL}).addTags(new TagKey[]{SkiesEntityTags.BOSSES, SkiesEntityTags.FROST_SPIRITS});
            this.m_206424_(EntityTypeTags.f_144295_).m_255179_((Object[])new EntityType[]{SkiesEntityTypes.EMBERBACK, SkiesEntityTypes.SPEWTER});
            this.m_206424_(EntityTypeTags.f_144293_).m_255179_((Object[])new EntityType[]{SkiesEntityTypes.MUNICIPAL_MONKFISH, SkiesEntityTypes.GRITTLE_FLATFISH, SkiesEntityTypes.HORIZOFIN_TUNID, SkiesEntityTypes.CHARSCALE_MOKI});
            this.m_206424_(EntityTypeTags.f_144291_).m_255179_((Object[])new EntityType[]{SkiesEntityTypes.SNOW_OWL, SkiesEntityTypes.SLIV, SkiesEntityTypes.COSMIC_FOX});
        }

        private void forge() {
        }

        public String m_6055_() {
            return "Blue Skies EntityType Tags";
        }
    }

    public static class ItemTagProv
    extends ItemTagsProvider {
        public ItemTagProv(DataGenerator gen, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProv, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(gen.getPackOutput(), lookup, blockTagProv, "blue_skies", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.blueSkies();
            this.vanilla();
            this.forge();
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            SkiesItemTags.init();
            return super.m_213708_(cache);
        }

        private void blueSkies() {
            this.m_206421_(SkiesBlockTags.BOOKSHELVES, SkiesItemTags.BOOKSHELVES);
            this.m_206421_(SkiesBlockTags.CRAFTING_TABLES, SkiesItemTags.CRAFTING_TABLES);
            this.m_206421_(SkiesBlockTags.LADDERS, SkiesItemTags.LADDERS);
            this.m_206421_(SkiesBlockTags.VINES, SkiesItemTags.VINES);
            this.m_206421_(SkiesBlockTags.BLUEBRIGHT_LOGS, SkiesItemTags.BLUEBRIGHT_LOGS);
            this.m_206421_(SkiesBlockTags.STARLIT_LOGS, SkiesItemTags.STARLIT_LOGS);
            this.m_206421_(SkiesBlockTags.FROSTBRIGHT_LOGS, SkiesItemTags.FROSTBRIGHT_LOGS);
            this.m_206421_(SkiesBlockTags.LUNAR_LOGS, SkiesItemTags.LUNAR_LOGS);
            this.m_206421_(SkiesBlockTags.DUSK_LOGS, SkiesItemTags.DUSK_LOGS);
            this.m_206421_(SkiesBlockTags.MAPLE_LOGS, SkiesItemTags.MAPLE_LOGS);
            this.m_206421_(SkiesBlockTags.COMET_LOGS, SkiesItemTags.COMET_LOGS);
            this.m_206421_(SkiesBlockTags.CRYSTALLIZED_LOGS, SkiesItemTags.CRYSTALLIZED_LOGS);
            this.m_206421_(SkiesBlockTags.COBBLESTONES, SkiesItemTags.COBBLESTONES);
            this.m_206421_(SkiesBlockTags.STONES, SkiesItemTags.STONES);
            this.m_206421_(SkiesBlockTags.BLINDING_STONES, SkiesItemTags.BLINDING_STONES);
            this.m_206421_(SkiesBlockTags.POISON_STONES, SkiesItemTags.POISON_STONES);
            this.m_206421_(SkiesBlockTags.NATURE_STONES, SkiesItemTags.NATURE_STONES);
            this.m_206421_(SkiesBlockTags.AQUATIC_STONES, SkiesItemTags.AQUATIC_STONES);
            this.m_206421_(SkiesBlockTags.LIFE_STONES, SkiesItemTags.LIFE_STONES);
            this.m_206421_(SkiesBlockTags.MOONSTONE_ORES, SkiesItemTags.MOONSTONE_ORES);
            this.m_206421_(SkiesBlockTags.PYROPE_ORES, SkiesItemTags.PYROPE_ORES);
            this.m_206421_(SkiesBlockTags.DIOPSIDE_ORES, SkiesItemTags.DIOPSIDE_ORES);
            this.m_206421_(SkiesBlockTags.AQUITE_ORES, SkiesItemTags.AQUITE_ORES);
            this.m_206421_(SkiesBlockTags.CHAROITE_ORES, SkiesItemTags.CHAROITE_ORES);
            this.m_206421_(SkiesBlockTags.HORIZONITE_ORES, SkiesItemTags.HORIZONITE_ORES);
            this.m_206421_(SkiesBlockTags.FALSITE_ORES, SkiesItemTags.FALSITE_ORES);
            this.m_206421_(SkiesBlockTags.VENTIUM_ORES, SkiesItemTags.VENTIUM_ORES);
            this.m_206421_(SkiesBlockTags.MOONSTONE_BLOCKS, SkiesItemTags.MOONSTONE_BLOCKS);
            this.m_206421_(SkiesBlockTags.PYROPE_BLOCKS, SkiesItemTags.PYROPE_BLOCKS);
            this.m_206421_(SkiesBlockTags.DIOPSIDE_BLOCKS, SkiesItemTags.DIOPSIDE_BLOCKS);
            this.m_206421_(SkiesBlockTags.AQUITE_BLOCKS, SkiesItemTags.AQUITE_BLOCKS);
            this.m_206421_(SkiesBlockTags.CHAROITE_BLOCKS, SkiesItemTags.CHAROITE_BLOCKS);
            this.m_206421_(SkiesBlockTags.HORIZONITE_BLOCKS, SkiesItemTags.HORIZONITE_BLOCKS);
            this.m_206421_(SkiesBlockTags.FALSITE_BLOCKS, SkiesItemTags.FALSITE_BLOCKS);
            this.m_206421_(SkiesBlockTags.VENTIUM_BLOCKS, SkiesItemTags.VENTIUM_BLOCKS);
            this.m_206421_(SkiesBlockTags.RAW_AQUITE_BLOCKS, SkiesItemTags.RAW_AQUITE_BLOCKS);
            this.m_206421_(SkiesBlockTags.RAW_CHAROITE_BLOCKS, SkiesItemTags.RAW_CHAROITE_BLOCKS);
            this.m_206421_(SkiesBlockTags.RAW_HORIZONITE_BLOCKS, SkiesItemTags.RAW_HORIZONITE_BLOCKS);
            this.m_206421_(SkiesBlockTags.RAW_FALSITE_BLOCKS, SkiesItemTags.RAW_FALSITE_BLOCKS);
            this.m_206421_(SkiesBlockTags.RAW_VENTIUM_BLOCKS, SkiesItemTags.RAW_VENTIUM_BLOCKS);
            this.m_206421_(SkiesBlockTags.ILLAGER_TELEPORTABLE, SkiesItemTags.ILLAGER_TELEPORTABLE);
            this.m_206424_(SkiesItemTags.WOODEN_PICKAXES).m_255179_((Object[])new Item[]{SkiesItems.bluebright_pickaxe, SkiesItems.starlit_pickaxe, SkiesItems.frostbright_pickaxe, SkiesItems.lunar_pickaxe, SkiesItems.dusk_pickaxe, SkiesItems.maple_pickaxe, SkiesItems.comet_pickaxe});
            this.m_206424_(SkiesItemTags.WOODEN_SHOVELS).m_255179_((Object[])new Item[]{SkiesItems.bluebright_shovel, SkiesItems.starlit_shovel, SkiesItems.frostbright_shovel, SkiesItems.lunar_shovel, SkiesItems.dusk_shovel, SkiesItems.maple_shovel, SkiesItems.comet_shovel});
            this.m_206424_(SkiesItemTags.WOODEN_AXES).m_255179_((Object[])new Item[]{SkiesItems.bluebright_axe, SkiesItems.starlit_axe, SkiesItems.frostbright_axe, SkiesItems.lunar_axe, SkiesItems.dusk_axe, SkiesItems.maple_axe, SkiesItems.comet_axe});
            this.m_206424_(SkiesItemTags.WOODEN_HOES).m_255179_((Object[])new Item[]{SkiesItems.bluebright_hoe, SkiesItems.starlit_hoe, SkiesItems.frostbright_hoe, SkiesItems.lunar_hoe, SkiesItems.dusk_hoe, SkiesItems.maple_hoe, SkiesItems.comet_hoe});
            this.m_206424_(SkiesItemTags.WOODEN_SWORDS).m_255179_((Object[])new Item[]{SkiesItems.bluebright_sword, SkiesItems.starlit_sword, SkiesItems.frostbright_sword, SkiesItems.lunar_sword, SkiesItems.dusk_sword, SkiesItems.maple_sword, SkiesItems.comet_sword});
            this.m_206424_(SkiesItemTags.WOODEN_TOOLS).addTags(new TagKey[]{SkiesItemTags.WOODEN_PICKAXES, SkiesItemTags.WOODEN_SHOVELS, SkiesItemTags.WOODEN_AXES, SkiesItemTags.WOODEN_HOES, SkiesItemTags.WOODEN_SWORDS});
            this.m_206424_(SkiesItemTags.HORIZONITE_TOOLS).m_255179_((Object[])new Item[]{SkiesItems.horizonite_pickaxe, SkiesItems.horizonite_axe, SkiesItems.horizonite_shovel, SkiesItems.horizonite_hoe, SkiesItems.horizonite_sword});
            this.m_206424_(SkiesItemTags.PICKAXES).m_255179_((Object[])new Item[]{SkiesItems.pyrope_pickaxe, SkiesItems.diopside_pickaxe, SkiesItems.aquite_pickaxe, SkiesItems.charoite_pickaxe, SkiesItems.horizonite_pickaxe}).addTags(new TagKey[]{SkiesItemTags.WOODEN_PICKAXES});
            this.m_206424_(SkiesItemTags.AXES).m_255179_((Object[])new Item[]{SkiesItems.pyrope_axe, SkiesItems.diopside_axe, SkiesItems.aquite_axe, SkiesItems.charoite_axe, SkiesItems.horizonite_axe}).addTags(new TagKey[]{SkiesItemTags.WOODEN_AXES});
            this.m_206424_(SkiesItemTags.SHOVELS).m_255179_((Object[])new Item[]{SkiesItems.pyrope_shovel, SkiesItems.diopside_shovel, SkiesItems.aquite_shovel, SkiesItems.charoite_shovel, SkiesItems.horizonite_shovel}).addTags(new TagKey[]{SkiesItemTags.WOODEN_SHOVELS});
            this.m_206424_(SkiesItemTags.HOES).m_255179_((Object[])new Item[]{SkiesItems.pyrope_hoe, SkiesItems.diopside_hoe, SkiesItems.aquite_hoe, SkiesItems.charoite_hoe, SkiesItems.horizonite_hoe}).addTags(new TagKey[]{SkiesItemTags.WOODEN_HOES});
            this.m_206424_(SkiesItemTags.SWORDS).m_255179_((Object[])new Item[]{SkiesItems.turquoise_stone_sword, SkiesItems.lunar_stone_sword, SkiesItems.pyrope_sword, SkiesItems.diopside_sword, SkiesItems.aquite_sword, SkiesItems.charoite_sword, SkiesItems.horizonite_sword, SkiesItems.infused_arc_sword, SkiesItems.different_sword}).addTags(new TagKey[]{SkiesItemTags.WOODEN_SWORDS});
            this.m_206424_(SkiesItemTags.TOOLS).addTags(new TagKey[]{SkiesItemTags.PICKAXES, SkiesItemTags.AXES, SkiesItemTags.SHOVELS, SkiesItemTags.HOES, SkiesItemTags.SWORDS});
            this.m_206424_(SkiesItemTags.MOONSTONE).m_255245_((Object)SkiesBlocks.moonstone.m_5456_());
            this.m_206424_(SkiesItemTags.MOONSTONE_SHARD).m_255245_((Object)SkiesItems.moonstone_shard);
            this.m_206424_(SkiesItemTags.PYROPE).m_255245_((Object)SkiesItems.pyrope_gem);
            this.m_206424_(SkiesItemTags.AQUITE).m_255245_((Object)SkiesItems.aquite);
            this.m_206424_(SkiesItemTags.DIOPSIDE).m_255245_((Object)SkiesItems.diopside_gem);
            this.m_206424_(SkiesItemTags.CHAROITE).m_255245_((Object)SkiesItems.charoite);
            this.m_206424_(SkiesItemTags.HORIZONITE).m_255245_((Object)SkiesItems.horizonite_ingot);
            this.m_206424_(SkiesItemTags.FALSITE).m_255245_((Object)SkiesItems.falsite_ingot);
            this.m_206424_(SkiesItemTags.VENTIUM).m_255245_((Object)SkiesItems.ventium_ingot);
            this.m_206424_(SkiesItemTags.HORIZONITE_NUGGETS).m_255245_((Object)SkiesItems.horizonite_nugget);
            this.m_206424_(SkiesItemTags.FALSITE_NUGGETS).m_255245_((Object)SkiesItems.falsite_nugget);
            this.m_206424_(SkiesItemTags.VENTIUM_NUGGETS).m_255245_((Object)SkiesItems.ventium_nugget);
            this.m_206424_(SkiesItemTags.RAW_MATERIALS_AQUITE).m_255245_((Object)SkiesItems.raw_aquite);
            this.m_206424_(SkiesItemTags.RAW_MATERIALS_CHAROITE).m_255245_((Object)SkiesItems.raw_charoite);
            this.m_206424_(SkiesItemTags.RAW_MATERIALS_HORIZONITE).m_255245_((Object)SkiesItems.raw_horizonite);
            this.m_206424_(SkiesItemTags.RAW_MATERIALS_FALSITE).m_255245_((Object)SkiesItems.raw_falsite);
            this.m_206424_(SkiesItemTags.RAW_MATERIALS_VENTIUM).m_255245_((Object)SkiesItems.raw_ventium);
            this.m_206424_(SkiesItemTags.DUNGEON_KEYS).m_255179_((Object[])new Item[]{SkiesItems.blinding_key, SkiesItems.nature_key, SkiesItems.poison_key});
            this.m_206424_(SkiesItemTags.ARCS).m_255179_((Object[])new Item[]{SkiesItems.ethereal_arc, SkiesItems.dusk_arc, SkiesItems.nature_arc, SkiesItems.poison_arc, SkiesItems.aquatic_arc, SkiesItems.life_arc, SkiesItems.runic_arc});
            this.m_206424_(SkiesItemTags.COMET_GRASS_DROPS);
            this.m_206424_(SkiesItemTags.TURQUOISE_GRASS_DROPS).m_255179_((Object[])new Item[]{SkiesItems.pine_fruit_seeds, SkiesItems.winter_leaf_seeds});
            this.m_206424_(SkiesItemTags.LUNAR_GRASS_DROPS).m_255179_((Object[])new Item[]{SkiesItems.scalefruit_seeds, SkiesItems.fiery_bean_seeds});
            this.m_206424_(SkiesItemTags.TROUGH_FOODS).m_255179_((Object[])new Item[]{Items.f_42405_, Items.f_42619_, SkiesItems.pine_fruit, SkiesItems.scalefruit});
        }

        private void vanilla() {
            this.m_206421_(BlockTags.f_13035_, ItemTags.f_13143_);
            this.m_206421_(BlockTags.f_13106_, ItemTags.f_13182_);
            this.m_206421_(BlockTags.f_13105_, ItemTags.f_13181_);
            this.m_206421_(BlockTags.f_13104_, ItemTags.f_13180_);
            this.m_206421_(BlockTags.f_13031_, ItemTags.f_13139_);
            this.m_206421_(BlockTags.f_13037_, ItemTags.f_13145_);
            this.m_206421_(BlockTags.f_13030_, ItemTags.f_13138_);
            this.m_206421_(BlockTags.f_13032_, ItemTags.f_13140_);
            this.m_206421_(BlockTags.f_13092_, ItemTags.f_13170_);
            this.m_206421_(BlockTags.f_13093_, ItemTags.f_13171_);
            this.m_206421_(BlockTags.f_13095_, ItemTags.f_13173_);
            this.m_206421_(BlockTags.f_13103_, ItemTags.f_13179_);
            this.m_206421_(BlockTags.f_13098_, ItemTags.f_13176_);
            this.m_206421_(BlockTags.f_13100_, ItemTags.f_13177_);
            this.m_206421_(BlockTags.f_13097_, ItemTags.f_13175_);
            this.m_206421_(BlockTags.f_13096_, ItemTags.f_13174_);
            this.m_206421_(BlockTags.f_13102_, ItemTags.f_13178_);
            this.m_206421_(BlockTags.f_13036_, ItemTags.f_13144_);
            this.m_206421_(BlockTags.f_13090_, ItemTags.f_13168_);
            this.m_206421_(BlockTags.f_13029_, ItemTags.f_13137_);
            this.m_206421_(BlockTags.f_13066_, ItemTags.f_13157_);
            this.m_206421_(BlockTags.f_243838_, ItemTags.f_244389_);
            this.m_206421_(BlockTags.f_144263_, ItemTags.f_144317_);
            this.m_206424_(ItemTags.f_13150_).m_255179_((Object[])new Item[]{SkiesItems.warding_pearl, SkiesItems.soul_fragment});
            this.m_206424_(ItemTags.f_13156_).m_255179_((Object[])new Item[]{SkiesItems.grittle_flatfish, SkiesItems.cooked_grittle_flatfish, SkiesItems.municipal_monkfish, SkiesItems.cooked_municipal_monkfish, SkiesItems.charscale_moki, SkiesItems.cooked_charscale_moki, SkiesItems.horizofin_tunid, SkiesItems.cooked_horizofin_tunid});
            this.m_206424_(ItemTags.f_13164_).m_255179_((Object[])new Item[]{SkiesItems.pyrope_gem, SkiesItems.aquite, SkiesItems.diopside_gem, SkiesItems.charoite, SkiesItems.falsite_ingot, SkiesItems.ventium_ingot, SkiesItems.horizonite_ingot});
            this.addMatching((TagKey<Item>)ItemTags.f_13158_, i -> i instanceof RecordItem);
            this.m_206424_(ItemTags.f_271388_).m_206428_(SkiesItemTags.SWORDS);
            this.m_206424_(ItemTags.f_271360_).m_206428_(SkiesItemTags.PICKAXES);
            this.m_206424_(ItemTags.f_271207_).m_206428_(SkiesItemTags.AXES);
            this.m_206424_(ItemTags.f_271138_).m_206428_(SkiesItemTags.SHOVELS);
            this.m_206424_(ItemTags.f_271298_).m_206428_(SkiesItemTags.HOES);
            this.m_206424_(ItemTags.f_279581_).m_255179_((Object[])new Item[]{SkiesItems.pine_fruit_seeds, SkiesItems.winter_leaf_seeds, SkiesItems.scalefruit_seeds, SkiesItems.fiery_bean_seeds, SkiesItems.cryo_root, SkiesItems.solnut});
            this.m_206424_(ItemTags.f_265942_).m_255179_((Object[])new Item[]{SkiesItems.pyrope_helmet, SkiesItems.aquite_helmet, SkiesItems.horizonite_helmet, SkiesItems.charoite_helmet, SkiesItems.diopside_helmet, SkiesItems.shadow_helmet});
            this.m_206424_(ItemTags.f_265942_).m_255179_((Object[])new Item[]{SkiesItems.pyrope_chestplate, SkiesItems.aquite_chestplate, SkiesItems.horizonite_chestplate, SkiesItems.charoite_chestplate, SkiesItems.diopside_chestplate, SkiesItems.shadow_chestplate});
            this.m_206424_(ItemTags.f_265942_).m_255179_((Object[])new Item[]{SkiesItems.pyrope_leggings, SkiesItems.aquite_leggings, SkiesItems.horizonite_leggings, SkiesItems.charoite_leggings, SkiesItems.diopside_leggings, SkiesItems.shadow_leggings});
            this.m_206424_(ItemTags.f_265942_).m_255179_((Object[])new Item[]{SkiesItems.pyrope_boots, SkiesItems.aquite_boots, SkiesItems.horizonite_boots, SkiesItems.charoite_boots, SkiesItems.diopside_boots, SkiesItems.shadow_boots});
            this.m_206424_(ItemTags.f_265843_).m_255179_((Object[])new Item[]{SkiesBlocks.moonstone_crystal.m_5456_(), SkiesBlocks.sunstone_crystal.m_5456_(), SkiesItems.falsite_ingot, SkiesItems.ventium_ingot, SkiesItems.horizonite_ingot, SkiesItems.pyrope_gem, SkiesItems.aquite, SkiesItems.diopside_gem, SkiesItems.charoite});
            this.m_206424_(ItemTags.f_265940_).m_255179_((Object[])new Item[]{SkiesItems.banished_trim, SkiesItems.thwarted_trim, SkiesItems.regrowth_trim, SkiesItems.toxic_trim});
            this.m_206424_(ItemTags.f_244646_).m_255245_((Object)SkiesItems.blue_journal);
        }

        private void forge() {
            this.m_206421_(Tags.Blocks.CHESTS_WOODEN, Tags.Items.CHESTS_WOODEN);
            this.m_206421_(Tags.Blocks.COBBLESTONE, Tags.Items.COBBLESTONE);
            this.m_206421_(Tags.Blocks.STONE, Tags.Items.STONE);
            this.m_206421_(SkiesBlockTags.BOOKSHELVES, Tags.Items.BOOKSHELVES);
            this.m_206421_(Tags.Blocks.SAND, Tags.Items.SAND);
            this.m_206424_(Tags.Items.RODS_WOODEN).m_255179_((Object[])new Item[]{SkiesItems.bluebright_stick, SkiesItems.starlit_stick, SkiesItems.frostbright_stick, SkiesItems.lunar_stick, SkiesItems.dusk_stick, SkiesItems.maple_stick, SkiesItems.comet_stick});
            this.m_206421_(Tags.Blocks.STAINED_GLASS, Tags.Items.STAINED_GLASS);
            this.m_206421_(Tags.Blocks.GLASS_SILICA, Tags.Items.GLASS_SILICA);
            this.m_206421_(Tags.Blocks.STAINED_GLASS_PANES, Tags.Items.STAINED_GLASS_PANES);
            this.m_206421_(Tags.Blocks.ORES, Tags.Items.ORES);
            this.m_206421_(Tags.Blocks.ORES_EMERALD, Tags.Items.ORES_EMERALD);
            this.m_206421_(Tags.Blocks.SANDSTONE, Tags.Items.SANDSTONE);
            this.m_206421_(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS);
            this.m_206421_(Tags.Blocks.ORE_RATES_SPARSE, Tags.Items.ORE_RATES_SPARSE);
            this.m_206421_(Tags.Blocks.ORE_RATES_SINGULAR, Tags.Items.ORE_RATES_SINGULAR);
            this.m_206424_(Tags.Items.MUSHROOMS).m_255179_((Object[])new Item[]{SkiesBlocks.snowcap_pinhead.m_5456_(), SkiesBlocks.snowcap_mushroom.m_5456_(), SkiesBlocks.baneful_mushroom.m_5456_()});
            this.m_206424_(Tags.Items.CROPS).m_255179_((Object[])new Item[]{SkiesItems.pine_fruit, SkiesItems.winter_leaves, SkiesItems.cryo_root, SkiesItems.scalefruit, SkiesItems.fiery_beans, SkiesItems.solnut});
            this.m_206424_(Tags.Items.SEEDS).m_255179_((Object[])new Item[]{SkiesItems.pine_fruit_seeds, SkiesItems.winter_leaf_seeds, SkiesItems.scalefruit_seeds, SkiesItems.fiery_bean_seeds});
            this.m_206424_(Tags.Items.GEMS).addTags(new TagKey[]{SkiesItemTags.PYROPE, SkiesItemTags.DIOPSIDE, SkiesItemTags.AQUITE, SkiesItemTags.CHAROITE});
            this.m_206424_(Tags.Items.INGOTS).addTags(new TagKey[]{SkiesItemTags.HORIZONITE, SkiesItemTags.FALSITE, SkiesItemTags.VENTIUM});
            this.m_206424_(Tags.Items.NUGGETS).addTags(new TagKey[]{SkiesItemTags.HORIZONITE_NUGGETS, SkiesItemTags.FALSITE_NUGGETS, SkiesItemTags.VENTIUM_NUGGETS});
            this.m_206424_(Tags.Items.RAW_MATERIALS).addTags(new TagKey[]{SkiesItemTags.RAW_MATERIALS_AQUITE, SkiesItemTags.RAW_MATERIALS_CHAROITE, SkiesItemTags.RAW_MATERIALS_FALSITE, SkiesItemTags.RAW_MATERIALS_HORIZONITE, SkiesItemTags.RAW_MATERIALS_VENTIUM});
            this.m_206424_(Tags.Items.ENCHANTING_FUELS).m_206428_(SkiesItemTags.FALSITE_NUGGETS);
            this.m_206424_(Tags.Items.ARMORS_HELMETS).m_255179_((Object[])new Item[]{SkiesItems.pyrope_helmet, SkiesItems.aquite_helmet, SkiesItems.horizonite_helmet, SkiesItems.charoite_helmet, SkiesItems.diopside_helmet, SkiesItems.shadow_helmet});
            this.m_206424_(Tags.Items.ARMORS_CHESTPLATES).m_255179_((Object[])new Item[]{SkiesItems.pyrope_chestplate, SkiesItems.aquite_chestplate, SkiesItems.horizonite_chestplate, SkiesItems.charoite_chestplate, SkiesItems.diopside_chestplate, SkiesItems.shadow_chestplate});
            this.m_206424_(Tags.Items.ARMORS_LEGGINGS).m_255179_((Object[])new Item[]{SkiesItems.pyrope_leggings, SkiesItems.aquite_leggings, SkiesItems.horizonite_leggings, SkiesItems.charoite_leggings, SkiesItems.diopside_leggings, SkiesItems.shadow_leggings});
            this.m_206424_(Tags.Items.ARMORS_BOOTS).m_255179_((Object[])new Item[]{SkiesItems.pyrope_boots, SkiesItems.aquite_boots, SkiesItems.horizonite_boots, SkiesItems.charoite_boots, SkiesItems.diopside_boots, SkiesItems.shadow_boots});
        }

        public String m_6055_() {
            return "Blue Skies Item Tags";
        }

        private Stream<Item> getMatching(Function<Item, Boolean> condition) {
            return ForgeRegistries.ITEMS.getValues().stream().filter(block -> ForgeRegistries.ITEMS.getKey(block).m_135827_().equals("blue_skies") && (Boolean)condition.apply((Item)block) != false);
        }

        private void addMatching(TagKey<Item> itemTag, Function<Item, Boolean> condition) {
            this.getMatching(condition).forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.m_206424_(itemTag)).m_255245_(arg_0));
        }
    }

    public static class BlockTagProv
    extends BlockTagsProvider {
        public BlockTagProv(DataGenerator generatorIn, ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookup) {
            super(generatorIn.getPackOutput(), lookup, "blue_skies", existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider prov) {
            this.blueSkies(prov);
            this.vanilla(prov);
            this.forge(prov);
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            SkiesBlockTags.init();
            return super.m_213708_(cache);
        }

        private void blueSkies(HolderLookup.Provider prov) {
            this.m_206424_(SkiesBlockTags.BOOKSHELVES).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_bookshelf, SkiesBlocks.starlit_bookshelf, SkiesBlocks.frostbright_bookshelf, SkiesBlocks.lunar_bookshelf, SkiesBlocks.dusk_bookshelf, SkiesBlocks.maple_bookshelf, SkiesBlocks.comet_bookshelf});
            this.m_206424_(SkiesBlockTags.CRAFTING_TABLES).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_crafting_table, SkiesBlocks.starlit_crafting_table, SkiesBlocks.frostbright_crafting_table, SkiesBlocks.lunar_crafting_table, SkiesBlocks.dusk_crafting_table, SkiesBlocks.maple_crafting_table, SkiesBlocks.comet_crafting_table});
            this.m_206424_(SkiesBlockTags.LADDERS).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_ladder, SkiesBlocks.starlit_ladder, SkiesBlocks.frostbright_ladder, SkiesBlocks.lunar_ladder, SkiesBlocks.dusk_ladder, SkiesBlocks.maple_ladder, SkiesBlocks.comet_ladder});
            this.m_206424_(SkiesBlockTags.VINES).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_vine, SkiesBlocks.starlit_vine, SkiesBlocks.frostbright_vine, SkiesBlocks.lunar_vine, SkiesBlocks.dusk_vine, SkiesBlocks.maple_vine});
            this.m_206424_(SkiesBlockTags.BLUEBRIGHT_LOGS).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_log, SkiesBlocks.bluebright_wood, SkiesBlocks.stripped_bluebright_log, SkiesBlocks.stripped_bluebright_wood});
            this.m_206424_(SkiesBlockTags.STARLIT_LOGS).m_255179_((Object[])new Block[]{SkiesBlocks.starlit_log, SkiesBlocks.starlit_wood, SkiesBlocks.stripped_starlit_log, SkiesBlocks.stripped_starlit_wood});
            this.m_206424_(SkiesBlockTags.FROSTBRIGHT_LOGS).m_255179_((Object[])new Block[]{SkiesBlocks.frostbright_log, SkiesBlocks.frostbright_wood, SkiesBlocks.stripped_frostbright_log, SkiesBlocks.stripped_frostbright_wood});
            this.m_206424_(SkiesBlockTags.LUNAR_LOGS).m_255179_((Object[])new Block[]{SkiesBlocks.lunar_log, SkiesBlocks.lunar_wood, SkiesBlocks.stripped_lunar_log, SkiesBlocks.stripped_lunar_wood});
            this.m_206424_(SkiesBlockTags.DUSK_LOGS).m_255179_((Object[])new Block[]{SkiesBlocks.dusk_log, SkiesBlocks.dusk_wood, SkiesBlocks.stripped_dusk_log, SkiesBlocks.stripped_dusk_wood});
            this.m_206424_(SkiesBlockTags.MAPLE_LOGS).m_255179_((Object[])new Block[]{SkiesBlocks.maple_log, SkiesBlocks.maple_wood, SkiesBlocks.stripped_maple_log, SkiesBlocks.stripped_maple_wood});
            this.m_206424_(SkiesBlockTags.COMET_LOGS).m_255179_((Object[])new Block[]{SkiesBlocks.comet_log, SkiesBlocks.comet_wood, SkiesBlocks.stripped_comet_log, SkiesBlocks.stripped_comet_wood});
            this.m_206424_(SkiesBlockTags.CRYSTALLIZED_LOGS).m_255179_((Object[])new Block[]{SkiesBlocks.crystallized_log, SkiesBlocks.crystallized_wood});
            this.m_206424_(SkiesBlockTags.COBBLESTONES).m_255179_((Object[])new Block[]{SkiesBlocks.turquoise_cobblestone, SkiesBlocks.lunar_cobblestone});
            this.m_206424_(SkiesBlockTags.STONES).m_255179_((Object[])new Block[]{SkiesBlocks.turquoise_stone, SkiesBlocks.lunar_stone, SkiesBlocks.rimestone, SkiesBlocks.taratite, SkiesBlocks.umber, SkiesBlocks.cinderstone});
            this.m_206424_(SkiesBlockTags.BLINDING_STONES).m_255179_((Object[])new Block[]{SkiesBlocks.blinding_stone, SkiesBlocks.glowing_blinding_stone});
            this.m_206424_(SkiesBlockTags.POISON_STONES).m_255179_((Object[])new Block[]{SkiesBlocks.poison_stone, SkiesBlocks.glowing_poison_stone, SkiesBlocks.poison_stonebrick});
            this.m_206424_(SkiesBlockTags.NATURE_STONES).m_255179_((Object[])new Block[]{SkiesBlocks.nature_stone, SkiesBlocks.glowing_nature_stone});
            this.m_206424_(SkiesBlockTags.AQUATIC_STONES).m_255179_((Object[])new Block[]{SkiesBlocks.aquatic_stone, SkiesBlocks.glowing_aquatic_stone});
            this.m_206424_(SkiesBlockTags.LIFE_STONES).m_255179_((Object[])new Block[]{SkiesBlocks.life_stone, SkiesBlocks.glowing_life_stone});
            this.m_206424_(SkiesBlockTags.ILLAGER_TELEPORTABLE).m_255179_((Object[])new Block[]{SkiesBlocks.turquoise_stonebrick, SkiesBlocks.mossy_turquoise_stonebrick, SkiesBlocks.cracked_turquoise_stonebrick, SkiesBlocks.lunar_stonebrick, SkiesBlocks.mossy_lunar_stonebrick, SkiesBlocks.cracked_lunar_stonebrick});
            this.m_206424_(SkiesBlockTags.MOONSTONE_ORES).m_255179_((Object[])new Block[]{SkiesBlocks.everbright_moonstone_ore, SkiesBlocks.everdawn_moonstone_ore});
            this.m_206424_(SkiesBlockTags.PYROPE_ORES).m_255179_((Object[])new Block[]{SkiesBlocks.everbright_pyrope_ore, SkiesBlocks.everdawn_pyrope_ore});
            this.m_206424_(SkiesBlockTags.DIOPSIDE_ORES).m_255179_((Object[])new Block[]{SkiesBlocks.everbright_diopside_ore, SkiesBlocks.everdawn_diopside_ore});
            this.m_206424_(SkiesBlockTags.AQUITE_ORES).m_255179_((Object[])new Block[]{SkiesBlocks.everbright_aquite_ore, SkiesBlocks.everdawn_aquite_ore});
            this.m_206424_(SkiesBlockTags.CHAROITE_ORES).m_255179_((Object[])new Block[]{SkiesBlocks.everbright_charoite_ore, SkiesBlocks.everdawn_charoite_ore});
            this.m_206424_(SkiesBlockTags.HORIZONITE_ORES).m_255245_((Object)SkiesBlocks.horizonite_ore);
            this.m_206424_(SkiesBlockTags.FALSITE_ORES).m_255245_((Object)SkiesBlocks.falsite_ore);
            this.m_206424_(SkiesBlockTags.VENTIUM_ORES).m_255179_((Object[])new Block[]{SkiesBlocks.ventium_ore, SkiesBlocks.ventium_ore});
            this.m_206424_(SkiesBlockTags.MOONSTONE_BLOCKS).m_255245_((Object)SkiesBlocks.moonstone_block);
            this.m_206424_(SkiesBlockTags.PYROPE_BLOCKS).m_255245_((Object)SkiesBlocks.pyrope_block);
            this.m_206424_(SkiesBlockTags.DIOPSIDE_BLOCKS).m_255245_((Object)SkiesBlocks.diopside_block);
            this.m_206424_(SkiesBlockTags.AQUITE_BLOCKS).m_255245_((Object)SkiesBlocks.aquite_block);
            this.m_206424_(SkiesBlockTags.CHAROITE_BLOCKS).m_255245_((Object)SkiesBlocks.charoite_block);
            this.m_206424_(SkiesBlockTags.HORIZONITE_BLOCKS).m_255245_((Object)SkiesBlocks.horizonite_block);
            this.m_206424_(SkiesBlockTags.FALSITE_BLOCKS).m_255245_((Object)SkiesBlocks.falsite_block);
            this.m_206424_(SkiesBlockTags.VENTIUM_BLOCKS).m_255245_((Object)SkiesBlocks.ventium_block);
            this.m_206424_(SkiesBlockTags.RAW_AQUITE_BLOCKS).m_255245_((Object)SkiesBlocks.raw_aquite_block);
            this.m_206424_(SkiesBlockTags.RAW_CHAROITE_BLOCKS).m_255245_((Object)SkiesBlocks.raw_charoite_block);
            this.m_206424_(SkiesBlockTags.RAW_HORIZONITE_BLOCKS).m_255245_((Object)SkiesBlocks.raw_horizonite_block);
            this.m_206424_(SkiesBlockTags.RAW_FALSITE_BLOCKS).m_255245_((Object)SkiesBlocks.raw_falsite_block);
            this.m_206424_(SkiesBlockTags.RAW_VENTIUM_BLOCKS).m_255245_((Object)SkiesBlocks.raw_ventium_block);
            this.m_206424_(SkiesBlockTags.CARVER_REPLACEABLES).m_255179_((Object[])new Block[]{SkiesBlocks.lunar_mud, Blocks.f_49994_}).addTags(new TagKey[]{SkiesBlockTags.STONES, BlockTags.f_144274_, Tags.Blocks.SANDSTONE, BlockTags.f_144279_, BlockTags.f_13047_, BlockTags.f_144274_, BlockTags.f_13029_});
            this.m_206424_(SkiesBlockTags.BLUE_FIRE_BASE_BLOCKS).m_255245_((Object)SkiesBlocks.chiseled_turquoise_stonebrick);
            this.m_206424_(SkiesBlockTags.BLACK_FIRE_BASE_BLOCKS).m_255245_((Object)SkiesBlocks.chiseled_lunar_stonebrick);
            this.m_206424_(SkiesBlockTags.WEBBING_ATTACHES_TO).m_255179_((Object[])new Block[]{SkiesBlocks.spider_webbing, Blocks.f_50033_, SkiesBlocks.poison_keystone});
        }

        private void vanilla(HolderLookup.Provider prov) {
            this.addMatching((TagKey<Block>)BlockTags.f_13045_, b -> b instanceof FlowerPotBlock);
            this.m_206424_(BlockTags.f_13049_).m_255179_((Object[])new Block[]{SkiesBlocks.crystal_glass, SkiesBlocks.midnight_glass});
            this.addMatching((TagKey<Block>)BlockTags.f_13035_, b -> b instanceof LeavesBlock);
            this.m_206424_(BlockTags.f_13106_).m_255179_((Object[])new Block[]{SkiesBlocks.crystallized_log, SkiesBlocks.crystallized_wood});
            this.m_206424_(BlockTags.f_13105_).addTags(new TagKey[]{SkiesBlockTags.BLUEBRIGHT_LOGS, SkiesBlockTags.STARLIT_LOGS, SkiesBlockTags.FROSTBRIGHT_LOGS, SkiesBlockTags.LUNAR_LOGS, SkiesBlockTags.DUSK_LOGS, SkiesBlockTags.MAPLE_LOGS, SkiesBlockTags.COMET_LOGS});
            this.addMatching((TagKey<Block>)BlockTags.f_13104_, b -> b instanceof SaplingBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13048_, b -> b instanceof GrassBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13032_, b -> b instanceof WallBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13031_, b -> b instanceof SlabBlock);
            this.m_206424_(BlockTags.f_13097_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_slab, SkiesBlocks.starlit_slab, SkiesBlocks.frostbright_slab, SkiesBlocks.lunar_slab, SkiesBlocks.dusk_slab, SkiesBlocks.maple_slab, SkiesBlocks.comet_slab});
            this.addMatching((TagKey<Block>)BlockTags.f_13037_, b -> (b instanceof FlowerBlock || b instanceof LargeFlowerBlock) && b != SkiesBlocks.muckweed && b != SkiesBlocks.brittlebush);
            this.addMatching((TagKey<Block>)BlockTags.f_13030_, b -> b instanceof StairBlock);
            this.m_206424_(BlockTags.f_13096_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_stairs, SkiesBlocks.starlit_stairs, SkiesBlocks.frostbright_stairs, SkiesBlocks.lunar_stairs, SkiesBlocks.dusk_stairs, SkiesBlocks.maple_stairs, SkiesBlocks.comet_stairs});
            this.m_206424_(BlockTags.f_13093_).m_255179_((Object[])new Block[]{SkiesBlocks.turquoise_stone_button, SkiesBlocks.lunar_stone_button});
            this.m_206424_(BlockTags.f_13092_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_button, SkiesBlocks.starlit_button, SkiesBlocks.frostbright_button, SkiesBlocks.lunar_button, SkiesBlocks.dusk_button, SkiesBlocks.maple_button, SkiesBlocks.comet_button});
            this.m_206424_(BlockTags.f_13103_).m_255245_((Object)SkiesBlocks.crystallized_door);
            this.m_206424_(BlockTags.f_13095_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_door, SkiesBlocks.starlit_door, SkiesBlocks.frostbright_door, SkiesBlocks.lunar_door, SkiesBlocks.dusk_door, SkiesBlocks.maple_door, SkiesBlocks.comet_door});
            this.m_206424_(BlockTags.f_13095_).m_255245_((Object)SkiesBlocks.crystallized_door);
            this.m_206424_(BlockTags.f_13098_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_fence, SkiesBlocks.starlit_fence, SkiesBlocks.frostbright_fence, SkiesBlocks.lunar_fence, SkiesBlocks.dusk_fence, SkiesBlocks.maple_fence, SkiesBlocks.comet_fence});
            this.m_206424_(BlockTags.f_13055_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_fence_gate, SkiesBlocks.starlit_fence_gate, SkiesBlocks.frostbright_fence_gate, SkiesBlocks.lunar_fence_gate, SkiesBlocks.dusk_fence_gate, SkiesBlocks.maple_fence_gate, SkiesBlocks.comet_fence_gate});
            this.m_206424_(BlockTags.f_13099_).m_255179_((Object[])new Block[]{SkiesBlocks.turquoise_stone_pressure_plate, SkiesBlocks.lunar_stone_pressure_plate});
            this.m_206424_(BlockTags.f_13100_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_pressure_plate, SkiesBlocks.starlit_pressure_plate, SkiesBlocks.frostbright_pressure_plate, SkiesBlocks.lunar_pressure_plate, SkiesBlocks.dusk_pressure_plate, SkiesBlocks.maple_pressure_plate, SkiesBlocks.comet_pressure_plate});
            this.m_206424_(BlockTags.f_13036_).m_255245_((Object)SkiesBlocks.crystallized_trapdoor);
            this.m_206424_(BlockTags.f_13102_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_trapdoor, SkiesBlocks.starlit_trapdoor, SkiesBlocks.frostbright_trapdoor, SkiesBlocks.lunar_trapdoor, SkiesBlocks.dusk_trapdoor, SkiesBlocks.maple_trapdoor, SkiesBlocks.comet_trapdoor});
            this.addMatching((TagKey<Block>)BlockTags.f_13066_, b -> b instanceof StandingSignBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_13067_, b -> b instanceof WallSignBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_243838_, b -> b instanceof CeilingHangingSignBlock);
            this.addMatching((TagKey<Block>)BlockTags.f_244544_, b -> b instanceof WallHangingSignBlock);
            this.m_206424_(BlockTags.f_13042_).m_255179_((Object[])new Block[]{SkiesBlocks.warding_pearl, SkiesBlocks.wall_warding_pearl});
            this.m_206424_(BlockTags.f_13090_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_planks, SkiesBlocks.starlit_planks, SkiesBlocks.frostbright_planks, SkiesBlocks.lunar_planks, SkiesBlocks.dusk_planks, SkiesBlocks.maple_planks, SkiesBlocks.comet_planks});
            this.m_206424_(BlockTags.f_13082_).addTags(new TagKey[]{SkiesBlockTags.LADDERS, SkiesBlockTags.VINES});
            this.m_206424_(BlockTags.f_13079_).addTags(new TagKey[]{SkiesBlockTags.PYROPE_BLOCKS, SkiesBlockTags.DIOPSIDE_BLOCKS, SkiesBlockTags.AQUITE_BLOCKS, SkiesBlockTags.CHAROITE_BLOCKS, SkiesBlockTags.HORIZONITE_BLOCKS, SkiesBlockTags.FALSITE_BLOCKS, SkiesBlockTags.VENTIUM_BLOCKS});
            this.m_206424_(BlockTags.f_144274_).m_255179_((Object[])new Block[]{SkiesBlocks.turquoise_grass_block, SkiesBlocks.lunar_grass_block, SkiesBlocks.turquoise_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.turquoise_comet_grass_block, SkiesBlocks.lunar_comet_grass_block});
            this.m_206424_(BlockTags.f_13081_).m_255245_((Object)SkiesBlocks.moonstone);
            this.m_206424_(BlockTags.f_13029_).m_255179_((Object[])new Block[]{SkiesBlocks.crystal_sand, SkiesBlocks.midnight_sand});
            this.m_206424_(BlockTags.f_144263_).m_255179_((Object[])new Block[]{SkiesBlocks.everbright_emerald_ore, SkiesBlocks.everdawn_emerald_ore});
            this.m_206424_(BlockTags.f_144276_).m_206428_(SkiesBlockTags.STONES);
            this.m_206424_(BlockTags.f_215823_).m_206428_(SkiesBlockTags.STONES);
            this.m_206424_(BlockTags.f_13073_).m_255179_((Object[])new Block[]{SkiesBlocks.winter_leaves, SkiesBlocks.pine_fruits, SkiesBlocks.cryo_roots, SkiesBlocks.solnuts, SkiesBlocks.scalefruits, SkiesBlocks.fiery_beans});
            this.m_206424_(BlockTags.f_215837_).m_255179_((Object[])new Block[]{SkiesBlocks.chilled_lily_pad, SkiesBlocks.moonlit_water_lily});
            this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{SkiesBlocks.turquoise_stone, SkiesBlocks.turquoise_cobblestone, SkiesBlocks.mossy_turquoise_cobblestone, SkiesBlocks.turquoise_stonebrick, SkiesBlocks.mossy_turquoise_stonebrick, SkiesBlocks.cracked_turquoise_stonebrick, SkiesBlocks.chiseled_turquoise_stonebrick, SkiesBlocks.taratite, SkiesBlocks.polished_taratite, SkiesBlocks.rimestone, SkiesBlocks.polished_rimestone, SkiesBlocks.polished_brumble, SkiesBlocks.polished_brumble_bricks, SkiesBlocks.chiseled_polished_brumble, SkiesBlocks.brumble_lantern, SkiesBlocks.midnight_sandstone, SkiesBlocks.chiseled_midnight_sandstone, SkiesBlocks.cut_midnight_sandstone, SkiesBlocks.smooth_midnight_sandstone, SkiesBlocks.midnight_sandstone_pillar, SkiesBlocks.turquoise_dripstone, SkiesBlocks.everbright_diopside_ore, SkiesBlocks.everbright_pyrope_ore, SkiesBlocks.everbright_aquite_ore, SkiesBlocks.everbright_charoite_ore, SkiesBlocks.everbright_moonstone_ore, SkiesBlocks.everbright_emerald_ore, SkiesBlocks.falsite_ore, SkiesBlocks.ventium_ore, SkiesBlocks.lunar_stone, SkiesBlocks.lunar_cobblestone, SkiesBlocks.mossy_lunar_cobblestone, SkiesBlocks.lunar_stonebrick, SkiesBlocks.mossy_lunar_stonebrick, SkiesBlocks.cracked_lunar_stonebrick, SkiesBlocks.chiseled_lunar_stonebrick, SkiesBlocks.umber, SkiesBlocks.polished_umber, SkiesBlocks.cinderstone, SkiesBlocks.polished_cinderstone, SkiesBlocks.crystallized_grass, SkiesBlocks.crystallized_leaves, SkiesBlocks.crystallized_log, SkiesBlocks.crystallized_wood, SkiesBlocks.crystallized_planks, SkiesBlocks.vitreous_moonstone, SkiesBlocks.crystal_sandstone, SkiesBlocks.chiseled_crystal_sandstone, SkiesBlocks.cut_crystal_sandstone, SkiesBlocks.smooth_crystal_sandstone, SkiesBlocks.crystal_sandstone_pillar, SkiesBlocks.lunar_dripstone, SkiesBlocks.decaying_spike, SkiesBlocks.everdawn_diopside_ore, SkiesBlocks.everdawn_pyrope_ore, SkiesBlocks.everdawn_aquite_ore, SkiesBlocks.everdawn_charoite_ore, SkiesBlocks.everdawn_moonstone_ore, SkiesBlocks.everdawn_emerald_ore, SkiesBlocks.horizonite_ore, SkiesBlocks.comet_berry_pie, SkiesBlocks.raw_falsite_block, SkiesBlocks.raw_ventium_block, SkiesBlocks.raw_horizonite_block, SkiesBlocks.raw_aquite_block, SkiesBlocks.raw_charoite_block, SkiesBlocks.moonstone_block, SkiesBlocks.sunstone_block, SkiesBlocks.falsite_block, SkiesBlocks.ventium_block, SkiesBlocks.horizonite_block, SkiesBlocks.pyrope_block, SkiesBlocks.aquite_block, SkiesBlocks.diopside_block, SkiesBlocks.charoite_block, SkiesBlocks.moonstone, SkiesBlocks.warding_pearl, SkiesBlocks.wall_warding_pearl, SkiesBlocks.moonstone_crystal, SkiesBlocks.sunstone_crystal, SkiesBlocks.snowcap_oven, SkiesBlocks.horizonite_forge, SkiesBlocks.crystallized_door, SkiesBlocks.crystallized_trapdoor, SkiesBlocks.moonstone_pressure_plate, SkiesBlocks.turquoise_stone_pressure_plate, SkiesBlocks.lunar_stone_pressure_plate, SkiesBlocks.crystallized_pressure_plate, SkiesBlocks.turquoise_stone_button, SkiesBlocks.lunar_stone_button, SkiesBlocks.crystallized_button, SkiesBlocks.summoner_trophy, SkiesBlocks.alchemist_trophy, SkiesBlocks.arachnarch_trophy, SkiesBlocks.starlit_crusher_trophy, SkiesBlocks.crystallized_slab, SkiesBlocks.turquoise_stone_slab, SkiesBlocks.turquoise_cobblestone_slab, SkiesBlocks.mossy_turquoise_cobblestone_slab, SkiesBlocks.turquoise_stonebrick_slab, SkiesBlocks.mossy_turquoise_stonebrick_slab, SkiesBlocks.cracked_turquoise_stonebrick_slab, SkiesBlocks.midnight_sandstone_slab, SkiesBlocks.smooth_midnight_sandstone_slab, SkiesBlocks.polished_brumble_slab, SkiesBlocks.polished_brumble_brick_slab, SkiesBlocks.taratite_slab, SkiesBlocks.polished_taratite_slab, SkiesBlocks.rimestone_slab, SkiesBlocks.polished_rimestone_slab, SkiesBlocks.lunar_stone_slab, SkiesBlocks.lunar_cobblestone_slab, SkiesBlocks.mossy_lunar_cobblestone_slab, SkiesBlocks.lunar_stonebrick_slab, SkiesBlocks.mossy_lunar_stonebrick_slab, SkiesBlocks.cracked_lunar_stonebrick_slab, SkiesBlocks.crystal_sandstone_slab, SkiesBlocks.smooth_crystal_sandstone_slab, SkiesBlocks.cut_midnight_sandstone_slab, SkiesBlocks.cut_crystal_sandstone_slab, SkiesBlocks.umber_slab, SkiesBlocks.polished_umber_slab, SkiesBlocks.cinderstone_slab, SkiesBlocks.polished_cinderstone_slab, SkiesBlocks.crystallized_stairs, SkiesBlocks.turquoise_stone_stairs, SkiesBlocks.turquoise_stonebrick_stairs, SkiesBlocks.mossy_turquoise_stonebrick_stairs, SkiesBlocks.cracked_turquoise_stonebrick_stairs, SkiesBlocks.turquoise_cobblestone_stairs, SkiesBlocks.mossy_turquoise_cobblestone_stairs, SkiesBlocks.midnight_sandstone_stairs, SkiesBlocks.smooth_midnight_sandstone_stairs, SkiesBlocks.polished_brumble_stairs, SkiesBlocks.polished_brumble_brick_stairs, SkiesBlocks.taratite_stairs, SkiesBlocks.polished_taratite_stairs, SkiesBlocks.rimestone_stairs, SkiesBlocks.polished_rimestone_stairs, SkiesBlocks.lunar_stone_stairs, SkiesBlocks.lunar_stonebrick_stairs, SkiesBlocks.mossy_lunar_stonebrick_stairs, SkiesBlocks.cracked_lunar_stonebrick_stairs, SkiesBlocks.lunar_cobblestone_stairs, SkiesBlocks.mossy_lunar_cobblestone_stairs, SkiesBlocks.crystal_sandstone_stairs, SkiesBlocks.smooth_crystal_sandstone_stairs, SkiesBlocks.umber_stairs, SkiesBlocks.polished_umber_stairs, SkiesBlocks.cinderstone_stairs, SkiesBlocks.polished_cinderstone_stairs, SkiesBlocks.star_emitter});
            this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{SkiesBlocks.brumble_block, SkiesBlocks.brumble_slab, SkiesBlocks.brumble_stairs, SkiesBlocks.brumble_wall});
            this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{SkiesBlocks.blinding_stone, SkiesBlocks.glowing_blinding_stone, SkiesBlocks.carved_blinding_stone, SkiesBlocks.blinding_stone_pillar, SkiesBlocks.blinding_stairs, SkiesBlocks.glowing_blinding_stairs, SkiesBlocks.blinding_slab, SkiesBlocks.glowing_blinding_slab, SkiesBlocks.blinding_wall, SkiesBlocks.glowing_blinding_wall});
            this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{SkiesBlocks.nature_stone, SkiesBlocks.glowing_nature_stone, SkiesBlocks.nature_stonebrick, SkiesBlocks.glowing_nature_stonebrick, SkiesBlocks.carved_nature_stonebrick, SkiesBlocks.nature_stone_pillar, SkiesBlocks.nature_stone_stairs, SkiesBlocks.glowing_nature_stone_stairs, SkiesBlocks.nature_stonebrick_stairs, SkiesBlocks.glowing_nature_stonebrick_stairs, SkiesBlocks.nature_stone_slab, SkiesBlocks.glowing_nature_stone_slab, SkiesBlocks.nature_stonebrick_slab, SkiesBlocks.glowing_nature_stonebrick_slab, SkiesBlocks.nature_stonebrick_wall, SkiesBlocks.glowing_nature_stonebrick_wall});
            this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{SkiesBlocks.poison_stone, SkiesBlocks.glowing_poison_stone, SkiesBlocks.poison_stonebrick, SkiesBlocks.rough_poison_stonebrick, SkiesBlocks.carved_poison_stonebrick, SkiesBlocks.spider_nest, SkiesBlocks.poison_stone_pillar, SkiesBlocks.poison_stone_stairs, SkiesBlocks.glowing_poison_stone_stairs, SkiesBlocks.poison_stonebrick_stairs, SkiesBlocks.rough_poison_stonebrick_stairs, SkiesBlocks.poison_stone_slab, SkiesBlocks.glowing_poison_stone_slab, SkiesBlocks.poison_stonebrick_slab, SkiesBlocks.rough_poison_stonebrick_slab, SkiesBlocks.poison_stonebrick_wall});
            this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{SkiesBlocks.aquatic_stone, SkiesBlocks.glowing_aquatic_stone, SkiesBlocks.aquatic_stairs, SkiesBlocks.glowing_aquatic_stairs, SkiesBlocks.aquatic_slab, SkiesBlocks.glowing_aquatic_slab, SkiesBlocks.moonstone_lantern});
            this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{SkiesBlocks.life_stone, SkiesBlocks.glowing_life_stone, SkiesBlocks.life_stairs, SkiesBlocks.glowing_life_stairs, SkiesBlocks.life_slab, SkiesBlocks.glowing_life_slab, SkiesBlocks.life_wall, SkiesBlocks.glowing_life_wall});
            this.m_206424_(BlockTags.f_144282_).m_255179_((Object[])new Block[]{SkiesBlocks.bright_blinding_keystone, SkiesBlocks.dawn_blinding_keystone, SkiesBlocks.nature_keystone, SkiesBlocks.poison_keystone});
            this.m_206424_(BlockTags.f_144280_).addTags(new TagKey[]{SkiesBlockTags.VINES, SkiesBlockTags.CRAFTING_TABLES, SkiesBlockTags.BOOKSHELVES, SkiesBlockTags.LADDERS});
            this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_chest, SkiesBlocks.starlit_chest, SkiesBlocks.frostbright_chest, SkiesBlocks.lunar_chest, SkiesBlocks.dusk_chest, SkiesBlocks.maple_chest, SkiesBlocks.comet_chest});
            this.m_206424_(BlockTags.f_144280_).m_255179_((Object[])new Block[]{SkiesBlocks.brumble_vine, SkiesBlocks.brumble_vine_top, SkiesBlocks.snowcap_pinhead, SkiesBlocks.snowcap_mushroom, SkiesBlocks.snowcap_mushroom_block, SkiesBlocks.snowcap_mushroom_stem, SkiesBlocks.baneful_mushroom, SkiesBlocks.brewberry_bush, SkiesBlocks.chilled_lily_pad, SkiesBlocks.moonlit_water_lily, SkiesBlocks.crescent_fruit, SkiesBlocks.lunar_grass, SkiesBlocks.tall_lunar_grass, SkiesBlocks.turquoise_grass, SkiesBlocks.tall_turquoise_grass, SkiesBlocks.comet_grass, SkiesBlocks.muckweed, SkiesBlocks.chillweed, SkiesBlocks.brittlebush, SkiesBlocks.glimmer_reed, SkiesBlocks.trough, SkiesBlocks.tool_box, SkiesBlocks.summoning_table, SkiesBlocks.alchemy_table, SkiesBlocks.food_prep_table});
            this.m_206424_(BlockTags.f_144283_).m_255179_((Object[])new Block[]{SkiesBlocks.turquoise_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.lunar_grass_block, SkiesBlocks.turquoise_comet_grass_block, SkiesBlocks.lunar_comet_grass_block, SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.coarse_lunar_dirt, (Block)SkiesBlocks.turquoise_farmland.get(), (Block)SkiesBlocks.lunar_farmland.get(), SkiesBlocks.lunar_mud, SkiesBlocks.midnight_sand, SkiesBlocks.crystal_sand});
            this.m_206424_(BlockTags.f_144281_).m_255179_((Object[])new Block[]{SkiesBlocks.brumble_block, SkiesBlocks.brumble_slab, SkiesBlocks.brumble_stairs, SkiesBlocks.brumble_wall, SkiesBlocks.brumble_lantern, SkiesBlocks.sea_moss_block, SkiesBlocks.sea_moss, SkiesBlocks.sea_moss_carpet, SkiesBlocks.bag_of_spoils});
            this.m_206424_(BlockTags.f_144281_).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_leaves, SkiesBlocks.starlit_leaves, SkiesBlocks.frostbright_leaves, SkiesBlocks.lunar_leaves, SkiesBlocks.dusk_leaves, SkiesBlocks.maple_leaves, SkiesBlocks.comet_leaves});
            this.m_206424_(BlockTags.f_278398_).m_255179_((Object[])new Block[]{SkiesBlocks.chilled_lily_pad, SkiesBlocks.moonlit_water_lily, SkiesBlocks.brumble, SkiesBlocks.brumble_vine, SkiesBlocks.brumble_vine_top, SkiesBlocks.sea_moss, SkiesBlocks.sea_moss_carpet});
            this.m_206424_(BlockTags.f_144286_).m_255179_((Object[])new Block[]{SkiesBlocks.raw_ventium_block, SkiesBlocks.raw_falsite_block, SkiesBlocks.raw_horizonite_block, SkiesBlocks.raw_aquite_block}).addTags(new TagKey[]{SkiesBlockTags.PYROPE_ORES, SkiesBlockTags.PYROPE_BLOCKS, SkiesBlockTags.AQUITE_ORES, SkiesBlockTags.AQUITE_BLOCKS, SkiesBlockTags.VENTIUM_ORES, SkiesBlockTags.VENTIUM_BLOCKS, SkiesBlockTags.FALSITE_ORES, SkiesBlockTags.FALSITE_BLOCKS, SkiesBlockTags.HORIZONITE_BLOCKS, SkiesBlockTags.HORIZONITE_ORES});
            this.m_206424_(BlockTags.f_144285_).m_255179_((Object[])new Block[]{SkiesBlocks.everbright_emerald_ore, SkiesBlocks.everdawn_emerald_ore, SkiesBlocks.raw_charoite_block}).addTags(new TagKey[]{SkiesBlockTags.DIOPSIDE_BLOCKS, SkiesBlockTags.DIOPSIDE_ORES, SkiesBlockTags.CHAROITE_BLOCKS, SkiesBlockTags.CHAROITE_ORES});
            this.m_206424_(BlockTags.f_144271_).m_255179_((Object[])new Block[]{SkiesBlocks.chilled_lily_pad, SkiesBlocks.moonlit_water_lily, SkiesBlocks.sea_moss_carpet});
            this.m_206424_(BlockTags.f_276549_).m_255245_((Object)SkiesBlocks.sea_moss_carpet);
            this.m_206424_(BlockTags.f_276630_).m_255245_((Object)SkiesBlocks.sea_moss_block);
            this.m_206424_(BlockTags.f_271391_).m_255179_((Object[])new Block[]{SkiesBlocks.turquoise_dirt, SkiesBlocks.lunar_dirt, SkiesBlocks.turquoise_grass_block, SkiesBlocks.lunar_grass_block, SkiesBlocks.turquoise_comet_grass_block, SkiesBlocks.lunar_comet_grass_block, SkiesBlocks.coarse_turquoise_dirt, SkiesBlocks.coarse_lunar_dirt, SkiesBlocks.lunar_mud, SkiesBlocks.sea_moss_block});
            this.m_206424_(BlockTags.f_201924_).m_255179_((Object[])new Block[]{SkiesBlocks.brewberry_bush, SkiesBlocks.spider_webbing});
            this.m_206424_(BlockTags.f_278411_).m_255179_((Object[])new Block[]{SkiesBlocks.lunar_grass, SkiesBlocks.tall_lunar_grass, SkiesBlocks.turquoise_grass, SkiesBlocks.tall_turquoise_grass, SkiesBlocks.comet_grass, SkiesBlocks.chillweed, SkiesBlocks.brittlebush, SkiesBlocks.muckweed, SkiesBlocks.snowcap_pinhead, SkiesBlocks.snowcap_mushroom, SkiesBlocks.baneful_mushroom});
            IntrinsicHolderTagsProvider.IntrinsicTagAppender appender = this.m_206424_(BlockTags.f_278394_);
            prov.m_255025_(Registries.f_256747_).m_255348_(b -> b.m_49966_().m_247087_()).m_255209_().filter(r -> r.m_135782_().m_135827_().equals("blue_skies")).forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)appender).m_255204_(arg_0));
            this.m_206424_(BlockTags.f_278384_).m_206428_(SkiesBlockTags.BOOKSHELVES);
            this.m_206424_(BlockTags.f_279534_).m_255179_((Object[])new Block[]{SkiesBlocks.winter_leaves, SkiesBlocks.pine_fruits, SkiesBlocks.cryo_roots, SkiesBlocks.solnuts, SkiesBlocks.scalefruits, SkiesBlocks.fiery_beans});
        }

        private void forge(HolderLookup.Provider prov) {
            this.m_206424_(Tags.Blocks.CHESTS_WOODEN).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_chest, SkiesBlocks.starlit_chest, SkiesBlocks.frostbright_chest, SkiesBlocks.lunar_chest, SkiesBlocks.dusk_chest, SkiesBlocks.maple_chest, SkiesBlocks.comet_chest});
            this.m_206424_(Tags.Blocks.FENCE_GATES_WOODEN).m_255179_((Object[])new Block[]{SkiesBlocks.bluebright_fence_gate, SkiesBlocks.starlit_fence_gate, SkiesBlocks.frostbright_fence_gate, SkiesBlocks.lunar_fence_gate, SkiesBlocks.dusk_fence_gate, SkiesBlocks.maple_fence_gate, SkiesBlocks.comet_fence_gate});
            this.m_206424_(Tags.Blocks.COBBLESTONE).addTags(new TagKey[]{SkiesBlockTags.COBBLESTONES});
            this.m_206424_(Tags.Blocks.STONE).addTags(new TagKey[]{SkiesBlockTags.STONES});
            this.m_206424_(Tags.Blocks.STAINED_GLASS).m_255179_((Object[])new Block[]{SkiesBlocks.crystal_glass, SkiesBlocks.midnight_glass});
            this.m_206424_(Tags.Blocks.GLASS_SILICA).m_255179_((Object[])new Block[]{SkiesBlocks.crystal_glass, SkiesBlocks.midnight_glass});
            this.m_206424_(Tags.Blocks.STAINED_GLASS_PANES).m_255179_((Object[])new Block[]{SkiesBlocks.crystal_glass_pane, SkiesBlocks.midnight_glass_pane});
            this.m_206424_(Tags.Blocks.ORE_RATES_SPARSE).m_255179_((Object[])new Block[]{SkiesBlocks.everdawn_moonstone_ore, SkiesBlocks.everbright_moonstone_ore});
            this.m_206424_(Tags.Blocks.ORE_RATES_SINGULAR).m_255179_((Object[])new Block[]{SkiesBlocks.everdawn_emerald_ore, SkiesBlocks.everbright_emerald_ore, SkiesBlocks.everdawn_pyrope_ore, SkiesBlocks.everbright_pyrope_ore, SkiesBlocks.everdawn_diopside_ore, SkiesBlocks.everbright_diopside_ore, SkiesBlocks.everdawn_aquite_ore, SkiesBlocks.everbright_aquite_ore, SkiesBlocks.everdawn_charoite_ore, SkiesBlocks.everbright_charoite_ore, SkiesBlocks.horizonite_ore, SkiesBlocks.falsite_ore, SkiesBlocks.ventium_ore});
            this.m_206424_(Tags.Blocks.ORES).addTags(new TagKey[]{SkiesBlockTags.MOONSTONE_ORES, SkiesBlockTags.PYROPE_ORES, SkiesBlockTags.DIOPSIDE_ORES, SkiesBlockTags.AQUITE_ORES, SkiesBlockTags.CHAROITE_ORES, SkiesBlockTags.HORIZONITE_ORES, SkiesBlockTags.FALSITE_ORES, SkiesBlockTags.VENTIUM_ORES});
            this.m_206424_(Tags.Blocks.ORES_EMERALD).m_255179_((Object[])new Block[]{SkiesBlocks.everbright_emerald_ore, SkiesBlocks.everdawn_emerald_ore});
            this.m_206424_(Tags.Blocks.SANDSTONE).m_255179_((Object[])new Block[]{SkiesBlocks.crystal_sandstone, SkiesBlocks.chiseled_crystal_sandstone, SkiesBlocks.cut_crystal_sandstone, SkiesBlocks.smooth_crystal_sandstone, SkiesBlocks.midnight_sandstone, SkiesBlocks.chiseled_midnight_sandstone, SkiesBlocks.cut_midnight_sandstone});
            this.m_206424_(Tags.Blocks.STORAGE_BLOCKS).addTags(new TagKey[]{SkiesBlockTags.MOONSTONE_BLOCKS, SkiesBlockTags.PYROPE_BLOCKS, SkiesBlockTags.DIOPSIDE_BLOCKS, SkiesBlockTags.AQUITE_BLOCKS, SkiesBlockTags.RAW_AQUITE_BLOCKS, SkiesBlockTags.CHAROITE_BLOCKS, SkiesBlockTags.RAW_CHAROITE_BLOCKS, SkiesBlockTags.HORIZONITE_BLOCKS, SkiesBlockTags.RAW_HORIZONITE_BLOCKS, SkiesBlockTags.FALSITE_BLOCKS, SkiesBlockTags.RAW_FALSITE_BLOCKS, SkiesBlockTags.VENTIUM_BLOCKS, SkiesBlockTags.RAW_VENTIUM_BLOCKS});
            this.m_206424_(Tags.Blocks.SAND).m_255179_((Object[])new Block[]{SkiesBlocks.crystal_sand, SkiesBlocks.midnight_sand});
            this.m_206424_(Tags.Blocks.BOOKSHELVES).m_206428_(SkiesBlockTags.BOOKSHELVES);
        }

        public String m_6055_() {
            return "Blue Skies Block Tags";
        }

        private Stream<Block> getMatching(Function<Block, Boolean> condition) {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("blue_skies") && (Boolean)condition.apply((Block)block) != false);
        }

        private void addMatching(TagKey<Block> blockTag, Function<Block, Boolean> condition) {
            this.getMatching(condition).forEach(arg_0 -> ((IntrinsicHolderTagsProvider.IntrinsicTagAppender)this.m_206424_(blockTag)).m_255245_(arg_0));
        }
    }
}

