/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.gui.screen.journal;

import com.google.gson.JsonObject;
import com.legacy.blue_skies.data.objects.IToJson;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class JournalEntryRenderers {

    public static class EntityDisplay
    implements IRenderable {
        private static float rotation = 0.0f;
        private static LivingEntity entity;
        private final EntityType<?> entityType;
        private final int scale;
        private final int yOffset;

        public EntityDisplay(EntityType<?> entityType, int scale, int yOffset) {
            this.entityType = entityType;
            this.scale = scale;
            this.yOffset = yOffset;
        }

        public EntityType<?> getEntity() {
            return this.entityType;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void init(Minecraft mc) {
            ClientLevel world;
            Entity newEntity;
            if (entity != null) {
                entity.m_146870_();
            }
            entity = (newEntity = this.entityType.m_20615_((Level)(world = mc.f_91073_))) instanceof LivingEntity ? (LivingEntity)newEntity : (LivingEntity)EntityType.f_20510_.m_20615_((Level)world);
            entity.m_146926_(0.0f);
            entity.m_146922_(0.0f);
            EntityDisplay.entity.f_20885_ = 0.0f;
            EntityDisplay.entity.f_20883_ = 0.0f;
            rotation = (float)(-Util.m_137550_()) * 0.03f - 45.0f;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(GuiGraphics graphics, Minecraft mc, int width, int height, float partialTicks) {
            PoseStack poseStack = graphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)(width / 2 + 70), (float)(height / 2 + this.yOffset), 200.0f);
            float rotationTick = rotation + (float)Util.m_137550_() * 0.03f;
            poseStack.m_252781_(Axis.f_252436_.m_252977_(rotationTick));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)Math.sin(rotationTick / 20.0f) * 2.0f));
            poseStack.m_252880_(0.0f, 0.0f, -50.0f);
            InventoryScreen.renderEntityInInventoryFollowsAngle((GuiGraphics)graphics, (int)0, (int)0, (int)this.scale, (float)0.0f, (float)0.0f, (LivingEntity)entity);
            poseStack.m_85849_();
            RenderSystem.applyModelViewMatrix();
        }

        @Override
        public String getType() {
            return "entity";
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("entity", ForgeRegistries.ENTITY_TYPES.getKey(this.entityType).toString());
            json.addProperty("scale", (Number)this.scale);
            json.addProperty("y_offset", (Number)this.yOffset);
            return json;
        }
    }

    public static class ImageDisplay
    implements IRenderable {
        private final ResourceLocation image;

        public ImageDisplay(ResourceLocation image) {
            this.image = image;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(GuiGraphics graphics, Minecraft mc, int width, int height, float partialTicks) {
            int bookHeight = 220;
            graphics.m_280163_(this.image, width / 2, (height - bookHeight) / 2, 0.0f, 0.0f, 153, bookHeight, 256, 256);
        }

        @Override
        public String getType() {
            return "image";
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("image", this.image.toString());
            return json;
        }
    }

    public static class TextureIcon
    implements IRenderable {
        private final ResourceLocation texture;

        public TextureIcon(ResourceLocation texture) {
            this.texture = texture;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(GuiGraphics graphics, Minecraft mc, int x, int y, float partialTicks) {
            graphics.m_280163_(this.texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }

        @Override
        public String getType() {
            return "texture";
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("texture", this.texture.toString());
            return json;
        }
    }

    public static class ItemIcon
    implements IRenderable {
        private final ItemStack item;

        public ItemIcon(ItemLike item) {
            this.item = new ItemStack(item);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void render(GuiGraphics graphics, Minecraft mc, int x, int y, float partialTicks) {
            graphics.m_280480_(this.item, x, y);
        }

        @Override
        public String getType() {
            return "item";
        }

        @Override
        public JsonObject toJson() {
            JsonObject json = new JsonObject();
            json.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.item.m_41720_()).toString());
            return json;
        }
    }

    public static interface IRenderable
    extends IToJson<IRenderable> {
        @OnlyIn(value=Dist.CLIENT)
        public void render(GuiGraphics var1, Minecraft var2, int var3, int var4, float var5);

        public String getType();

        @OnlyIn(value=Dist.CLIENT)
        default public void init(Minecraft mc) {
        }
    }
}

