/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks.client;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.client.screen.ContainerScreenDrawEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenInitEvent;
import net.blay09.mods.balm.api.event.client.screen.ScreenMouseEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.craftingtweaks.CraftingTweaks;
import net.blay09.mods.craftingtweaks.registry.CraftingTweaksRegistrationData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CraftingTweaksDebugger {
    private static final Logger logger = LoggerFactory.getLogger(CraftingTweaksDebugger.class);
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private static final Rect2i currentMenuLabelRect = new Rect2i(0, 0, 0, 0);
    private static Component currentMenuLabel;
    private static Slot startDragSlot;
    private static Slot endDragSlot;

    public static void initialize() {
        Balm.getEvents().onEvent(ScreenInitEvent.Post.class, event -> {
            if (!CraftingTweaks.debugMode) {
                return;
            }
            Screen screen = event.getScreen();
            if (CraftingTweaks.debugMode && screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                AbstractContainerMenu menu = containerScreen.m_6262_();
                String modId = CraftingTweaksDebugger.getModId(menu);
                CraftingTweaksDebugger.printJson(modId, menu.getClass().getName(), 1, 9);
                currentMenuLabel = Component.m_237113_((String)menu.getClass().getName());
                int labelWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)currentMenuLabel);
                currentMenuLabelRect.m_173047_(((AbstractContainerScreenAccessor)screen).getLeftPos() + ((AbstractContainerScreenAccessor)screen).getImageWidth() / 2 - labelWidth / 2);
                currentMenuLabelRect.m_173054_(((AbstractContainerScreenAccessor)screen).getTopPos() - 20);
                currentMenuLabelRect.m_173056_(labelWidth);
                currentMenuLabelRect.m_173058_(16);
            }
        });
        Balm.getEvents().onEvent(ScreenMouseEvent.Release.Pre.class, CraftingTweaksDebugger::onMouseRelease);
        Balm.getEvents().onEvent(ScreenMouseEvent.Click.Pre.class, CraftingTweaksDebugger::onMouseClick);
        Balm.getEvents().onEvent(ContainerScreenDrawEvent.Background.class, CraftingTweaksDebugger::onScreenDrawn);
    }

    public static void onScreenDrawn(ContainerScreenDrawEvent.Background event) {
        AbstractContainerScreenAccessor accessor;
        if (!CraftingTweaks.debugMode) {
            return;
        }
        Screen screen = event.getScreen();
        GuiGraphics graphics = event.getGuiGraphics();
        if (startDragSlot != null && screen instanceof AbstractContainerScreenAccessor && (endDragSlot = (accessor = (AbstractContainerScreenAccessor)screen).getHoveredSlot()) != null) {
            int tmp;
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_((float)accessor.getLeftPos(), (float)accessor.getTopPos(), 0.0f);
            int startX = CraftingTweaksDebugger.startDragSlot.f_40220_;
            int startY = CraftingTweaksDebugger.startDragSlot.f_40221_;
            int endX = CraftingTweaksDebugger.endDragSlot.f_40220_;
            int endY = CraftingTweaksDebugger.endDragSlot.f_40221_;
            if (startX > endX) {
                tmp = startX;
                startX = endX;
                endX = tmp;
            }
            if (startY > endY) {
                tmp = startY;
                startY = endY;
                endY = tmp;
            }
            for (int x = startX; x <= endX; ++x) {
                for (int y = startY; y <= endY; ++y) {
                    graphics.m_280246_(1.0f, 1.0f, 1.0f, 0.1f);
                    graphics.m_280024_(x, y, x + 16, y + 16, 0x1000FF00, 0x1000FF00);
                    graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            graphics.m_280168_().m_85849_();
        }
        if (currentMenuLabel != null) {
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, (List)Lists.newArrayList((Object[])new Component[]{currentMenuLabel}), Optional.empty(), currentMenuLabelRect.m_110085_() - 12, currentMenuLabelRect.m_110086_() + 12);
        }
    }

    private static void onMouseRelease(ScreenMouseEvent.Release.Pre event) {
        if (!CraftingTweaks.debugMode) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (event.getButton() == 0 && startDragSlot != null) {
                AbstractContainerMenu menu = screen2.m_6262_();
                String modId = CraftingTweaksDebugger.getModId(menu);
                endDragSlot = ((AbstractContainerScreenAccessor)screen2).getHoveredSlot();
                if (endDragSlot != null) {
                    int gridSize = CraftingTweaksDebugger.endDragSlot.f_40219_ - CraftingTweaksDebugger.startDragSlot.f_40219_ + 1;
                    CraftingTweaksDebugger.printJson(modId, menu.getClass().getName(), CraftingTweaksDebugger.startDragSlot.f_40219_, gridSize);
                }
                startDragSlot = null;
                event.setCanceled(true);
            }
        }
    }

    private static void onMouseClick(ScreenMouseEvent.Click.Pre event) {
        if (!CraftingTweaks.debugMode) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen screen2 = (AbstractContainerScreen)screen;
            if (event.getButton() == 0 && (startDragSlot = ((AbstractContainerScreenAccessor)screen2).getHoveredSlot()) != null) {
                event.setCanceled(true);
            }
        }
    }

    private static String getModId(AbstractContainerMenu menu) {
        try {
            ResourceLocation key = BuiltInRegistries.f_256818_.m_7981_((Object)menu.m_6772_());
            return key != null ? key.m_135827_() : "minecraft";
        }
        catch (UnsupportedOperationException e) {
            return "minecraft";
        }
    }

    private static void printJson(String modId, String containerClass, int gridSlotNumber, int gridSize) {
        CraftingTweaksRegistrationData data = new CraftingTweaksRegistrationData();
        data.setModId(modId);
        data.setContainerClass(containerClass);
        data.setGridSlotNumber(gridSlotNumber);
        data.setGridSize(gridSize);
        logger.info("\n\nExample for Crafting Tweaks datapack: datapacks/mypack/data/mypack/craftingtweaks_compat/{}.json\n\n{}\n\n", (Object)modId, (Object)gson.toJson((Object)data));
    }
}

