/*
 * Decompiled with CFR 0.152.
 */
package imgui.glfw;

import imgui.ImGui;
import imgui.ImGuiIO;
import imgui.ImGuiPlatformIO;
import imgui.ImGuiViewport;
import imgui.ImVec2;
import imgui.callback.ImPlatformFuncViewport;
import imgui.callback.ImPlatformFuncViewportFloat;
import imgui.callback.ImPlatformFuncViewportImVec2;
import imgui.callback.ImPlatformFuncViewportString;
import imgui.callback.ImPlatformFuncViewportSuppBoolean;
import imgui.callback.ImPlatformFuncViewportSuppImVec2;
import imgui.callback.ImStrConsumer;
import imgui.callback.ImStrSupplier;
import imgui.lwjgl3.glfw.ImGuiImplGlfwNative;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWCursorEnterCallback;
import org.lwjgl.glfw.GLFWCursorEnterCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWMonitorCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl.glfw.GLFWNativeWin32;
import org.lwjgl.glfw.GLFWScrollCallback;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.glfw.GLFWWindowFocusCallback;
import org.lwjgl.glfw.GLFWWindowFocusCallbackI;

public class ImGuiImplGlfw {
    private static final String OS = System.getProperty("os.name", "generic").toLowerCase();
    protected static final boolean IS_WINDOWS = OS.contains("win");
    protected static final boolean IS_APPLE = OS.contains("mac") || OS.contains("darwin");
    private long windowPtr;
    private boolean glfwHawWindowTopmost;
    private boolean glfwHasWindowAlpha;
    private boolean glfwHasPerMonitorDpi;
    private boolean glfwHasFocusWindow;
    private boolean glfwHasFocusOnShow;
    private boolean glfwHasMonitorWorkArea;
    private boolean glfwHasOsxWindowPosFix;
    private final int[] winWidth = new int[1];
    private final int[] winHeight = new int[1];
    private final int[] fbWidth = new int[1];
    private final int[] fbHeight = new int[1];
    private final long[] mouseCursors = new long[9];
    private final long[] keyOwnerWindows = new long[512];
    private final float[] emptyNavInputs = new float[21];
    private final boolean[] mouseJustPressed = new boolean[5];
    private final ImVec2 mousePosBackup = new ImVec2();
    private final double[] mouseX = new double[1];
    private final double[] mouseY = new double[1];
    private final int[] windowX = new int[1];
    private final int[] windowY = new int[1];
    private final int[] monitorX = new int[1];
    private final int[] monitorY = new int[1];
    private final int[] monitorWorkAreaX = new int[1];
    private final int[] monitorWorkAreaY = new int[1];
    private final int[] monitorWorkAreaWidth = new int[1];
    private final int[] monitorWorkAreaHeight = new int[1];
    private final float[] monitorContentScaleX = new float[1];
    private final float[] monitorContentScaleY = new float[1];
    private GLFWWindowFocusCallback prevUserCallbackWindowFocus = null;
    private GLFWMouseButtonCallback prevUserCallbackMouseButton = null;
    private GLFWScrollCallback prevUserCallbackScroll = null;
    private GLFWKeyCallback prevUserCallbackKey = null;
    private GLFWCharCallback prevUserCallbackChar = null;
    private GLFWMonitorCallback prevUserCallbackMonitor = null;
    private GLFWCursorEnterCallback prevUserCallbackCursorEnter = null;
    private boolean callbacksInstalled = false;
    private boolean wantUpdateMonitors = true;
    private double time = 0.0;
    private long mouseWindowPtr;

    public void mouseButtonCallback(long windowId, int button, int action, int mods) {
        if (this.prevUserCallbackMouseButton != null && windowId == this.windowPtr) {
            this.prevUserCallbackMouseButton.invoke(windowId, button, action, mods);
        }
        if (action == 1 && button >= 0 && button < this.mouseJustPressed.length) {
            this.mouseJustPressed[button] = true;
        }
    }

    public void scrollCallback(long windowId, double xOffset, double yOffset) {
        if (this.prevUserCallbackScroll != null && windowId == this.windowPtr) {
            this.prevUserCallbackScroll.invoke(windowId, xOffset, yOffset);
        }
        ImGuiIO io = ImGui.getIO();
        io.setMouseWheelH(io.getMouseWheelH() + (float)xOffset);
        io.setMouseWheel(io.getMouseWheel() + (float)yOffset);
    }

    public void keyCallback(long windowId, int key, int scancode, int action, int mods) {
        if (this.prevUserCallbackKey != null && windowId == this.windowPtr) {
            this.prevUserCallbackKey.invoke(windowId, key, scancode, action, mods);
        }
        ImGuiIO io = ImGui.getIO();
        if (key >= 0 && key < this.keyOwnerWindows.length) {
            if (action == 1) {
                io.setKeysDown(key, true);
                this.keyOwnerWindows[key] = windowId;
            } else if (action == 0) {
                io.setKeysDown(key, false);
                this.keyOwnerWindows[key] = 0L;
            }
        }
        io.setKeyCtrl(io.getKeysDown(341) || io.getKeysDown(345));
        io.setKeyShift(io.getKeysDown(340) || io.getKeysDown(344));
        io.setKeyAlt(io.getKeysDown(342) || io.getKeysDown(346));
        io.setKeySuper(io.getKeysDown(343) || io.getKeysDown(347));
    }

    public void windowFocusCallback(long windowId, boolean focused) {
        if (this.prevUserCallbackWindowFocus != null && windowId == this.windowPtr) {
            this.prevUserCallbackWindowFocus.invoke(windowId, focused);
        }
        ImGui.getIO().addFocusEvent(focused);
    }

    public void cursorEnterCallback(long windowId, boolean entered) {
        if (this.prevUserCallbackCursorEnter != null && windowId == this.windowPtr) {
            this.prevUserCallbackCursorEnter.invoke(windowId, entered);
        }
        if (entered) {
            this.mouseWindowPtr = windowId;
        }
        if (!entered && this.mouseWindowPtr == windowId) {
            this.mouseWindowPtr = 0L;
        }
    }

    public void charCallback(long windowId, int c) {
        if (this.prevUserCallbackChar != null && windowId == this.windowPtr) {
            this.prevUserCallbackChar.invoke(windowId, c);
        }
        ImGuiIO io = ImGui.getIO();
        io.addInputCharacter(c);
    }

    public void monitorCallback(long windowId, int event) {
        this.wantUpdateMonitors = true;
    }

    public boolean init(final long windowId, boolean installCallbacks) {
        this.windowPtr = windowId;
        this.detectGlfwVersionAndEnabledFeatures();
        ImGuiIO io = ImGui.getIO();
        io.addBackendFlags(1030);
        io.setBackendPlatformName("imgui_java_impl_glfw");
        int[] keyMap = new int[]{258, 263, 262, 265, 264, 266, 267, 268, 269, 260, 261, 259, 32, 257, 256, 335, 65, 67, 86, 88, 89, 90};
        io.setKeyMap(keyMap);
        io.setGetClipboardTextFn(new ImStrSupplier(){

            @Override
            public String get() {
                String clipboardString = GLFW.glfwGetClipboardString((long)windowId);
                return clipboardString != null ? clipboardString : "";
            }
        });
        io.setSetClipboardTextFn(new ImStrConsumer(){

            @Override
            public void accept(String str) {
                GLFW.glfwSetClipboardString((long)windowId, (CharSequence)str);
            }
        });
        GLFWErrorCallback prevErrorCallback = GLFW.glfwSetErrorCallback(null);
        this.mouseCursors[0] = GLFW.glfwCreateStandardCursor((int)221185);
        this.mouseCursors[1] = GLFW.glfwCreateStandardCursor((int)221186);
        this.mouseCursors[2] = GLFW.glfwCreateStandardCursor((int)221185);
        this.mouseCursors[3] = GLFW.glfwCreateStandardCursor((int)221190);
        this.mouseCursors[4] = GLFW.glfwCreateStandardCursor((int)221189);
        this.mouseCursors[5] = GLFW.glfwCreateStandardCursor((int)221185);
        this.mouseCursors[6] = GLFW.glfwCreateStandardCursor((int)221185);
        this.mouseCursors[7] = GLFW.glfwCreateStandardCursor((int)221188);
        this.mouseCursors[8] = GLFW.glfwCreateStandardCursor((int)221185);
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)prevErrorCallback);
        if (installCallbacks) {
            this.callbacksInstalled = true;
            this.prevUserCallbackWindowFocus = GLFW.glfwSetWindowFocusCallback((long)windowId, this::windowFocusCallback);
            this.prevUserCallbackCursorEnter = GLFW.glfwSetCursorEnterCallback((long)windowId, this::cursorEnterCallback);
            this.prevUserCallbackMouseButton = GLFW.glfwSetMouseButtonCallback((long)windowId, this::mouseButtonCallback);
            this.prevUserCallbackScroll = GLFW.glfwSetScrollCallback((long)windowId, this::scrollCallback);
            this.prevUserCallbackKey = GLFW.glfwSetKeyCallback((long)windowId, this::keyCallback);
            this.prevUserCallbackChar = GLFW.glfwSetCharCallback((long)windowId, this::charCallback);
            this.prevUserCallbackMonitor = GLFW.glfwSetMonitorCallback(this::monitorCallback);
        }
        this.updateMonitors();
        GLFW.glfwSetMonitorCallback(this::monitorCallback);
        ImGuiViewport mainViewport = ImGui.getMainViewport();
        mainViewport.setPlatformHandle(this.windowPtr);
        if (IS_WINDOWS) {
            mainViewport.setPlatformHandleRaw(GLFWNativeWin32.glfwGetWin32Window((long)windowId));
        }
        if (io.hasConfigFlags(1024)) {
            this.initPlatformInterface();
        }
        return true;
    }

    public void newFrame() {
        ImGuiIO io = ImGui.getIO();
        GLFW.glfwGetWindowSize((long)this.windowPtr, (int[])this.winWidth, (int[])this.winHeight);
        GLFW.glfwGetFramebufferSize((long)this.windowPtr, (int[])this.fbWidth, (int[])this.fbHeight);
        io.setDisplaySize(this.winWidth[0], this.winHeight[0]);
        if (this.winWidth[0] > 0 && this.winHeight[0] > 0) {
            float scaleX = (float)this.fbWidth[0] / (float)this.winWidth[0];
            float scaleY = (float)this.fbHeight[0] / (float)this.winHeight[0];
            io.setDisplayFramebufferScale(scaleX, scaleY);
        }
        if (this.wantUpdateMonitors) {
            this.updateMonitors();
        }
        double currentTime = GLFW.glfwGetTime();
        io.setDeltaTime(this.time > 0.0 ? (float)(currentTime - this.time) : 0.016666668f);
        this.time = currentTime;
        this.updateMousePosAndButtons();
        this.updateMouseCursor();
        this.updateGamepads();
    }

    public void dispose() {
        this.shutdownPlatformInterface();
        if (this.callbacksInstalled) {
            GLFW.glfwSetWindowFocusCallback((long)this.windowPtr, (GLFWWindowFocusCallbackI)this.prevUserCallbackWindowFocus);
            GLFW.glfwSetCursorEnterCallback((long)this.windowPtr, (GLFWCursorEnterCallbackI)this.prevUserCallbackCursorEnter);
            GLFW.glfwSetMouseButtonCallback((long)this.windowPtr, (GLFWMouseButtonCallbackI)this.prevUserCallbackMouseButton);
            GLFW.glfwSetScrollCallback((long)this.windowPtr, (GLFWScrollCallbackI)this.prevUserCallbackScroll);
            GLFW.glfwSetKeyCallback((long)this.windowPtr, (GLFWKeyCallbackI)this.prevUserCallbackKey);
            GLFW.glfwSetCharCallback((long)this.windowPtr, (GLFWCharCallbackI)this.prevUserCallbackChar);
            this.callbacksInstalled = false;
        }
        for (int i = 0; i < 9; ++i) {
            GLFW.glfwDestroyCursor((long)this.mouseCursors[i]);
        }
    }

    private void detectGlfwVersionAndEnabledFeatures() {
        int[] major = new int[1];
        int[] minor = new int[1];
        int[] rev = new int[1];
        GLFW.glfwGetVersion((int[])major, (int[])minor, (int[])rev);
        int version = major[0] * 1000 + minor[0] * 100 + rev[0] * 10;
        this.glfwHawWindowTopmost = version >= 3200;
        this.glfwHasWindowAlpha = version >= 3300;
        this.glfwHasPerMonitorDpi = version >= 3300;
        this.glfwHasFocusWindow = version >= 3200;
        this.glfwHasFocusOnShow = version >= 3300;
        this.glfwHasMonitorWorkArea = version >= 3300;
    }

    private void updateMousePosAndButtons() {
        ImGuiIO io = ImGui.getIO();
        for (int i = 0; i < 5; ++i) {
            io.setMouseDown(i, this.mouseJustPressed[i] || GLFW.glfwGetMouseButton((long)this.windowPtr, (int)i) != 0);
            this.mouseJustPressed[i] = false;
        }
        io.getMousePos(this.mousePosBackup);
        io.setMousePos(-3.4028235E38f, -3.4028235E38f);
        io.setMouseHoveredViewport(0);
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        for (int n = 0; n < platformIO.getViewportsSize(); ++n) {
            long mouseWindowPtr;
            ImGuiViewport viewport = platformIO.getViewports(n);
            long windowPtr = viewport.getPlatformHandle();
            boolean focused = GLFW.glfwGetWindowAttrib((long)windowPtr, (int)131073) != 0;
            long l = mouseWindowPtr = this.mouseWindowPtr == windowPtr || focused ? windowPtr : 0L;
            if (focused) {
                for (int i = 0; i < 5; ++i) {
                    io.setMouseDown(i, GLFW.glfwGetMouseButton((long)windowPtr, (int)i) != 0);
                }
            }
            if (io.getWantSetMousePos() && focused) {
                GLFW.glfwSetCursorPos((long)windowPtr, (double)(this.mousePosBackup.x - viewport.getPosX()), (double)(this.mousePosBackup.y - viewport.getPosY()));
            }
            if (mouseWindowPtr == 0L) continue;
            GLFW.glfwGetCursorPos((long)mouseWindowPtr, (double[])this.mouseX, (double[])this.mouseY);
            if (io.hasConfigFlags(1024)) {
                GLFW.glfwGetWindowPos((long)windowPtr, (int[])this.windowX, (int[])this.windowY);
                io.setMousePos((float)this.mouseX[0] + (float)this.windowX[0], (float)this.mouseY[0] + (float)this.windowY[0]);
                continue;
            }
            io.setMousePos((float)this.mouseX[0], (float)this.mouseY[0]);
        }
    }

    private void updateMouseCursor() {
        boolean cursorDisabled;
        ImGuiIO io = ImGui.getIO();
        boolean noCursorChange = io.hasConfigFlags(32);
        boolean bl = cursorDisabled = GLFW.glfwGetInputMode((long)this.windowPtr, (int)208897) == 212995;
        if (noCursorChange || cursorDisabled) {
            return;
        }
        int imguiCursor = ImGui.getMouseCursor();
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        for (int n = 0; n < platformIO.getViewportsSize(); ++n) {
            long windowPtr = platformIO.getViewports(n).getPlatformHandle();
            if (imguiCursor == -1 || io.getMouseDrawCursor()) {
                GLFW.glfwSetInputMode((long)windowPtr, (int)208897, (int)212994);
                continue;
            }
            GLFW.glfwSetCursor((long)windowPtr, (long)(this.mouseCursors[imguiCursor] != 0L ? this.mouseCursors[imguiCursor] : this.mouseCursors[0]));
            GLFW.glfwSetInputMode((long)windowPtr, (int)208897, (int)212993);
        }
    }

    private void updateGamepads() {
        ImGuiIO io = ImGui.getIO();
        if (!io.hasConfigFlags(2)) {
            return;
        }
        io.setNavInputs(this.emptyNavInputs);
        ByteBuffer buttons = GLFW.glfwGetJoystickButtons((int)0);
        int buttonsCount = buttons.limit();
        FloatBuffer axis = GLFW.glfwGetJoystickAxes((int)0);
        int axisCount = axis.limit();
        this.mapButton(0, 0, buttons, buttonsCount, io);
        this.mapButton(1, 1, buttons, buttonsCount, io);
        this.mapButton(3, 2, buttons, buttonsCount, io);
        this.mapButton(2, 3, buttons, buttonsCount, io);
        this.mapButton(4, 13, buttons, buttonsCount, io);
        this.mapButton(5, 11, buttons, buttonsCount, io);
        this.mapButton(6, 10, buttons, buttonsCount, io);
        this.mapButton(7, 12, buttons, buttonsCount, io);
        this.mapButton(12, 4, buttons, buttonsCount, io);
        this.mapButton(13, 5, buttons, buttonsCount, io);
        this.mapButton(14, 4, buttons, buttonsCount, io);
        this.mapButton(15, 5, buttons, buttonsCount, io);
        this.mapAnalog(8, 0, -0.3f, -0.9f, axis, axisCount, io);
        this.mapAnalog(9, 0, 0.3f, 0.9f, axis, axisCount, io);
        this.mapAnalog(10, 1, 0.3f, 0.9f, axis, axisCount, io);
        this.mapAnalog(11, 1, -0.3f, -0.9f, axis, axisCount, io);
        if (axisCount > 0 && buttonsCount > 0) {
            io.addBackendFlags(1);
        } else {
            io.removeBackendFlags(1);
        }
    }

    private void mapButton(int navNo, int buttonNo, ByteBuffer buttons, int buttonsCount, ImGuiIO io) {
        if (buttonsCount > buttonNo && buttons.get(buttonNo) == 1) {
            io.setNavInputs(navNo, 1.0f);
        }
    }

    private void mapAnalog(int navNo, int axisNo, float v0, float v1, FloatBuffer axis, int axisCount, ImGuiIO io) {
        float v = axisCount > axisNo ? axis.get(axisNo) : v0;
        if ((v = (v - v0) / (v1 - v0)) > 1.0f) {
            v = 1.0f;
        }
        if (io.getNavInputs(navNo) < v) {
            io.setNavInputs(navNo, v);
        }
    }

    private void updateMonitors() {
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        PointerBuffer monitors = GLFW.glfwGetMonitors();
        platformIO.resizeMonitors(0);
        for (int n = 0; n < monitors.limit(); ++n) {
            long monitor = monitors.get(n);
            GLFW.glfwGetMonitorPos((long)monitor, (int[])this.monitorX, (int[])this.monitorY);
            GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)monitor);
            float mainPosX = this.monitorX[0];
            float mainPosY = this.monitorY[0];
            float mainSizeX = vidMode.width();
            float mainSizeY = vidMode.height();
            if (this.glfwHasMonitorWorkArea) {
                GLFW.glfwGetMonitorWorkarea((long)monitor, (int[])this.monitorWorkAreaX, (int[])this.monitorWorkAreaY, (int[])this.monitorWorkAreaWidth, (int[])this.monitorWorkAreaHeight);
            }
            float workPosX = 0.0f;
            float workPosY = 0.0f;
            float workSizeX = 0.0f;
            float workSizeY = 0.0f;
            if (this.glfwHasMonitorWorkArea && this.monitorWorkAreaWidth[0] > 0 && this.monitorWorkAreaHeight[0] > 0) {
                workPosX = this.monitorWorkAreaX[0];
                workPosY = this.monitorWorkAreaY[0];
                workSizeX = this.monitorWorkAreaWidth[0];
                workSizeY = this.monitorWorkAreaHeight[0];
            }
            if (this.glfwHasPerMonitorDpi) {
                GLFW.glfwGetMonitorContentScale((long)monitor, (float[])this.monitorContentScaleX, (float[])this.monitorContentScaleY);
            }
            float dpiScale = this.monitorContentScaleX[0];
            platformIO.pushMonitors(mainPosX, mainPosY, mainSizeX, mainSizeY, workPosX, workPosY, workSizeX, workSizeY, dpiScale);
        }
        this.wantUpdateMonitors = false;
    }

    private void windowCloseCallback(long windowId) {
        ImGuiViewport vp = ImGui.findViewportByPlatformHandle(windowId);
        vp.setPlatformRequestClose(true);
    }

    private void windowPosCallback(long windowId, int xPos, int yPos) {
        boolean ignoreEvent;
        ImGuiViewport vp = ImGui.findViewportByPlatformHandle(windowId);
        ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
        boolean bl = ignoreEvent = ImGui.getFrameCount() <= data.ignoreWindowPosEventFrame + 1;
        if (ignoreEvent) {
            return;
        }
        vp.setPlatformRequestMove(true);
    }

    private void windowSizeCallback(long windowId, int width, int height) {
        boolean ignoreEvent;
        ImGuiViewport vp = ImGui.findViewportByPlatformHandle(windowId);
        ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
        boolean bl = ignoreEvent = ImGui.getFrameCount() <= data.ignoreWindowSizeEventFrame + 1;
        if (ignoreEvent) {
            return;
        }
        vp.setPlatformRequestResize(true);
    }

    private void initPlatformInterface() {
        ImGuiPlatformIO platformIO = ImGui.getPlatformIO();
        platformIO.setPlatformCreateWindow(new CreateWindowFunction());
        platformIO.setPlatformDestroyWindow(new DestroyWindowFunction());
        platformIO.setPlatformShowWindow(new ShowWindowFunction());
        platformIO.setPlatformGetWindowPos(new GetWindowPosFunction());
        platformIO.setPlatformSetWindowPos(new SetWindowPosFunction());
        platformIO.setPlatformGetWindowSize(new GetWindowSizeFunction());
        platformIO.setPlatformSetWindowSize(new SetWindowSizeFunction());
        platformIO.setPlatformSetWindowTitle(new SetWindowTitleFunction());
        platformIO.setPlatformSetWindowFocus(new SetWindowFocusFunction());
        platformIO.setPlatformGetWindowFocus(new GetWindowFocusFunction());
        platformIO.setPlatformGetWindowMinimized(new GetWindowMinimizedFunction());
        platformIO.setPlatformSetWindowAlpha(new SetWindowAlphaFunction());
        platformIO.setPlatformRenderWindow(new RenderWindowFunction());
        platformIO.setPlatformSwapBuffers(new SwapBuffersFunction());
        ImGuiViewport mainViewport = ImGui.getMainViewport();
        ImGuiViewportDataGlfw data = new ImGuiViewportDataGlfw();
        data.window = this.windowPtr;
        data.windowOwned = false;
        mainViewport.setPlatformUserData(data);
    }

    private void shutdownPlatformInterface() {
    }

    private static final class ImGuiViewportDataGlfw {
        long window;
        boolean windowOwned = false;
        int ignoreWindowPosEventFrame = -1;
        int ignoreWindowSizeEventFrame = -1;

        private ImGuiViewportDataGlfw() {
        }
    }

    private static final class SwapBuffersFunction
    extends ImPlatformFuncViewport {
        private SwapBuffersFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            GLFW.glfwMakeContextCurrent((long)data.window);
            GLFW.glfwSwapBuffers((long)data.window);
        }
    }

    private static final class RenderWindowFunction
    extends ImPlatformFuncViewport {
        private RenderWindowFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            GLFW.glfwMakeContextCurrent((long)data.window);
        }
    }

    private final class SetWindowAlphaFunction
    extends ImPlatformFuncViewportFloat {
        private SetWindowAlphaFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp, float f) {
            if (ImGuiImplGlfw.this.glfwHasWindowAlpha) {
                ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
                GLFW.glfwSetWindowOpacity((long)data.window, (float)f);
            }
        }
    }

    private static final class GetWindowMinimizedFunction
    extends ImPlatformFuncViewportSuppBoolean {
        private GetWindowMinimizedFunction() {
        }

        @Override
        public boolean get(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            return GLFW.glfwGetWindowAttrib((long)data.window, (int)131074) != 0;
        }
    }

    private static final class GetWindowFocusFunction
    extends ImPlatformFuncViewportSuppBoolean {
        private GetWindowFocusFunction() {
        }

        @Override
        public boolean get(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            return GLFW.glfwGetWindowAttrib((long)data.window, (int)131073) != 0;
        }
    }

    private final class SetWindowFocusFunction
    extends ImPlatformFuncViewport {
        private SetWindowFocusFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            if (ImGuiImplGlfw.this.glfwHasFocusWindow) {
                ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
                GLFW.glfwFocusWindow((long)data.window);
            }
        }
    }

    private static final class SetWindowTitleFunction
    extends ImPlatformFuncViewportString {
        private SetWindowTitleFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp, String str) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            GLFW.glfwSetWindowTitle((long)data.window, (CharSequence)str);
        }
    }

    private final class SetWindowSizeFunction
    extends ImPlatformFuncViewportImVec2 {
        private final int[] x = new int[1];
        private final int[] y = new int[1];
        private final int[] width = new int[1];
        private final int[] height = new int[1];

        private SetWindowSizeFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp, ImVec2 imVec2) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            if (IS_APPLE && !ImGuiImplGlfw.this.glfwHasOsxWindowPosFix) {
                GLFW.glfwGetWindowPos((long)data.window, (int[])this.x, (int[])this.y);
                GLFW.glfwGetWindowSize((long)data.window, (int[])this.width, (int[])this.height);
                GLFW.glfwSetWindowPos((long)data.window, (int)this.x[0], (int)(this.y[0] - this.height[0] + (int)imVec2.y));
            }
            data.ignoreWindowSizeEventFrame = ImGui.getFrameCount();
            GLFW.glfwSetWindowSize((long)data.window, (int)((int)imVec2.x), (int)((int)imVec2.y));
        }
    }

    private static final class GetWindowSizeFunction
    extends ImPlatformFuncViewportSuppImVec2 {
        private final int[] width = new int[1];
        private final int[] height = new int[1];

        private GetWindowSizeFunction() {
        }

        @Override
        public void get(ImGuiViewport vp, ImVec2 dstImVec2) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            GLFW.glfwGetWindowSize((long)data.window, (int[])this.width, (int[])this.height);
            dstImVec2.x = this.width[0];
            dstImVec2.y = this.height[0];
        }
    }

    private static final class SetWindowPosFunction
    extends ImPlatformFuncViewportImVec2 {
        private SetWindowPosFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp, ImVec2 imVec2) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            data.ignoreWindowPosEventFrame = ImGui.getFrameCount();
            GLFW.glfwSetWindowPos((long)data.window, (int)((int)imVec2.x), (int)((int)imVec2.y));
        }
    }

    private static final class GetWindowPosFunction
    extends ImPlatformFuncViewportSuppImVec2 {
        private final int[] posX = new int[1];
        private final int[] posY = new int[1];

        private GetWindowPosFunction() {
        }

        @Override
        public void get(ImGuiViewport vp, ImVec2 dstImVec2) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            GLFW.glfwGetWindowPos((long)data.window, (int[])this.posX, (int[])this.posY);
            dstImVec2.x = this.posX[0];
            dstImVec2.y = this.posY[0];
        }
    }

    private static final class ShowWindowFunction
    extends ImPlatformFuncViewport {
        private ShowWindowFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            if (IS_WINDOWS && vp.hasFlags(16)) {
                ImGuiImplGlfwNative.win32hideFromTaskBar(vp.getPlatformHandleRaw());
            }
            GLFW.glfwShowWindow((long)data.window);
        }
    }

    private final class DestroyWindowFunction
    extends ImPlatformFuncViewport {
        private DestroyWindowFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = (ImGuiViewportDataGlfw)vp.getPlatformUserData();
            if (data != null && data.windowOwned) {
                for (int i = 0; i < ImGuiImplGlfw.this.keyOwnerWindows.length; ++i) {
                    if (ImGuiImplGlfw.this.keyOwnerWindows[i] != data.window) continue;
                    ImGuiImplGlfw.this.keyCallback(data.window, i, 0, 0, 0);
                }
                GLFW.glfwDestroyWindow((long)data.window);
            }
            vp.setPlatformUserData(null);
            vp.setPlatformHandle(0L);
        }
    }

    private final class CreateWindowFunction
    extends ImPlatformFuncViewport {
        private CreateWindowFunction() {
        }

        @Override
        public void accept(ImGuiViewport vp) {
            ImGuiViewportDataGlfw data = new ImGuiViewportDataGlfw();
            vp.setPlatformUserData(data);
            GLFW.glfwWindowHint((int)131076, (int)0);
            GLFW.glfwWindowHint((int)131073, (int)0);
            if (ImGuiImplGlfw.this.glfwHasFocusOnShow) {
                GLFW.glfwWindowHint((int)131084, (int)0);
            }
            GLFW.glfwWindowHint((int)131077, (int)(vp.hasFlags(8) ? 0 : 1));
            if (ImGuiImplGlfw.this.glfwHawWindowTopmost) {
                GLFW.glfwWindowHint((int)131079, (int)(vp.hasFlags(512) ? 1 : 0));
            }
            data.window = GLFW.glfwCreateWindow((int)((int)vp.getSizeX()), (int)((int)vp.getSizeY()), (CharSequence)"No Title Yet", (long)0L, (long)ImGuiImplGlfw.this.windowPtr);
            data.windowOwned = true;
            vp.setPlatformHandle(data.window);
            if (IS_WINDOWS) {
                vp.setPlatformHandleRaw(GLFWNativeWin32.glfwGetWin32Window((long)data.window));
            }
            GLFW.glfwSetWindowPos((long)data.window, (int)((int)vp.getPosX()), (int)((int)vp.getPosY()));
            GLFW.glfwSetMouseButtonCallback((long)data.window, ImGuiImplGlfw.this::mouseButtonCallback);
            GLFW.glfwSetScrollCallback((long)data.window, ImGuiImplGlfw.this::scrollCallback);
            GLFW.glfwSetKeyCallback((long)data.window, ImGuiImplGlfw.this::keyCallback);
            GLFW.glfwSetCharCallback((long)data.window, ImGuiImplGlfw.this::charCallback);
            GLFW.glfwSetWindowCloseCallback((long)data.window, x$0 -> ImGuiImplGlfw.this.windowCloseCallback(x$0));
            GLFW.glfwSetWindowPosCallback((long)data.window, (x$0, x$1, x$2) -> ImGuiImplGlfw.this.windowPosCallback(x$0, x$1, x$2));
            GLFW.glfwSetWindowSizeCallback((long)data.window, (x$0, x$1, x$2) -> ImGuiImplGlfw.this.windowSizeCallback(x$0, x$1, x$2));
            GLFW.glfwMakeContextCurrent((long)data.window);
            GLFW.glfwSwapInterval((int)0);
        }
    }
}

