/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.util;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class TeleportPos {
    private final ResourceKey<Level> dimension;
    private final BlockPos pos;
    public final Float yRot;
    public final Float xRot;
    private final long time;

    public TeleportPos(ResourceKey<Level> d, BlockPos p) {
        this(d, p, null, null);
    }

    public TeleportPos(ResourceKey<Level> d, BlockPos p, Float yRot, Float xRot) {
        this.dimension = d;
        this.pos = p;
        this.yRot = yRot;
        this.xRot = xRot;
        this.time = System.currentTimeMillis();
    }

    public TeleportPos(Level world, BlockPos p, Float yRot, Float xRot) {
        this((ResourceKey<Level>)world.m_46472_(), p, yRot, xRot);
    }

    public TeleportPos(Entity entity) {
        this(entity.m_9236_(), entity.m_20183_(), Float.valueOf(entity.m_146908_()), Float.valueOf(entity.m_146909_()));
    }

    public TeleportPos(CompoundTag tag) {
        this.dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("dim")));
        this.pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
        this.yRot = tag.m_128435_("yRot") == 5 ? Float.valueOf(tag.m_128457_("yRot")) : null;
        this.xRot = tag.m_128435_("xRot") == 5 ? Float.valueOf(tag.m_128457_("xRot")) : null;
        this.time = tag.m_128454_("time");
    }

    public TeleportResult teleport(ServerPlayer player) {
        ServerLevel level = player.f_8924_.m_129880_(this.dimension);
        if (level == null) {
            return TeleportResult.DIMENSION_NOT_FOUND;
        }
        int xpLevel = player.f_36078_;
        float xrot = this.xRot == null ? player.m_146909_() : this.xRot.floatValue();
        float yrot = this.yRot == null ? player.m_146908_() : this.yRot.floatValue();
        player.m_8999_(level, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.1, (double)this.pos.m_123343_() + 0.5, yrot, xrot);
        player.m_9174_(xpLevel);
        return TeleportResult.SUCCESS;
    }

    public CompoundTag write() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.singleLine();
        tag.m_128359_("dim", this.dimension.m_135782_().toString());
        tag.m_128405_("x", this.pos.m_123341_());
        tag.m_128405_("y", this.pos.m_123342_());
        tag.m_128405_("z", this.pos.m_123343_());
        tag.m_128356_("time", this.time);
        if (this.xRot != null) {
            tag.m_128350_("xRot", this.xRot.floatValue());
        }
        if (this.yRot != null) {
            tag.m_128350_("yRot", this.yRot.floatValue());
        }
        return tag;
    }

    public String distanceString(TeleportPos origin) {
        if (origin.dimension == this.dimension) {
            double dx = this.pos.m_123341_() - origin.pos.m_123341_();
            double dz = this.pos.m_123343_() - origin.pos.m_123343_();
            return (int)Math.sqrt(dx * dx + dz * dz) + "m";
        }
        ResourceLocation s = this.dimension.m_135782_();
        if (s.m_135827_().equals("minecraft")) {
            return switch (s.m_135815_()) {
                case "overworld" -> "Overworld";
                case "the_nether" -> "The Nether";
                case "the_end" -> "The End";
                default -> s.m_135815_();
            };
        }
        return s.m_135815_() + " [" + s.m_135827_() + "]";
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    @FunctionalInterface
    public static interface TeleportResult {
        public static final TeleportResult SUCCESS = new TeleportResult(){

            @Override
            public int runCommand(ServerPlayer player) {
                return 1;
            }

            @Override
            public boolean isSuccess() {
                return true;
            }
        };
        public static final TeleportResult DIMENSION_NOT_FOUND = TeleportResult.failed((Component)Component.m_237113_((String)"Dimension not found!"));
        public static final TeleportResult UNKNOWN_DESTINATION = TeleportResult.failed((Component)Component.m_237113_((String)"Unknown destination!"));

        public static TeleportResult failed(Component msg) {
            return player -> {
                player.m_5661_(msg, false);
                return 0;
            };
        }

        public int runCommand(ServerPlayer var1);

        default public boolean isSuccess() {
            return false;
        }
    }

    @FunctionalInterface
    public static interface CooldownTeleportResult
    extends TeleportResult {
        public long getCooldown();

        @Override
        default public int runCommand(ServerPlayer player) {
            String secStr = TimeUtils.prettyTimeString((long)(this.getCooldown() / 1000L));
            player.m_5661_((Component)Component.m_237113_((String)("Can't teleport yet! Cooldown: " + secStr)), false);
            return 0;
        }
    }
}

