/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelWriter;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.silentchaos512.lib.network.internal.SilentLibNetwork;
import net.silentchaos512.lib.network.internal.SpawnEntityPacket;

@Mod.EventBusSubscriber(modid="silentlib")
public final class EntityHelper {
    private static volatile Queue<Entity> entitiesToSpawn = new ConcurrentLinkedDeque<Entity>();

    private EntityHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static void safeSpawn(Entity entity) {
        entitiesToSpawn.add(entity);
    }

    public static void spawnWithClientPacket(LevelWriter world, Entity entity) {
        EntityHelper.spawnWithClientPacket(world, entity, 4096.0);
    }

    public static void spawnWithClientPacket(LevelWriter world, Entity entity, double r2) {
        world.m_7967_(entity);
        if (world instanceof ServerLevel) {
            SpawnEntityPacket message = new SpawnEntityPacket(entity);
            SilentLibNetwork.channel.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_(), (double)r2, (ResourceKey)entity.m_9236_().m_46472_())), (Object)message);
        }
    }

    private static void handleSpawns() {
        Entity entity;
        while ((entity = entitiesToSpawn.poll()) != null) {
            entity.m_9236_().m_7967_(entity);
        }
    }

    public static void heal(LivingEntity entity, float healAmount, boolean cancelable) {
        if (cancelable) {
            entity.m_5634_(healAmount);
        } else {
            entity.m_21153_(entity.m_21223_() + healAmount);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.type == TickEvent.Type.LEVEL) {
            EntityHelper.handleSpawns();
        }
    }
}

