/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.event;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.item.LocoRouteItem;
import dev.murad.shipping.item.TugRouteItem;
import dev.murad.shipping.network.client.EntityPosition;
import dev.murad.shipping.network.client.VehicleTrackerPacketHandler;
import dev.murad.shipping.setup.EntityItemMap;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.LocoRouteNode;
import dev.murad.shipping.util.RailHelper;
import dev.murad.shipping.util.TugRoute;
import dev.murad.shipping.util.TugRouteNode;
import java.util.OptionalDouble;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BeaconRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Quaternionf;
import org.joml.Vector2d;
import org.joml.Vector2dc;

@Mod.EventBusSubscriber(modid="littlelogistics", value={Dist.CLIENT})
public class ForgeClientEventHandler {
    public static final ResourceLocation BEAM_LOCATION = new ResourceLocation("littlelogistics", "textures/entity/beacon_beam.png");

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        VehicleTrackerPacketHandler.flush();
    }

    private static boolean renderRouteOnStack(RenderLevelStageEvent event, Player player, ItemStack stack) {
        if (stack.m_41720_().equals(ModItems.LOCO_ROUTE.get())) {
            MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            PoseStack pose = event.getPoseStack();
            Vec3 cameraOff = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            for (LocoRouteNode node : LocoRouteItem.getRoute(stack)) {
                BlockPos block = node.toBlockPos();
                pose.m_85836_();
                pose.m_85837_((double)block.m_123341_() - cameraOff.f_82479_, 1.0 - cameraOff.f_82480_, (double)block.m_123343_() - cameraOff.f_82481_);
                BeaconRenderer.m_112184_((PoseStack)pose, (MultiBufferSource)buffer, (ResourceLocation)BEAM_LOCATION, (float)event.getPartialTick(), (float)1.0f, (long)player.m_9236_().m_46467_(), (int)(player.m_9236_().m_141937_() + 1), (int)1024, (float[])DyeColor.YELLOW.m_41068_(), (float)0.1f, (float)0.2f);
                pose.m_85849_();
                pose.m_85836_();
                RailShape shape = RailHelper.getRail(block, player.m_9236_()).map(pos -> RailHelper.getShape(pos, player.m_9236_())).orElse(RailShape.EAST_WEST);
                double baseY = shape.m_61745_() ? 0.1 : 0.0;
                double baseX = 0.0;
                double baseZ = 0.0;
                Quaternionf rotation = Axis.f_252403_.m_252977_(0.0f);
                switch (shape) {
                    case ASCENDING_EAST: {
                        baseX = 0.2;
                        rotation = Axis.f_252403_.m_252977_(45.0f);
                        break;
                    }
                    case ASCENDING_WEST: {
                        baseX = 0.1;
                        baseY += 0.7;
                        rotation = Axis.f_252403_.m_252977_(-45.0f);
                        break;
                    }
                    case ASCENDING_NORTH: {
                        baseZ = 0.1;
                        baseY += 0.7;
                        rotation = Axis.f_252529_.m_252977_(45.0f);
                        break;
                    }
                    case ASCENDING_SOUTH: {
                        baseZ = 0.2;
                        rotation = Axis.f_252529_.m_252977_(-45.0f);
                    }
                }
                pose.m_85837_((double)block.m_123341_() + baseX - cameraOff.f_82479_, (double)block.m_123342_() + baseY - cameraOff.f_82480_, (double)block.m_123343_() + baseZ - cameraOff.f_82481_);
                pose.m_252781_(rotation);
                AABB a = new AABB(0.0, 0.0, 0.0, 1.0, 0.2, 1.0);
                LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)buffer.m_6299_(ModRenderType.LINES), (AABB)a, (float)1.0f, (float)1.0f, (float)0.3f, (float)0.5f);
                pose.m_85849_();
            }
            buffer.m_109911_();
        } else if (stack.m_41720_().equals(ModItems.TUG_ROUTE.get())) {
            if (((Boolean)ShippingConfig.Client.DISABLE_TUG_ROUTE_BEACONS.get()).booleanValue()) {
                return false;
            }
            Camera camera = Minecraft.m_91087_().m_91290_().f_114358_;
            Vec3 camPos = camera.m_90583_();
            MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            TugRoute route = TugRouteItem.getRoute(stack);
            int routeSize = route.size();
            for (int i = 0; i < routeSize; ++i) {
                TugRouteNode node = (TugRouteNode)route.get(i);
                Vector2d playerDir = new Vector2d(node.getX() + 0.5, node.getZ() + 0.5).sub((Vector2dc)new Vector2d(camPos.f_82479_, camPos.f_82481_)).normalize(0.5);
                PoseStack matrixStack = event.getPoseStack();
                matrixStack.m_85836_();
                matrixStack.m_85837_(node.getX() - camPos.f_82479_, 0.0, node.getZ() - camPos.f_82481_);
                BeaconRenderer.m_112184_((PoseStack)matrixStack, (MultiBufferSource)renderTypeBuffer, (ResourceLocation)BEAM_LOCATION, (float)event.getPartialTick(), (float)1.0f, (long)player.m_9236_().m_46467_(), (int)player.m_9236_().m_141937_(), (int)1024, (float[])DyeColor.ORANGE.m_41068_(), (float)0.1f, (float)0.2f);
                matrixStack.m_85849_();
                matrixStack.m_85836_();
                Vec3 nodePos = new Vec3(node.getX() + 0.5 - playerDir.x, camPos.f_82480_, node.getZ() + 0.5 - playerDir.y);
                Vec3 textRenderPos = ForgeClientEventHandler.computeFixedDistance(nodePos, camPos, 1.0);
                matrixStack.m_85837_(textRenderPos.f_82479_ - camPos.f_82479_, textRenderPos.f_82480_ - camPos.f_82480_, textRenderPos.f_82481_ - camPos.f_82481_);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(-camera.m_90590_()));
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(camera.m_90589_()));
                matrixStack.m_85841_(-0.025f, -0.025f, -0.025f);
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                String text = node.getDisplayName(i);
                float width = (float)(-fontRenderer.m_92895_(text)) / 2.0f;
                fontRenderer.m_271703_(text, width, 0.0f, -1, true, matrixStack.m_85850_().m_252922_(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                matrixStack.m_85849_();
            }
            renderTypeBuffer.m_109911_();
        } else {
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public static void onRenderWorldLast(RenderLevelStageEvent event) {
        if (!event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_TRIPWIRE_BLOCKS)) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack mainStack = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offStack = player.m_21120_(InteractionHand.OFF_HAND);
        ForgeClientEventHandler.renderRouteOnStack(event, (Player)player, mainStack);
        ForgeClientEventHandler.renderRouteOnStack(event, (Player)player, offStack);
        if (mainStack.m_41720_().equals(ModItems.CONDUCTORS_WRENCH.get()) && player.m_9236_().m_46472_().toString().equals(VehicleTrackerPacketHandler.toRenderDimension)) {
            MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
            Camera camera = Minecraft.m_91087_().m_91290_().f_114358_;
            Vec3 camPos = camera.m_90583_();
            for (EntityPosition position : VehicleTrackerPacketHandler.toRender) {
                Entity entity = player.m_9236_().m_6815_(position.id());
                Vec3 entityPos = entity != null ? entity.m_20318_(event.getPartialTick()) : position.pos();
                Vec3 iconRenderPos = ForgeClientEventHandler.computeFixedDistance(entityPos, camPos, 1.0);
                Vec3 textRenderPos = ForgeClientEventHandler.computeFixedDistance(entityPos, camPos, 0.9);
                PoseStack matrixStack = event.getPoseStack();
                matrixStack.m_85836_();
                matrixStack.m_85837_(iconRenderPos.f_82479_ - camPos.f_82479_, iconRenderPos.f_82480_ - camPos.f_82480_, iconRenderPos.f_82481_ - camPos.f_82481_);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(-camera.m_90590_()));
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(camera.m_90589_()));
                Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)EntityItemMap.get(position.type())), ItemDisplayContext.GROUND, 150, OverlayTexture.f_118083_, matrixStack, (MultiBufferSource)renderTypeBuffer, player.m_9236_(), position.id());
                matrixStack.m_85849_();
                matrixStack.m_85836_();
                matrixStack.m_85837_(textRenderPos.f_82479_ - camPos.f_82479_, textRenderPos.f_82480_ - camPos.f_82480_, textRenderPos.f_82481_ - camPos.f_82481_);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(-camera.m_90590_()));
                matrixStack.m_252781_(Axis.f_252529_.m_252977_(camera.m_90589_()));
                matrixStack.m_85841_(-0.025f, -0.025f, -0.025f);
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                String text = String.format("%.1fm", position.pos().m_82554_(player.m_20182_()));
                fontRenderer.m_271703_(text, (float)(-fontRenderer.m_92895_(text)) / 2.0f, 0.0f, -1, true, matrixStack.m_85850_().m_252922_(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                if (entity != null && entity.m_8077_()) {
                    Component name = entity.m_7770_();
                    matrixStack.m_252880_(0.0f, -20.0f, 0.0f);
                    fontRenderer.m_272077_(name, (float)(-fontRenderer.m_92852_((FormattedText)name)) / 2.0f, 0.0f, -1, true, matrixStack.m_85850_().m_252922_(), (MultiBufferSource)renderTypeBuffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                matrixStack.m_85849_();
            }
            renderTypeBuffer.m_109911_();
        }
    }

    private static Vec3 computeFixedDistance(Vec3 target, Vec3 position, double scale) {
        target = target.m_82520_(0.0, 2.0, 0.0);
        Vec3 delta = position.m_82505_(target);
        double dist = Math.min(5.0, delta.m_82553_());
        return position.m_82549_(delta.m_82541_().m_82490_(dist * scale));
    }

    public static class ModRenderType
    extends RenderType {
        public static final RenderType LINES = ModRenderType.m_173215_((String)"lines", (VertexFormat)DefaultVertexFormat.f_166851_, (VertexFormat.Mode)VertexFormat.Mode.LINES, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(f_173095_).m_110673_(new RenderStateShard.LineStateShard(OptionalDouble.empty())).m_110669_(f_110119_).m_110663_(RenderStateShard.f_110111_).m_110675_(f_110129_).m_110687_(f_110114_).m_110661_(f_110110_).m_110691_(false));

        public ModRenderType(String pName, VertexFormat pFormat, VertexFormat.Mode pMode, int pBufferSize, boolean pAffectsCrumbling, boolean pSortOnUpload, Runnable pSetupState, Runnable pClearState) {
            super(pName, pFormat, pMode, pBufferSize, pAffectsCrumbling, pSortOnUpload, pSetupState, pClearState);
        }
    }
}

