/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.fluid;

import dev.murad.shipping.block.IVesselLoader;
import dev.murad.shipping.block.fluid.FluidHopperBlock;
import dev.murad.shipping.setup.ModTileEntitiesTypes;
import dev.murad.shipping.util.FluidDisplayUtil;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidHopperTileEntity
extends BlockEntity
implements IVesselLoader {
    public static final int CAPACITY = 10000;
    private int cooldownTime = 0;
    protected FluidTank tank = new FluidTank(10000){

        protected void onContentsChanged() {
            BlockState state = FluidHopperTileEntity.this.f_58857_.m_8055_(FluidHopperTileEntity.this.f_58858_);
            FluidHopperTileEntity.this.f_58857_.m_7260_(FluidHopperTileEntity.this.f_58858_, state, state, 3);
            FluidHopperTileEntity.this.m_6596_();
        }
    };
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);

    public FluidHopperTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntitiesTypes.FLUID_HOPPER.get(), pos, state);
    }

    public boolean use(Player player, InteractionHand hand) {
        boolean result = FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)this.tank);
        player.m_5661_(FluidDisplayUtil.getFluidDisplay(this.tank), false);
        return result;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.holder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.getTank().readFromNBT(tag);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.getTank().writeToNBT(tag);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    private void serverTickInternal() {
        if (this.f_58857_ != null) {
            --this.cooldownTime;
            if (this.cooldownTime <= 0) {
                this.cooldownTime = Boolean.logicalOr(this.tryExportFluid(), this.tryImportFluid()) ? 0 : 10;
            }
        }
    }

    private Optional<IFluidHandler> getExternalFluidHandler(BlockPos pos) {
        return Optional.ofNullable(this.f_58857_.m_7702_(pos)).map(tile -> tile.getCapability(ForgeCapabilities.FLUID_HANDLER)).flatMap(LazyOptional::resolve).map(Optional::of).orElseGet(() -> IVesselLoader.getEntityCapability(pos, ForgeCapabilities.FLUID_HANDLER, this.f_58857_));
    }

    private boolean tryImportFluid() {
        return this.getExternalFluidHandler(this.m_58899_().m_7494_()).map(iFluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)iFluidHandler, (int)50, (boolean)true).isEmpty()).orElse(false);
    }

    private boolean tryExportFluid() {
        return this.getExternalFluidHandler(this.m_58899_().m_121945_((Direction)this.m_58900_().m_61143_((Property)FluidHopperBlock.FACING))).map(iFluidHandler -> !FluidUtil.tryFluidTransfer((IFluidHandler)iFluidHandler, (IFluidHandler)this.tank, (int)50, (boolean)true).isEmpty()).orElse(false);
    }

    @Override
    public <T extends Entity> boolean hold(T vehicle, IVesselLoader.Mode mode) {
        return vehicle.getCapability(ForgeCapabilities.FLUID_HANDLER).map(iFluidHandler -> {
            switch (mode) {
                case IMPORT: {
                    return !FluidUtil.tryFluidTransfer((IFluidHandler)this.tank, (IFluidHandler)iFluidHandler, (int)1, (boolean)false).isEmpty();
                }
                case EXPORT: {
                    return !FluidUtil.tryFluidTransfer((IFluidHandler)iFluidHandler, (IFluidHandler)this.tank, (int)1, (boolean)false).isEmpty();
                }
            }
            return false;
        }).orElse(false);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, FluidHopperTileEntity e) {
        e.serverTickInternal();
    }
}

