/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.network.jei;

import com.smashingmods.alchemylib.api.item.IngredientStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class TransferUtils {
    public static int getMaxOperations(ItemStack pRecipeInput, boolean pMaxTransfer) {
        return TransferUtils.getMaxOperations(pRecipeInput, ItemStack.f_41583_, pMaxTransfer, true);
    }

    public static int getMaxOperations(List<ItemStack> pRecipeInputList, boolean pMaxTransfer) {
        return TransferUtils.getMaxOperations(pRecipeInputList, new ArrayList<ItemStack>(), pMaxTransfer, true);
    }

    public static int getMaxOperations(ItemStack pRecipeInput, ItemStack pInventoryInput, boolean pMaxTransfer, boolean pCreative) {
        int maxCount = pMaxTransfer ? (pCreative ? pRecipeInput.m_41741_() : pInventoryInput.m_41613_()) : pRecipeInput.m_41613_();
        return maxCount / pRecipeInput.m_41613_();
    }

    public static int getMaxOperations(List<ItemStack> pRecipeInputList, @Nonnull List<ItemStack> pInventoryItems, boolean pMaxTransfer, boolean pCreative) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (int i = 0; i < pRecipeInputList.size(); ++i) {
            if (pRecipeInputList.get(i).m_41613_() < 1) {
                ints.add(0);
                break;
            }
            int maxCount = pMaxTransfer ? (pCreative ? pRecipeInputList.get(i).m_41741_() : pInventoryItems.get(i).m_41613_()) : pRecipeInputList.get(i).m_41613_();
            ints.add(maxCount / pRecipeInputList.get(i).m_41613_());
        }
        return (Integer)Collections.min(ints);
    }

    public static ItemStack matchIngredientToItemStack(NonNullList<ItemStack> pItems, IngredientStack pIngredientStack) {
        AtomicReference atomicItem = new AtomicReference();
        boolean test = pItems.stream().anyMatch(itemStack -> {
            boolean matches = pIngredientStack.matches(itemStack);
            if (matches && itemStack.m_41613_() >= pIngredientStack.getCount()) {
                atomicItem.set(itemStack);
                return true;
            }
            return false;
        });
        return test ? (ItemStack)atomicItem.get() : ItemStack.f_41583_;
    }

    public static List<ItemStack> matchIngredientListToItemStack(NonNullList<ItemStack> pItems, List<IngredientStack> pIngredientStackList) {
        ArrayList<ItemStack> toReturn = new ArrayList<ItemStack>();
        for (IngredientStack ingredientStack : pIngredientStackList) {
            ItemStack itemStack = TransferUtils.matchIngredientToItemStack(pItems, ingredientStack);
            if (itemStack.m_41619_()) continue;
            toReturn.add(itemStack);
        }
        return toReturn;
    }
}

