/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.fusion;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.Config;
import com.smashingmods.alchemistry.common.block.fusion.FusionControllerMenu;
import com.smashingmods.alchemistry.common.block.reactor.AbstractReactorBlockEntity;
import com.smashingmods.alchemistry.common.block.reactor.ReactorType;
import com.smashingmods.alchemistry.common.network.SetRecipePacket;
import com.smashingmods.alchemistry.common.recipe.fusion.FusionRecipe;
import com.smashingmods.alchemistry.registry.BlockEntityRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.EnergyStorageHandler;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import com.smashingmods.chemlib.common.items.ElementItem;
import java.util.LinkedList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class FusionControllerBlockEntity
extends AbstractReactorBlockEntity {
    private FusionRecipe currentRecipe;
    private ResourceLocation recipeId;
    private boolean autoBalanced = false;

    public FusionControllerBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)BlockEntityRegistry.FUSION_CONTROLLER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.setReactorType(ReactorType.FUSION);
        this.setEnergyPerTick((Integer)Config.Common.fusionEnergyPerTick.get());
        this.setMaxProgress((Integer)Config.Common.fusionTicksPerOperation.get());
    }

    public void onLoad() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            RecipeRegistry.getFusionRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(this::setRecipe);
        }
        super.onLoad();
    }

    @Override
    public void tick() {
        if (this.isAutoBalanced()) {
            this.autoBalance();
        }
        super.tick();
    }

    public void updateRecipe() {
        if (!(this.f_58857_ == null || this.f_58857_.m_5776_() || this.getInputHandler().isEmpty() || this.isRecipeLocked())) {
            Predicate<FusionRecipe> recipePredicate = recipe -> {
                ItemStack input1 = this.getInputHandler().getStackInSlot(0);
                ItemStack input2 = this.getInputHandler().getStackInSlot(1);
                return ItemStack.m_150942_((ItemStack)recipe.getInput1(), (ItemStack)input1) && ItemStack.m_150942_((ItemStack)recipe.getInput2(), (ItemStack)input2) || ItemStack.m_150942_((ItemStack)recipe.getInput2(), (ItemStack)input1) && ItemStack.m_150942_((ItemStack)recipe.getInput1(), (ItemStack)input2);
            };
            RecipeRegistry.getFusionRecipe(recipePredicate, this.f_58857_).ifPresent(recipe -> {
                if (this.currentRecipe == null || !((Object)((Object)this.currentRecipe)).equals(recipe)) {
                    this.setProgress(0);
                    this.setRecipe(recipe.copy());
                }
            });
        }
    }

    public boolean canProcessRecipe() {
        if (this.currentRecipe != null) {
            FusionRecipe tempRecipe = this.currentRecipe.copy();
            ItemStack input1 = this.getInputHandler().getStackInSlot(0);
            ItemStack input2 = this.getInputHandler().getStackInSlot(1);
            ItemStack output = this.getOutputHandler().getStackInSlot(0);
            return this.getEnergyHandler().getEnergyStored() >= (Integer)Config.Common.fusionEnergyPerTick.get() && (ItemStack.m_150942_((ItemStack)input1, (ItemStack)tempRecipe.getInput1()) && input1.m_41613_() >= tempRecipe.getInput1().m_41613_() && ItemStack.m_150942_((ItemStack)input2, (ItemStack)tempRecipe.getInput2()) && input2.m_41613_() >= tempRecipe.getInput2().m_41613_() || ItemStack.m_150942_((ItemStack)input1, (ItemStack)tempRecipe.getInput2()) && input1.m_41613_() >= tempRecipe.getInput2().m_41613_() && ItemStack.m_150942_((ItemStack)input2, (ItemStack)tempRecipe.getInput1()) && input2.m_41613_() >= tempRecipe.getInput1().m_41613_()) && (ItemStack.m_150942_((ItemStack)output, (ItemStack)tempRecipe.getOutput()) || output.m_41619_()) && tempRecipe.getOutput().m_41613_() + output.m_41613_() <= tempRecipe.getOutput().m_41741_();
        }
        return false;
    }

    public void processRecipe() {
        if (this.getProgress() < this.getMaxProgress()) {
            this.incrementProgress();
        } else {
            FusionRecipe tempRecipe = this.currentRecipe.copy();
            this.setProgress(0);
            this.getInputHandler().decrementSlot(0, tempRecipe.getInput1().m_41613_());
            this.getInputHandler().decrementSlot(1, tempRecipe.getInput2().m_41613_());
            this.getOutputHandler().setOrIncrement(0, tempRecipe.getOutput());
        }
        this.getEnergyHandler().extractEnergy(this.getEnergyPerTick(), false);
        this.m_6596_();
    }

    public <R extends AbstractProcessingRecipe> void setRecipe(@Nullable R pRecipe) {
        if (pRecipe instanceof FusionRecipe) {
            FusionRecipe fusionRecipe;
            this.currentRecipe = fusionRecipe = (FusionRecipe)pRecipe;
        }
    }

    public FusionRecipe getRecipe() {
        return this.currentRecipe;
    }

    public LinkedList<FusionRecipe> getAllRecipes() {
        if (this.f_58857_ != null) {
            return new LinkedList<FusionRecipe>(RecipeRegistry.getFusionRecipes(this.f_58857_));
        }
        return new LinkedList<FusionRecipe>();
    }

    public void autoBalance() {
        if (this.currentRecipe != null && !this.getInputHandler().isEmpty() && ItemStack.m_150942_((ItemStack)this.currentRecipe.getInput1(), (ItemStack)this.currentRecipe.getInput2())) {
            ItemStack slot0 = this.getInputHandler().getStackInSlot(0);
            ItemStack slot1 = this.getInputHandler().getStackInSlot(1);
            if (slot0.m_41619_() && slot1.m_41613_() >= 2) {
                int split = slot1.m_41613_() / 2;
                int remainder = slot1.m_41613_() % 2;
                this.getInputHandler().decrementSlot(1, split + remainder);
                this.getInputHandler().setOrIncrement(0, new ItemStack((ItemLike)slot1.m_41720_(), split + remainder));
            } else if (slot1.m_41619_() && slot0.m_41613_() >= 2) {
                int split = slot0.m_41613_() / 2;
                int remainder = slot0.m_41613_() % 2;
                this.getInputHandler().decrementSlot(0, split + remainder);
                this.getInputHandler().setOrIncrement(1, new ItemStack((ItemLike)slot0.m_41720_(), split + remainder));
            } else if (slot0.m_41613_() > slot1.m_41613_() + 1 && slot1.m_41613_() < slot1.m_41741_()) {
                int difference = (slot0.m_41613_() - slot1.m_41613_()) / 2;
                this.getInputHandler().decrementSlot(0, difference);
                this.getInputHandler().incrementSlot(1, difference);
            } else if (slot1.m_41613_() > slot0.m_41613_() + 1 && slot0.m_41613_() < slot0.m_41741_()) {
                int difference = (slot1.m_41613_() - slot0.m_41613_()) / 2;
                this.getInputHandler().decrementSlot(1, difference);
                this.getInputHandler().incrementSlot(0, difference);
            }
        }
    }

    public boolean isAutoBalanced() {
        return this.autoBalanced;
    }

    public void setAutoBalanced(boolean pAutoBalanced) {
        this.autoBalanced = pAutoBalanced;
    }

    public EnergyStorageHandler initializeEnergyStorage() {
        return new EnergyStorageHandler((Integer)Config.Common.fusionEnergyCapacity.get()){

            protected void onEnergyChanged() {
                FusionControllerBlockEntity.this.m_6596_();
            }
        };
    }

    public ProcessingSlotHandler initializeInputHandler() {
        return new ProcessingSlotHandler(2){

            protected void onContentsChanged(int slot) {
                if (!this.isEmpty()) {
                    FusionControllerBlockEntity.this.updateRecipe();
                }
                FusionControllerBlockEntity.this.setCanProcess(FusionControllerBlockEntity.this.canProcessRecipe());
                FusionControllerBlockEntity.this.m_6596_();
            }

            public boolean isItemValid(int pSlot, @Nonnull ItemStack pItemStack) {
                if (FusionControllerBlockEntity.this.f_58857_ != null && !FusionControllerBlockEntity.this.f_58857_.m_5776_() && FusionControllerBlockEntity.this.autoBalanced && !FusionControllerBlockEntity.this.isRecipeLocked()) {
                    ItemStack slot0 = pSlot == 0 ? pItemStack : this.getStackInSlot(0);
                    ItemStack slot1 = pSlot == 1 ? pItemStack : this.getStackInSlot(1);
                    Predicate<FusionRecipe> recipePredicate = recipe -> {
                        if (slot0.m_41720_() instanceof ElementItem && slot1.m_41619_()) {
                            return ItemStack.m_150942_((ItemStack)recipe.getInput1(), (ItemStack)slot0) && ItemStack.m_150942_((ItemStack)recipe.getInput2(), (ItemStack)slot0);
                        }
                        if (slot1.m_41720_() instanceof ElementItem && slot0.m_41619_()) {
                            return ItemStack.m_150942_((ItemStack)recipe.getInput1(), (ItemStack)slot1) && ItemStack.m_150942_((ItemStack)recipe.getInput2(), (ItemStack)slot1);
                        }
                        return false;
                    };
                    RecipeRegistry.getFusionRecipe(recipePredicate, FusionControllerBlockEntity.this.f_58857_).ifPresent(recipe -> {
                        if (FusionControllerBlockEntity.this.currentRecipe == null || !((Object)((Object)FusionControllerBlockEntity.this.currentRecipe)).equals(recipe)) {
                            FusionControllerBlockEntity.this.setProgress(0);
                            FusionControllerBlockEntity.this.setRecipe(recipe);
                            FusionControllerBlockEntity.this.autoBalance();
                        }
                    });
                }
                if (FusionControllerBlockEntity.this.currentRecipe != null && FusionControllerBlockEntity.this.isRecipeLocked()) {
                    return Stream.of(FusionControllerBlockEntity.this.currentRecipe.getInput1(), FusionControllerBlockEntity.this.currentRecipe.getInput2()).anyMatch(itemStack -> ItemStack.m_150942_((ItemStack)pItemStack, (ItemStack)itemStack));
                }
                return pItemStack.m_41720_() instanceof ElementItem;
            }
        };
    }

    public ProcessingSlotHandler initializeOutputHandler() {
        return new ProcessingSlotHandler(1){

            public boolean isItemValid(int slot, ItemStack stack) {
                return false;
            }
        };
    }

    @Override
    protected void m_183515_(CompoundTag pTag) {
        pTag.m_128379_("autoBalanced", this.autoBalanced);
        if (this.currentRecipe != null) {
            pTag.m_128359_("recipeId", this.currentRecipe.m_6423_().toString());
        }
        super.m_183515_(pTag);
    }

    @Override
    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.recipeId = ResourceLocation.m_135820_((String)pTag.m_128461_("recipeId"));
        this.setAutoBalanced(pTag.m_128471_("autoBalanced"));
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            RecipeRegistry.getFusionRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(recipe -> {
                if (!((Object)recipe).equals((Object)this.currentRecipe)) {
                    this.setRecipe(recipe);
                    Alchemistry.PACKET_HANDLER.sendToServer(new SetRecipePacket(this.m_58899_(), recipe.m_6423_(), recipe.m_6076_()));
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new FusionControllerMenu(pContainerId, pInventory, (BlockEntity)this);
    }
}

