/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.entity.SeatEntity;
import com.mrcrayfish.furniture.util.VoxelShapeHelper;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChairBlock
extends FurnitureHorizontalBlock {
    public final ImmutableMap<BlockState, VoxelShape> SHAPES;

    public ChairBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)DIRECTION, (Comparable)Direction.NORTH));
        this.SHAPES = this.generateShapes((ImmutableList<BlockState>)this.m_49965_().m_61056_());
    }

    private ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape[] FRONT_LEFT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)2.0, (double)0.0, (double)12.0, (double)4.0, (double)8.0, (double)14.0), Direction.SOUTH));
        VoxelShape[] BACKREST = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.5, (double)10.0, (double)1.5, (double)14.5, (double)20.0, (double)3.5), Direction.SOUTH));
        VoxelShape[] BASE = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)1.5, (double)8.0, (double)1.5, (double)14.5, (double)10.0, (double)14.5), Direction.SOUTH));
        VoxelShape[] FRONT_RIGHT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)14.0, (double)8.0, (double)14.0), Direction.SOUTH));
        VoxelShape[] BACK_RIGHT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)4.0), Direction.SOUTH));
        VoxelShape[] BACK_LEFT_LEG = VoxelShapeHelper.getRotatedShapes(VoxelShapeHelper.rotate(Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)4.0), Direction.SOUTH));
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            Direction direction = (Direction)state.m_61143_((Property)DIRECTION);
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(FRONT_LEFT_LEG[direction.m_122416_()]);
            shapes.add(BACKREST[direction.m_122416_()]);
            shapes.add(BASE[direction.m_122416_()]);
            shapes.add(FRONT_RIGHT_LEG[direction.m_122416_()]);
            shapes.add(BACK_RIGHT_LEG[direction.m_122416_()]);
            shapes.add(BACK_LEFT_LEG[direction.m_122416_()]);
            builder.put((Object)state, (Object)VoxelShapeHelper.combineAll(shapes));
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter reader, BlockPos pos) {
        return (VoxelShape)this.SHAPES.get((Object)state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        return SeatEntity.create(level, pos, 0.4, player, (Direction)state.m_61143_((Property)DIRECTION));
    }
}

