/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.world.gen.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import quek.undergarden.registry.UGStructures;

public class BiggerJigsawStructure
extends Structure {
    public static final Codec<BiggerJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiggerJigsawStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)100).fieldOf("size").forGetter(structure -> structure.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter)).apply((Applicative)instance, BiggerJigsawStructure::new)).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    public BiggerJigsawStructure(Structure.StructureSettings structureSettings, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter) {
        super(structureSettings);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = maxDepth;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        random.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        int x = context.f_226628_().m_45604_() + random.m_188503_(16);
        int z = context.f_226628_().m_45605_() + random.m_188503_(16);
        int seaLevel = context.f_226622_().m_6337_();
        int y = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        NoiseColumn column = context.f_226622_().m_214184_(x, z, context.f_226629_(), context.f_226624_());
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(x, y, z);
        while (y > seaLevel) {
            BlockState state = column.m_183556_(y);
            BlockState state1 = column.m_183556_(--y);
            if (!state.m_60795_() || !state1.m_60783_((BlockGetter)EmptyBlockGetter.INSTANCE, (BlockPos)mutablePos.m_142448_(y), Direction.UP)) continue;
            break;
        }
        if (y <= seaLevel) {
            return Optional.empty();
        }
        BlockPos pos = new BlockPos(x, y, z);
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)pos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)UGStructures.BIGGER_JIGSAW.get();
    }
}

