/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal.dweller;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;

public class DwellerItemBasedSteering {
    private final SynchedEntityData entityData;
    private final EntityDataAccessor<Integer> boostTimeAccessor;
    private final EntityDataAccessor<Boolean> hasSaddleAccessor;
    public boolean boosting;
    public int boostTime;

    public DwellerItemBasedSteering(SynchedEntityData data, EntityDataAccessor<Integer> boostTimeAccessor, EntityDataAccessor<Boolean> hasSaddleAccessor) {
        this.entityData = data;
        this.boostTimeAccessor = boostTimeAccessor;
        this.hasSaddleAccessor = hasSaddleAccessor;
    }

    public void onSynced() {
        this.boosting = true;
        this.boostTime = 0;
    }

    public boolean boost(RandomSource random) {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.entityData.m_135381_(this.boostTimeAccessor, (Object)(random.m_188503_(841) + 140));
        return true;
    }

    public void tickBoost() {
        if (this.boosting && this.boostTime++ > this.boostTimeTotal()) {
            this.boosting = false;
        }
    }

    public float boostFactor() {
        return this.boosting ? 1.95f : 1.5f;
    }

    public int boostTimeTotal() {
        return (Integer)this.entityData.m_135370_(this.boostTimeAccessor);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        tag.m_128379_("Saddle", this.hasSaddle());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        this.setSaddle(tag.m_128471_("Saddle"));
    }

    public void setSaddle(boolean saddle) {
        this.entityData.m_135381_(this.hasSaddleAccessor, (Object)saddle);
    }

    public boolean hasSaddle() {
        return (Boolean)this.entityData.m_135370_(this.hasSaddleAccessor);
    }
}

