/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import quek.undergarden.registry.UGSoundEvents;

public class Gwib
extends WaterAnimal
implements Enemy {
    public Gwib(EntityType<? extends WaterAnimal> type, Level level) {
        super(type, level);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(1, (Goal)new GwibAttackGoal(this, 1.5, false));
        this.f_21345_.m_25352_(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.5, 120));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return WaterAnimal.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    public static boolean canGwibSpawn(EntityType<? extends WaterAnimal> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_46791_() != Difficulty.PEACEFUL && random.m_188503_(10) == 0 && level.m_8055_(pos).m_60713_(Blocks.f_49990_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 1;
    }

    protected PathNavigation m_6037_(Level level) {
        return new WaterBoundPathNavigation((Mob)this, level);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)UGSoundEvents.GWIB_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.GWIB_DEATH.get();
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.m_217043_().m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_((SoundEvent)UGSoundEvents.GWIB_FLOP.get(), 1.0f, this.m_6100_());
        }
        super.m_8107_();
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    protected boolean m_8028_() {
        return true;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 0.25f;
    }

    private boolean targetIsInWater(@Nullable LivingEntity target) {
        if (target != null) {
            return target.m_20069_();
        }
        return false;
    }

    static class GwibAttackGoal
    extends MeleeAttackGoal {
        private final Gwib gwib;

        public GwibAttackGoal(Gwib gwib, double speedModifier, boolean followingTargetEvenIfNotSeen) {
            super((PathfinderMob)gwib, speedModifier, followingTargetEvenIfNotSeen);
            this.gwib = gwib;
        }

        public boolean m_8036_() {
            return super.m_8036_() && this.gwib.targetIsInWater(this.gwib.m_5448_());
        }

        public boolean m_8045_() {
            return super.m_8045_() && this.gwib.targetIsInWater(this.gwib.m_5448_());
        }
    }
}

