/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.client;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.capability.IUndergardenPortal;
import quek.undergarden.client.model.BruteModel;
import quek.undergarden.client.model.DwellerModel;
import quek.undergarden.client.model.ForgottenGuardianModel;
import quek.undergarden.client.model.ForgottenModel;
import quek.undergarden.client.model.GloomperModel;
import quek.undergarden.client.model.GwibModel;
import quek.undergarden.client.model.GwiblingModel;
import quek.undergarden.client.model.MinionModel;
import quek.undergarden.client.model.MogModel;
import quek.undergarden.client.model.MuncherModel;
import quek.undergarden.client.model.NargoyleModel;
import quek.undergarden.client.model.RotbeastModel;
import quek.undergarden.client.model.RotlingModel;
import quek.undergarden.client.model.RotwalkerModel;
import quek.undergarden.client.model.ScintlingModel;
import quek.undergarden.client.model.SmogMogModel;
import quek.undergarden.client.model.SploogieModel;
import quek.undergarden.client.model.StonebornModel;
import quek.undergarden.client.model.UGModelLayers;
import quek.undergarden.client.render.blockentity.DepthrockBedRender;
import quek.undergarden.client.render.blockentity.GrongletRender;
import quek.undergarden.client.render.entity.BoomgourdRender;
import quek.undergarden.client.render.entity.BruteRender;
import quek.undergarden.client.render.entity.DwellerRender;
import quek.undergarden.client.render.entity.ForgottenGuardianRender;
import quek.undergarden.client.render.entity.ForgottenRender;
import quek.undergarden.client.render.entity.GloomperRender;
import quek.undergarden.client.render.entity.GrongletEntityRender;
import quek.undergarden.client.render.entity.GwibRender;
import quek.undergarden.client.render.entity.GwiblingRender;
import quek.undergarden.client.render.entity.MinionRender;
import quek.undergarden.client.render.entity.MogRender;
import quek.undergarden.client.render.entity.MuncherRender;
import quek.undergarden.client.render.entity.NargoyleRender;
import quek.undergarden.client.render.entity.RotbeastRender;
import quek.undergarden.client.render.entity.RotlingRender;
import quek.undergarden.client.render.entity.RotwalkerRender;
import quek.undergarden.client.render.entity.ScintlingRender;
import quek.undergarden.client.render.entity.SmogMogRender;
import quek.undergarden.client.render.entity.SploogieRender;
import quek.undergarden.client.render.entity.StonebornRender;
import quek.undergarden.client.render.entity.UGBoatRenderer;
import quek.undergarden.entity.UGBoat;
import quek.undergarden.entity.animal.dweller.Dweller;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGDimensions;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UndergardenCapabilities;

@Mod.EventBusSubscriber(modid="undergarden", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class UndergardenClient {
    private static final ResourceLocation VIRULENCE_HEARTS = new ResourceLocation("undergarden", "textures/gui/virulence_hearts.png");
    private static final ResourceLocation BRITTLENESS_ARMOR = new ResourceLocation("undergarden", "textures/gui/brittleness_armor.png");

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.DEPTHROCK_BED.get(), DepthrockBedRender::new);
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.UNDERGARDEN_SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.UNDERGARDEN_HANGING_SIGN.get(), HangingSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)UGBlockEntities.GRONGLET.get(), GrongletRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BOAT.get(), context -> new UGBoatRenderer(context, false));
        event.registerEntityRenderer((EntityType)UGEntityTypes.CHEST_BOAT.get(), context -> new UGBoatRenderer(context, true));
        event.registerEntityRenderer((EntityType)UGEntityTypes.BOOMGOURD.get(), BoomgourdRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.DEPTHROCK_PEBBLE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GOO_BALL.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTTEN_BLISTERBERRY.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BLISTERBOMB.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GRONGLET.get(), GrongletEntityRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MINION_PROJECTILE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MINION.get(), MinionRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTLING.get(), RotlingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTWALKER.get(), RotwalkerRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.ROTBEAST.get(), RotbeastRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.DWELLER.get(), DwellerRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GWIBLING.get(), GwiblingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.BRUTE.get(), BruteRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SCINTLING.get(), ScintlingRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GLOOMPER.get(), GloomperRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.STONEBORN.get(), StonebornRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.NARGOYLE.get(), NargoyleRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MUNCHER.get(), MuncherRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SPLOOGIE.get(), SploogieRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.GWIB.get(), GwibRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.MOG.get(), MogRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.SMOG_MOG.get(), SmogMogRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.FORGOTTEN.get(), ForgottenRender::new);
        event.registerEntityRenderer((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get(), ForgottenGuardianRender::new);
    }

    @SubscribeEvent
    public static void registerEntityLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(UGModelLayers.DEPTHROCK_BED_HEAD, DepthrockBedRender::createHeadLayer);
        event.registerLayerDefinition(UGModelLayers.DEPTHROCK_BED_FOOT, DepthrockBedRender::createFootLayer);
        event.registerLayerDefinition(UGModelLayers.GRONGLET, GrongletRender::createBodyLayer);
        for (UGBoat.Type boatType : UGBoat.Type.values()) {
            event.registerLayerDefinition(UGBoatRenderer.createBoatModelName(boatType), BoatModel::m_246613_);
            event.registerLayerDefinition(UGBoatRenderer.createChestBoatModelName(boatType), ChestBoatModel::m_247175_);
        }
        event.registerLayerDefinition(UGModelLayers.MINION, MinionModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTLING, RotlingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTWALKER, RotwalkerModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.ROTBEAST, RotbeastModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.DWELLER, () -> DwellerModel.createBodyLayer(0.0f));
        event.registerLayerDefinition(UGModelLayers.DWELLER_SADDLE, () -> DwellerModel.createBodyLayer(0.5f));
        event.registerLayerDefinition(UGModelLayers.GWIBLING, GwiblingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.BRUTE, BruteModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.SCINTLING, ScintlingModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.GLOOMPER, GloomperModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.STONEBORN, StonebornModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.NARGOYLE, NargoyleModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MUNCHER, MuncherModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.SPLOOGIE, SploogieModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.GWIB, GwibModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.MOG, MogModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.SMOG_MOG, SmogMogModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.FORGOTTEN, ForgottenModel::createBodyLayer);
        event.registerLayerDefinition(UGModelLayers.FORGOTTEN_INNER_ARMOR, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.1f), (float)0.0f), (int)64, (int)32));
        event.registerLayerDefinition(UGModelLayers.FORGOTTEN_OUTER_ARMOR, () -> LayerDefinition.m_171565_((MeshDefinition)HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.2f), (float)0.0f), (int)64, (int)32));
        event.registerLayerDefinition(UGModelLayers.FORGOTTEN_GUARDIAN, ForgottenGuardianModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((state, tintGetter, pos, tint) -> tintGetter != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)tintGetter, (BlockPos)pos) : FastColor.ARGB32.m_13660_((int)0, (int)91, (int)117, (int)91), new Block[]{(Block)UGBlocks.DEEPTURF_BLOCK.get(), (Block)UGBlocks.DEEPTURF.get(), (Block)UGBlocks.SHIMMERWEED.get(), (Block)UGBlocks.TALL_DEEPTURF.get(), (Block)UGBlocks.TALL_SHIMMERWEED.get(), (Block)UGBlocks.GLOOMGOURD_STEM.get(), (Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get(), (Block)UGBlocks.POTTED_SHIMMERWEED.get(), (Block)UGBlocks.DROOPVINE.get(), (Block)UGBlocks.DROOPVINE_PLANT.get()});
        event.register((state, world, pos, tint) -> FastColor.ARGB32.m_13660_((int)0, (int)54, (int)45, (int)66), new Block[]{(Block)UGBlocks.GLOOMGOURD_STEM.get(), (Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get()});
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        BlockColors bColors = event.getBlockColors();
        event.register((stack, tint) -> bColors.m_92577_(((BlockItem)stack.m_41720_()).m_40614_().m_49966_(), null, null, 0), new ItemLike[]{(ItemLike)UGBlocks.DEEPTURF_BLOCK.get(), (ItemLike)UGBlocks.DEEPTURF.get(), (ItemLike)UGBlocks.SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_DEEPTURF.get()});
        event.register((stack, tint) -> {
            if (tint == 0) {
                return FastColor.ARGB32.m_13660_((int)0, (int)91, (int)117, (int)91);
            }
            return -1;
        }, new ItemLike[]{(ItemLike)UGBlocks.SHIMMERWEED.get(), (ItemLike)UGBlocks.TALL_SHIMMERWEED.get()});
    }

    @SubscribeEvent
    public static void registerDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(UGDimensions.UNDERGARDEN_LEVEL.m_135782_(), new DimensionSpecialEffects(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, true){

            public Vec3 m_5927_(Vec3 fogColor, float brightness) {
                return fogColor;
            }

            public boolean m_5781_(int x, int y) {
                return false;
            }
        });
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.PLAYER_HEALTH.id(), "virulence_hearts", (gui, guiGraphics, partialTicks, width, height) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null && player.m_21023_((MobEffect)UGEffects.VIRULENCE.get()) && gui.shouldDrawSurvivalElements()) {
                UndergardenClient.renderVirulenceHearts(width, height, guiGraphics, gui, (Player)player);
            }
        });
        event.registerAbove(VanillaGuiOverlay.ARMOR_LEVEL.id(), "brittleness_armor", (gui, guiGraphics, partialTicks, width, height) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null && player.m_21023_((MobEffect)UGEffects.BRITTLENESS.get()) && gui.shouldDrawSurvivalElements()) {
                UndergardenClient.renderBrittlenessArmor(width, height, guiGraphics, gui, (Player)player);
            }
        });
        event.registerAbove(VanillaGuiOverlay.EXPERIENCE_BAR.id(), "dweller_xp_bar", (gui, guiGraphics, partialTicks, width, height) -> {
            Dweller dweller;
            Entity patt12157$temp;
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null && (patt12157$temp = player.m_20202_()) instanceof Dweller && (dweller = (Dweller)patt12157$temp).m_7132_() && minecraft.f_91072_.m_105288_()) {
                gui.m_280276_(guiGraphics, width / 2 - 91);
            }
        });
        event.registerAboveAll("undergarden_portal_overlay", (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
            Minecraft minecraft = Minecraft.m_91087_();
            Window window = minecraft.m_91268_();
            LocalPlayer player = minecraft.f_91074_;
            if (player != null) {
                player.getCapability(UndergardenCapabilities.UNDERGARDEN_PORTAL_CAPABILITY).ifPresent(consumer -> UndergardenClient.renderPortalOverlay(guiGraphics, minecraft, window, consumer, partialTick));
            }
        });
    }

    private static void renderBrittlenessArmor(int width, int height, GuiGraphics graphics, ForgeGui gui, Player player) {
        int x = width / 2 - 91;
        int y = height - 49;
        int level = player.m_21230_();
        for (int i = 1; level > 0 && i < 20; i += 2) {
            if (i < level) {
                graphics.m_280218_(BRITTLENESS_ARMOR, x, y, 34, 9, 9, 9);
            } else if (i == level) {
                graphics.m_280218_(BRITTLENESS_ARMOR, x, y, 25, 9, 9, 9);
            } else {
                graphics.m_280218_(BRITTLENESS_ARMOR, x, y, 16, 9, 9, 9);
            }
            x += 8;
        }
    }

    private static void renderVirulenceHearts(int width, int height, GuiGraphics graphics, ForgeGui gui, Player player) {
        boolean highlight;
        int health = Mth.m_14167_((float)player.m_21223_());
        boolean bl = highlight = gui.f_92976_ > (long)gui.m_93079_() && (gui.f_92976_ - (long)gui.m_93079_()) / 3L % 2L == 1L;
        if (health < gui.f_92973_ && player.f_19802_ > 0) {
            gui.f_92975_ = Util.m_137550_();
            gui.f_92976_ = gui.m_93079_() + 20;
        } else if (health > gui.f_92973_ && player.f_19802_ > 0) {
            gui.f_92975_ = Util.m_137550_();
            gui.f_92976_ = gui.m_93079_() + 10;
        }
        if (Util.m_137550_() - gui.f_92975_ > 1000L) {
            gui.f_92973_ = health;
            gui.f_92974_ = health;
            gui.f_92975_ = Util.m_137550_();
        }
        gui.f_92973_ = health;
        int healthLast = gui.f_92974_;
        AttributeInstance attrMaxHealth = player.m_21051_(Attributes.f_22276_);
        float healthMax = Math.max((float)attrMaxHealth.m_22135_(), (float)Math.max(healthLast, health));
        int absorb = Mth.m_14167_((float)player.m_6103_());
        int healthRows = Mth.m_14167_((float)((healthMax + (float)absorb) / 2.0f / 10.0f));
        int rowHeight = Math.max(10 - (healthRows - 2), 3);
        gui.f_92985_.m_188584_((long)(gui.m_93079_() * 312871));
        int x = width / 2 - 91;
        int y = height - 39;
        int regen = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            regen = gui.m_93079_() % Mth.m_14167_((float)(healthMax + 5.0f));
        }
        UndergardenClient.renderHearts(graphics, gui, player, x, y, rowHeight, regen, healthMax, health, healthLast, absorb, highlight);
    }

    private static void renderHearts(GuiGraphics graphics, ForgeGui gui, Player player, int x, int y, int height, int regen, float healthMax, int health, int healthLast, int absorb, boolean highlight) {
        Gui.HeartType heartType = Gui.HeartType.m_168732_((Player)player);
        int hardcoreOffset = 9 * (player.m_9236_().m_6106_().m_5466_() ? 5 : 0);
        int healthAmount = Mth.m_14165_((double)((double)healthMax / 2.0));
        int absorptionAmount = Mth.m_14165_((double)((double)absorb / 2.0));
        int l = healthAmount * 2;
        for (int i1 = healthAmount + absorptionAmount - 1; i1 >= 0; --i1) {
            int k2;
            boolean flag;
            int j1 = i1 / 10;
            int k1 = i1 % 10;
            int newX = x + k1 * 8;
            int newY = y - j1 * height;
            if (health + absorb <= 4) {
                newY += gui.f_92985_.m_188503_(2);
            }
            if (i1 < healthAmount && i1 == regen) {
                newY -= 2;
            }
            UndergardenClient.renderHeart(graphics, Gui.HeartType.CONTAINER, newX, newY, hardcoreOffset, highlight, false);
            int j2 = i1 * 2;
            boolean bl = flag = i1 >= healthAmount;
            if (flag && (k2 = j2 - l) < absorb) {
                boolean flag1 = k2 + 1 == absorb;
                UndergardenClient.renderHeart(graphics, heartType == Gui.HeartType.WITHERED ? heartType : Gui.HeartType.ABSORBING, newX, newY, hardcoreOffset, false, flag1);
            }
            if (highlight && j2 < healthLast) {
                boolean flag2 = j2 + 1 == healthLast;
                UndergardenClient.renderHeart(graphics, heartType, newX, newY, hardcoreOffset, true, flag2);
            }
            if (j2 >= health) continue;
            boolean flag3 = j2 + 1 == health;
            UndergardenClient.renderHeart(graphics, heartType, newX, newY, hardcoreOffset, false, flag3);
        }
    }

    private static void renderHeart(GuiGraphics graphics, Gui.HeartType type, int x, int y, int offset, boolean blinking, boolean halfHeart) {
        graphics.m_280218_(VIRULENCE_HEARTS, x, y, type.m_168734_(halfHeart, blinking), offset, 9, 9);
    }

    private static void renderPortalOverlay(GuiGraphics guiGraphics, Minecraft minecraft, Window window, IUndergardenPortal portal, float partialTicks) {
        PoseStack poseStack = guiGraphics.m_280168_();
        float alpha = portal.getPrevPortalAnimTime() + (portal.getPortalAnimTime() - portal.getPrevPortalAnimTime()) * partialTicks;
        if (alpha > 0.0f) {
            if (alpha < 1.0f) {
                alpha *= alpha;
                alpha *= alpha;
                alpha = alpha * 0.8f + 0.2f;
            }
            poseStack.m_85836_();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, alpha);
            TextureAtlasSprite textureatlassprite = minecraft.m_91289_().m_110907_().m_110882_(((Block)UGBlocks.UNDERGARDEN_PORTAL.get()).m_49966_());
            guiGraphics.m_280159_(0, 0, -90, window.m_85445_(), window.m_85446_(), textureatlassprite);
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            poseStack.m_85849_();
        }
    }

    public static void playPortalSound(Minecraft minecraft, Player player) {
        minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119766_((SoundEvent)((SoundEvent)UGSoundEvents.UNDERGARDEN_PORTAL_TRAVEL.get()), (float)(player.m_217043_().m_188501_() * 0.4f + 0.8f), (float)0.25f));
    }

    @Mod.EventBusSubscriber(modid="undergarden", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ForgeBusEvents {
        @SubscribeEvent
        public static void undergardenFog(ViewportEvent.RenderFog event) {
            LocalPlayer player;
            if (((Boolean)UndergardenConfig.Client.toggle_undergarden_fog.get()).booleanValue() && (player = Minecraft.m_91087_().f_91074_) != null && player.m_9236_().m_46472_() == UGDimensions.UNDERGARDEN_LEVEL && event.getCamera().m_167685_() == FogType.NONE && event.getType() == FogType.NONE) {
                event.setNearPlaneDistance(-30.0f);
                event.setFarPlaneDistance(225.0f);
                event.setFogShape(FogShape.SPHERE);
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void dontRenderJumpBarForDweller(RenderGuiOverlayEvent.Pre event) {
            if (event.getOverlay().id() == VanillaGuiOverlay.JUMP_BAR.id() && Minecraft.m_91087_().f_91074_.m_20202_() instanceof Dweller) {
                event.setCanceled(true);
            }
        }
    }
}

