/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual.gui;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.gui.ManualScreen;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;

public class GuiButtonManualLink
extends Button {
    public String localized;
    @Nullable
    public ManualInstance.ManualLink link;
    ManualScreen gui;
    public List<GuiButtonManualLink> otherParts = ImmutableList.of();

    public GuiButtonManualLink(ManualScreen gui, int x, int y, int w, int h, @Nullable ManualInstance.ManualLink link, String localized) {
        super(x, y, w, h, (Component)Component.m_237119_(), btn -> {
            if (link != null) {
                link.changePage(gui, true);
            }
        }, f_252438_);
        this.gui = gui;
        this.link = link;
        this.localized = localized;
        if (gui.manual.improveReadability()) {
            this.localized = ChatFormatting.BOLD + localized;
        }
    }

    public void m_88315_(GuiGraphics graphics, int mx, int my, float partialTicks) {
        boolean bl = this.f_93622_ = mx >= this.m_252754_() && my >= this.m_252907_() && mx < this.m_252754_() + this.f_93618_ && my < this.m_252907_() + this.f_93619_;
        if (this.f_93622_) {
            this.drawHovered(graphics, mx, my);
            for (GuiButtonManualLink btn : this.otherParts) {
                if (btn == this) continue;
                btn.drawHovered(graphics, mx, my);
            }
        }
    }

    private void drawHovered(GuiGraphics graphics, int mx, int my) {
        Font font = this.gui.manual.fontRenderer();
        graphics.m_280056_(font, this.localized, this.m_252754_(), this.m_252907_(), this.gui.manual.getHighlightColour(), false);
        String tooltip = this.link != null ? this.gui.manual.formatLink(this.link) : "Invalid link";
        graphics.m_280245_(font, Language.m_128107_().m_128112_((List)ImmutableList.of((Object)Component.m_237113_((String)tooltip))), mx + 8, my + 4);
    }
}

