/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.StackWithChance;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.tag.MCTag;
import com.blamejared.crafttweaker.api.util.Many;
import com.blamejared.crafttweaker.api.util.random.Percentaged;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;

public class CrTIngredientUtil {
    private CrTIngredientUtil() {
    }

    public static IngredientWithSize getIngredientWithSize(IIngredientWithAmount crafttweakerIngredient) {
        Ingredient basePredicate = crafttweakerIngredient.getIngredient().asVanillaIngredient();
        return new IngredientWithSize(basePredicate, crafttweakerIngredient.getAmount());
    }

    public static IngredientWithSize[] getIngredientsWithSize(IIngredientWithAmount[] crafttweakerIngredients) {
        IngredientWithSize[] result = new IngredientWithSize[crafttweakerIngredients.length];
        for (int i = 0; i < crafttweakerIngredients.length; ++i) {
            result[i] = new IngredientWithSize(crafttweakerIngredients[i].getIngredient().asVanillaIngredient(), crafttweakerIngredients[i].getAmount());
        }
        return result;
    }

    public static List<Lazy<ItemStack>> getNonNullList(IItemStack[] itemStacks) {
        ArrayList<Lazy<ItemStack>> result = new ArrayList<Lazy<ItemStack>>(itemStacks.length);
        for (IItemStack itemStack : itemStacks) {
            result.add(IESerializableRecipe.of(itemStack.getInternal()));
        }
        return result;
    }

    public static StackWithChance getStackWithChance(Percentaged<IItemStack> weightedStack) {
        ItemStack stack = ((IItemStack)weightedStack.getData()).getInternal();
        float weight = Mth.m_14036_((float)((float)weightedStack.getPercentage()), (float)0.0f, (float)1.0f);
        return new StackWithChance(stack, weight);
    }

    public static FluidTagInput getFluidTagInput(MCTag tag, int amount) {
        TagKey internal = tag.getTagKey();
        Preconditions.checkNotNull((Object)internal, (Object)("Invalid fluid tag used for recipe: " + tag));
        return new FluidTagInput((TagKey<Fluid>)internal, amount, null);
    }

    public static FluidTagInput getFluidTagInput(Many<MCTag> tag) {
        return CrTIngredientUtil.getFluidTagInput((MCTag)tag.getData(), tag.getAmount());
    }

    public static ItemStack[] getItemStacks(IItemStack[] ctStacks) {
        return (ItemStack[])Arrays.stream(ctStacks).map(IItemStack::getInternal).toArray(ItemStack[]::new);
    }
}

