/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.util.LazyOptional;

public final class ResettableCapability<T> {
    private final T containedValue;
    private final List<Runnable> onReset = new ArrayList<Runnable>();
    private LazyOptional<T> currentOptional = LazyOptional.empty();

    public ResettableCapability(T containedValue) {
        this.containedValue = containedValue;
    }

    public LazyOptional<T> getLO() {
        if (!this.currentOptional.isPresent()) {
            this.currentOptional = CapabilityUtils.constantOptional(this.containedValue);
        }
        return this.currentOptional;
    }

    public T get() {
        return this.containedValue;
    }

    public <A> LazyOptional<A> cast() {
        return this.getLO().cast();
    }

    public void reset() {
        this.currentOptional.invalidate();
        this.onReset.forEach(Runnable::run);
    }

    public void addResetListener(Runnable onReset) {
        this.onReset.add(onReset);
    }
}

