/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.client.render.tooltip.RevolverServerTooltip;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.network.MessageSpeedloaderSync;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.PacketDistributor;

public class RevolverItem
extends UpgradeableToolItem
implements IEItemInterfaces.IBulletContainer,
ZoomHandler.IZoomTool {
    public static UUID speedModUUID = Utils.generateNewUUID();
    public static UUID luckModUUID = Utils.generateNewUUID();
    float[] zoomSteps = new float[]{0.3125f, 0.4f, 0.5f, 0.625f};
    public static final Multimap<String, SpecialRevolver> specialRevolvers = ArrayListMultimap.create();
    public static final Map<String, SpecialRevolver> specialRevolversByTag = new HashMap<String, SpecialRevolver>();

    public RevolverItem() {
        super(new Item.Properties().m_41487_(1), "REVOLVER");
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    @Nullable
    public CompoundTag getShareTag(ItemStack stack) {
        return RevolverItem.copyBulletsToShareTag(stack, super.getShareTag(stack));
    }

    public static CompoundTag copyBulletsToShareTag(ItemStack stack, CompoundTag ret) {
        ret = ret == null ? new CompoundTag() : ret.m_6426_();
        CompoundTag retFinal = ret;
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handler -> {
            IEItemInterfaces.IBulletContainer container = (IEItemInterfaces.IBulletContainer)stack.m_41720_();
            NonNullList bullets = NonNullList.m_122780_((int)container.getBulletCount(stack), (Object)ItemStack.f_41583_);
            for (int i = 0; i < bullets.size(); ++i) {
                bullets.set(i, (Object)handler.getStackInSlot(i));
            }
            retFinal.m_128365_("bullets", (Tag)ContainerHelper.m_18973_((CompoundTag)new CompoundTag(), (NonNullList)bullets));
        });
        return retFinal;
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        super.readShareTag(stack, nbt);
        RevolverItem.readBulletsFromShareTag(stack, nbt);
    }

    public static void readBulletsFromShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null) {
            stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(handler -> {
                if (!(handler instanceof IItemHandlerModifiable)) {
                    return;
                }
                IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
                IEItemInterfaces.IBulletContainer container = (IEItemInterfaces.IBulletContainer)stack.m_41720_();
                NonNullList bullets = NonNullList.m_122780_((int)container.getBulletCount(stack), (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("bullets"), (NonNullList)bullets);
                for (int i = 0; i < bullets.size(); ++i) {
                    modifiable.setStackInSlot(i, (ItemStack)bullets.get(i));
                }
            });
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new IEItemStackHandler(stack){
                final LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(new ResourceLocation("immersiveengineering", "revolver"), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    @Override
    public int getSlotCount() {
        return 21;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 18, 80, 32, "REVOLVER", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 19, 100, 32, "REVOLVER", stack, true, level, getPlayer)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null).ifPresent(inv -> {
            if (!inv.getStackInSlot(18).m_41619_() && !inv.getStackInSlot(19).m_41619_()) {
                Utils.unlockIEAdvancement(player, "tools/upgrade_revolver");
            }
        });
    }

    @Nonnull
    public String m_5671_(@Nonnull ItemStack stack) {
        String tag = this.getRevolverDisplayTag(stack);
        if (!tag.isEmpty()) {
            return this.m_5524_() + "." + tag;
        }
        return super.m_5671_(stack);
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        String tag = this.getRevolverDisplayTag(stack);
        if (!tag.isEmpty()) {
            list.add((Component)Component.m_237115_((String)("desc.immersiveengineering.flavour.revolver." + tag)));
        } else if (ItemNBTHelper.hasKey(stack, "flavour")) {
            list.add((Component)Component.m_237115_((String)("desc.immersiveengineering.flavour.revolver." + ItemNBTHelper.getString(stack, "flavour"))));
        } else {
            list.add((Component)Component.m_237115_((String)"desc.immersiveengineering.flavour.revolver"));
        }
        CompoundTag perks = RevolverItem.getPerks(stack);
        for (String key : perks.m_128431_()) {
            RevolverPerk perk = RevolverPerk.get(key);
            if (perk == null) continue;
            list.add((Component)Component.m_237113_((String)"  ").m_7220_(perk.getDisplayString(perks.m_128459_(key))));
        }
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack pStack) {
        return Optional.of(new RevolverServerTooltip(this.getBullets(pStack), this.getBulletCount(pStack)));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.MAINHAND) {
            double melee;
            if (this.getUpgrades(stack).m_128471_("fancyAnimation")) {
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.0, AttributeModifier.Operation.ADDITION));
            }
            if ((melee = RevolverItem.getUpgradeValue_d(stack, "melee")) != 0.0) {
                builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", melee, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
            }
        }
        if (slot.m_20743_() == EquipmentSlot.Type.HAND) {
            double luck;
            double speed = RevolverItem.getUpgradeValue_d(stack, "speed");
            if (speed != 0.0) {
                builder.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(speedModUUID, "Weapon modifier", speed, AttributeModifier.Operation.MULTIPLY_BASE));
            }
            if ((luck = RevolverItem.getUpgradeValue_d(stack, RevolverPerk.LUCK.getNBTKey())) != 0.0) {
                builder.put((Object)Attributes.f_22286_, (Object)new AttributeModifier(luckModUUID, "Weapon modifier", luck, AttributeModifier.Operation.ADDITION));
            }
        }
        return builder.build();
    }

    public void m_6883_(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity ent, int slot, boolean inHand) {
        super.m_6883_(stack, world, ent, slot, inHand);
        if (ItemNBTHelper.hasKey(stack, "reload")) {
            int reload = ItemNBTHelper.getInt(stack, "reload") - 1;
            if (reload <= 0) {
                ItemNBTHelper.remove(stack, "reload");
            } else {
                ItemNBTHelper.putInt(stack, "reload", reload);
            }
        }
        if (ItemNBTHelper.hasKey(stack, "cooldown")) {
            int cooldown = ItemNBTHelper.getInt(stack, "cooldown") - 1;
            if (cooldown <= 0) {
                ItemNBTHelper.remove(stack, "cooldown");
            } else {
                ItemNBTHelper.putInt(stack, "cooldown", cooldown);
            }
        }
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.BOW;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack revolver = player.m_21120_(hand);
        if (!world.f_46443_) {
            if (player.m_6144_()) {
                this.openGui(player, hand);
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)revolver);
            }
            if (player.m_36403_(1.0f) >= 1.0f) {
                if (this.getUpgrades(revolver).m_128471_("nerf")) {
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 0.6f);
                } else {
                    if (this.getShootCooldown(revolver) > 0 || ItemNBTHelper.hasKey(revolver, "reload")) {
                        return new InteractionResultHolder(InteractionResult.PASS, (Object)revolver);
                    }
                    NonNullList<ItemStack> bullets = this.getBullets(revolver);
                    if (this.isEmpty(revolver, false)) {
                        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                            ItemStack stack = player.m_150109_().m_8020_(i);
                            if (!(stack.m_41720_() instanceof SpeedloaderItem) || ((SpeedloaderItem)stack.m_41720_()).isEmpty(stack)) continue;
                            for (ItemStack b : bullets) {
                                if (b.m_41619_()) continue;
                                world.m_7967_((Entity)new ItemEntity(world, player.m_20185_(), player.m_20186_(), player.m_20189_(), b));
                            }
                            this.setBullets(revolver, ((SpeedloaderItem)stack.m_41720_()).getContainedItems(stack), true);
                            ((SpeedloaderItem)stack.m_41720_()).setContainedItems(stack, (NonNullList<ItemStack>)NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_));
                            player.m_150109_().m_6596_();
                            if (player instanceof ServerPlayer) {
                                ImmersiveEngineering.packetHandler.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageSpeedloaderSync(i, hand));
                            }
                            ItemNBTHelper.putInt(revolver, "reload", 60);
                            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)revolver);
                        }
                    }
                    if (!ItemNBTHelper.hasKey(revolver, "reload")) {
                        ItemStack bulletStack = (ItemStack)bullets.get(0);
                        Item bullet0 = bulletStack.m_41720_();
                        if (bullet0 instanceof BulletItem) {
                            BulletHandler.IBullet bullet = ((BulletItem)bullet0).getType();
                            if (bullet != null) {
                                float noise = RevolverItem.fireProjectile(world, (LivingEntity)player, revolver, bullet, bulletStack);
                                bullets.set(0, (Object)bullet.getCasing((ItemStack)bullets.get(0)).m_41777_());
                                Utils.attractEnemies((LivingEntity)player, 64.0f * noise);
                                if (noise > 0.2f) {
                                    GameEvent eventTriggered = (double)noise > 0.5 ? GameEvent.f_157812_ : GameEvent.f_157778_;
                                    world.m_214171_(eventTriggered, player.m_20182_(), GameEvent.Context.m_223717_((Entity)player));
                                }
                            } else {
                                world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12215_.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            }
                        } else {
                            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundEvents.f_12215_.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                        }
                        this.rotateCylinder(revolver, player, true, bullets);
                        ItemNBTHelper.putInt(revolver, "cooldown", this.getMaxShootCooldown(revolver));
                        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)revolver);
                    }
                }
            }
        } else if (!player.m_6144_()) {
            ShaderRegistry.ShaderAndCase shader;
            if (this.getShootCooldown(revolver) > 0 || ItemNBTHelper.hasKey(revolver, "reload")) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)revolver);
            }
            NonNullList<ItemStack> bullets = this.getBullets(revolver);
            if (!((ItemStack)bullets.get(0)).m_41619_() && ((ItemStack)bullets.get(0)).m_41720_() instanceof BulletItem && (shader = ShaderRegistry.getStoredShaderAndCase(revolver)) != null) {
                Vec3 pos = Utils.getLivingFrontPos((LivingEntity)player, 0.75, (double)player.m_20206_() * 0.75, ItemUtils.getLivingHand((LivingEntity)player, hand), false, 1.0f);
                shader.registryEntry().getEffectFunction().execute(world, shader.shader(), revolver, shader.sCase().getShaderType().toString(), pos, Vec3.m_82503_((Vec2)player.m_20155_()), 0.125f);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)revolver);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)revolver);
    }

    public static float fireProjectile(Level world, LivingEntity shooter, ItemStack revolver, BulletHandler.IBullet bullet, ItemStack bulletStack) {
        SoundEvent sound;
        Player p;
        Player player = shooter instanceof Player ? (p = (Player)shooter) : null;
        Vec3 vec = shooter.m_20154_();
        boolean electro = RevolverItem.getUpgradesStatic(revolver).m_128471_("electro");
        int count = bullet.getProjectileCount(player);
        if (count == 1) {
            RevolvershotEntity entBullet = RevolverItem.getBullet(shooter, vec, bullet, electro);
            shooter.m_9236_().m_7967_(bullet.getProjectile(player, bulletStack, (Entity)entBullet, electro));
        } else {
            for (int i = 0; i < count; ++i) {
                Vec3 vecDir = vec.m_82520_(shooter.m_217043_().m_188583_() * 0.1, shooter.m_217043_().m_188583_() * 0.1, shooter.m_217043_().m_188583_() * 0.1);
                RevolvershotEntity entBullet = RevolverItem.getBullet(shooter, vecDir, bullet, electro);
                shooter.m_9236_().m_7967_(bullet.getProjectile(player, bulletStack, (Entity)entBullet, electro));
            }
        }
        float noise = 0.5f;
        if (RevolverItem.hasUpgradeValue(revolver, RevolverPerk.NOISE.getNBTKey())) {
            noise *= (float)RevolverItem.getUpgradeValue_d(revolver, RevolverPerk.NOISE.getNBTKey());
        }
        if ((sound = bullet.getSound()) == null) {
            sound = (SoundEvent)IESounds.revolverFire.get();
        }
        world.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), sound, SoundSource.PLAYERS, noise, 1.0f);
        return noise;
    }

    public int getShootCooldown(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, "cooldown");
    }

    public int getMaxShootCooldown(ItemStack stack) {
        if (RevolverItem.hasUpgradeValue(stack, RevolverPerk.COOLDOWN.getNBTKey())) {
            return (int)Math.ceil(15.0 * RevolverItem.getUpgradeValue_d(stack, RevolverPerk.COOLDOWN.getNBTKey()));
        }
        return 15;
    }

    @Override
    public int getBulletCount(ItemStack revolver) {
        return 8 + this.getUpgrades(revolver).m_128451_("bullets");
    }

    @Override
    public NonNullList<ItemStack> getBullets(ItemStack revolver) {
        return ListUtils.fromItems(this.getContainedItems(revolver).subList(0, this.getBulletCount(revolver)));
    }

    private static RevolvershotEntity getBullet(LivingEntity living, Vec3 vecDir, BulletHandler.IBullet type, boolean electro) {
        RevolvershotEntity bullet = new RevolvershotEntity(living.m_9236_(), living, vecDir.f_82479_ * 1.5, vecDir.f_82480_ * 1.5, vecDir.f_82481_ * 1.5, type);
        bullet.m_20256_(vecDir.m_82490_(2.0));
        bullet.bulletElectro = electro;
        return bullet;
    }

    public void setBullets(ItemStack revolver, NonNullList<ItemStack> bullets, boolean ignoreExtendedMag) {
        int i;
        IItemHandlerModifiable inv = (IItemHandlerModifiable)revolver.getCapability(ForgeCapabilities.ITEM_HANDLER, null).orElseThrow(RuntimeException::new);
        for (i = 0; i < 18; ++i) {
            inv.setStackInSlot(i, ItemStack.f_41583_);
        }
        if (ignoreExtendedMag && this.getUpgrades(revolver).m_128451_("bullets") > 0) {
            for (i = 0; i < bullets.size(); ++i) {
                inv.setStackInSlot(i < 2 ? i : i + this.getUpgrades(revolver).m_128451_("bullets"), (ItemStack)bullets.get(i));
            }
        } else {
            for (i = 0; i < bullets.size(); ++i) {
                inv.setStackInSlot(i, (ItemStack)bullets.get(i));
            }
        }
    }

    public void rotateCylinder(ItemStack revolver, Player player, boolean forward, NonNullList<ItemStack> bullets) {
        NonNullList cycled = NonNullList.m_122780_((int)this.getBulletCount(revolver), (Object)ItemStack.f_41583_);
        int offset = forward ? -1 : 1;
        for (int i = 0; i < cycled.size(); ++i) {
            cycled.set((i + offset + cycled.size()) % cycled.size(), (Object)((ItemStack)bullets.get(i)));
        }
        this.setBullets(revolver, (NonNullList<ItemStack>)cycled, false);
        player.m_150109_().m_6596_();
    }

    public void rotateCylinder(ItemStack revolver, Player player, boolean forward) {
        NonNullList<ItemStack> bullets = this.getBullets(revolver);
        this.rotateCylinder(revolver, player, forward, bullets);
    }

    public boolean isEmpty(ItemStack stack, boolean allowCasing) {
        LazyOptional invCap = stack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        return invCap.map(inv -> {
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack b = inv.getStackInSlot(i);
                boolean isValid = true;
                if (!allowCasing) {
                    isValid = b.m_41720_() instanceof BulletItem;
                }
                if (b.m_41619_() || !isValid) continue;
                return false;
            }
            return true;
        }).orElse(true);
    }

    @Override
    public CompoundTag getUpgradeBase(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "baseUpgrades");
    }

    public String getRevolverDisplayTag(ItemStack revolver) {
        String tag = ItemNBTHelper.getString(revolver, "elite");
        if (!tag.isEmpty()) {
            int split = tag.lastIndexOf("_");
            if (split < 0) {
                split = tag.length();
            }
            return tag.substring(0, split);
        }
        return "";
    }

    public static CompoundTag getPerks(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "perks");
    }

    public static boolean hasUpgradeValue(ItemStack stack, String key) {
        return RevolverItem.getUpgradesStatic(stack).m_128441_(key) || RevolverItem.getPerks(stack).m_128441_(key);
    }

    public static double getUpgradeValue_d(ItemStack stack, String key) {
        return RevolverItem.getUpgradesStatic(stack).m_128459_(key) + RevolverItem.getPerks(stack).m_128459_(key);
    }

    @Override
    public boolean canZoom(ItemStack stack, Player player) {
        return RevolverItem.hasUpgradeValue(stack, "scope");
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, Player player) {
        return this.zoomSteps;
    }

    public void m_7836_(ItemStack stack, @Nonnull Level world, @Nonnull Player player) {
        ArrayList list;
        if (stack.m_41619_() || player == null) {
            return;
        }
        String uuid = player.m_20148_().toString();
        if (specialRevolvers.containsKey((Object)uuid) && !(list = new ArrayList(specialRevolvers.get((Object)uuid))).isEmpty()) {
            list.add(null);
            String existingTag = ItemNBTHelper.getString(stack, "elite");
            if (existingTag.isEmpty()) {
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(0));
            } else {
                int i;
                for (i = 0; !(i >= list.size() || list.get(i) != null && existingTag.equals(((SpecialRevolver)list.get((int)i)).tag)); ++i) {
                }
                int next = (i + 1) % list.size();
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(next));
            }
        }
        this.recalculateUpgrades(stack, world, player);
    }

    public void applySpecialCrafting(ItemStack stack, SpecialRevolver r) {
        if (r == null) {
            ItemNBTHelper.remove(stack, "elite");
            ItemNBTHelper.remove(stack, "flavour");
            ItemNBTHelper.remove(stack, "baseUpgrades");
            return;
        }
        if (r.tag != null && !r.tag.isEmpty()) {
            ItemNBTHelper.putString(stack, "elite", r.tag);
        }
        if (r.flavour != null && !r.flavour.isEmpty()) {
            ItemNBTHelper.putString(stack, "flavour", r.flavour);
        }
        CompoundTag baseUpgrades = new CompoundTag();
        for (Map.Entry<String, Object> e : r.baseUpgrades.entrySet()) {
            if (e.getValue() instanceof Boolean) {
                baseUpgrades.m_128379_(e.getKey(), ((Boolean)e.getValue()).booleanValue());
                continue;
            }
            if (e.getValue() instanceof Integer) {
                baseUpgrades.m_128405_(e.getKey(), ((Integer)e.getValue()).intValue());
                continue;
            }
            if (e.getValue() instanceof Float) {
                baseUpgrades.m_128347_(e.getKey(), (double)((Float)e.getValue()).floatValue());
                continue;
            }
            if (e.getValue() instanceof Double) {
                baseUpgrades.m_128347_(e.getKey(), ((Double)e.getValue()).doubleValue());
                continue;
            }
            if (!(e.getValue() instanceof String)) continue;
            baseUpgrades.m_128359_(e.getKey(), (String)e.getValue());
        }
        ItemNBTHelper.setTagCompound(stack, "baseUpgrades", baseUpgrades);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        Optional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return wrapperNew.map(w -> ItemStack.m_41728_((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse(true);
        });
        if (!sameShader.orElse(true).booleanValue()) {
            return true;
        }
        if (ItemNBTHelper.hasKey(oldStack, "elite") || ItemNBTHelper.hasKey(newStack, "elite")) {
            return !ItemNBTHelper.getString(oldStack, "elite").equals(ItemNBTHelper.getString(newStack, "elite"));
        }
        return false;
    }

    @Override
    @Nullable
    protected IEMenuTypes.ItemContainerType<?> getContainerType() {
        return IEMenuTypes.REVOLVER;
    }

    @ParametersAreNonnullByDefault
    public static enum RevolverPerk {
        COOLDOWN(f -> f > 1.0, f -> Utils.NUMBERFORMAT_PREFIXED.format((1.0 - f) * 100.0), (l, r) -> l * r, 1.0, -0.75, -0.05),
        NOISE(f -> f > 1.0, f -> Utils.NUMBERFORMAT_PREFIXED.format((f - 1.0) * 100.0), (l, r) -> l * r, 1.0, -0.9, -0.1),
        LUCK(f -> f < 0.0, f -> Utils.NUMBERFORMAT_PREFIXED.format(f * 100.0), (l, r) -> l + r, 0.0, 3.0, 0.5);

        private final DoublePredicate isBadValue;
        private final Function<Double, String> valueFormatter;
        private final DoubleBinaryOperator valueConcat;
        private final double generate_median;
        private final double generate_deviation;
        private final double generate_luckScale;

        private RevolverPerk(DoublePredicate isBadValue, Function<Double, String> valueFormatter, DoubleBinaryOperator valueConcat, double generate_median, double generate_deviation, double generate_luckScale) {
            this.isBadValue = isBadValue;
            this.valueFormatter = valueFormatter;
            this.valueConcat = valueConcat;
            this.generate_median = generate_median;
            this.generate_deviation = generate_deviation;
            this.generate_luckScale = generate_luckScale;
        }

        public String getNBTKey() {
            return this.name().toLowerCase(Locale.US);
        }

        public Component getDisplayString(double value) {
            String key = "desc.immersiveengineering.info.revolver.perk." + this.toString();
            return Component.m_237110_((String)key, (Object[])new Object[]{this.valueFormatter.apply(value)}).m_130940_(this.isBadValue.test(value) ? ChatFormatting.RED : ChatFormatting.BLUE);
        }

        public static Component getFormattedName(Component name, CompoundTag perksTag) {
            double averageTier = 0.0;
            for (String key : perksTag.m_128431_()) {
                RevolverPerk perk = RevolverPerk.get(key);
                double value = perksTag.m_128459_(key);
                double dTier = (value - perk.generate_median) / perk.generate_deviation * 3.0;
                averageTier += dTier;
                int iTier = (int)Mth.m_14008_((double)(dTier < 0.0 ? Math.floor(dTier) : Math.ceil(dTier)), (double)-3.0, (double)3.0);
                if (iTier == 0) {
                    iTier = 1;
                }
                String translate = "desc.immersiveengineering.info.revolver.perk." + perk.name().toLowerCase(Locale.US) + ".tier" + iTier;
                name = Component.m_237110_((String)translate, (Object[])new Object[]{name});
            }
            int rarityTier = (int)Math.ceil(Mth.m_14008_((double)(averageTier + 3.0), (double)0.0, (double)6.0) / 6.0 * 5.0);
            Rarity rarity = rarityTier == 5 ? Lib.RARITY_MASTERWORK : (rarityTier == 4 ? Rarity.EPIC : (rarityTier == 3 ? Rarity.RARE : (rarityTier == 2 ? Rarity.UNCOMMON : Rarity.COMMON)));
            return name.m_6881_().m_130940_(rarity.f_43022_);
        }

        public static int calculateTier(CompoundTag perksTag) {
            double averageTier = 0.0;
            for (String key : perksTag.m_128431_()) {
                RevolverPerk perk = RevolverPerk.get(key);
                double value = perksTag.m_128459_(key);
                double dTier = (value - perk.generate_median) / perk.generate_deviation * 3.0;
                averageTier += dTier;
            }
            return (int)Math.ceil(Mth.m_14008_((double)(averageTier + 3.0), (double)0.0, (double)6.0) / 6.0 * 5.0);
        }

        public double concat(double left, double right) {
            return this.valueConcat.applyAsDouble(left, right);
        }

        public double generateValue(RandomSource rand, boolean isBad, float luck) {
            double d = Utils.generateLuckInfluencedDouble(this.generate_median, this.generate_deviation, luck, rand, isBad, this.generate_luckScale);
            int i = (int)(d * 100.0);
            d = (double)i / 100.0;
            return d;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }

        public static RevolverPerk get(String name) {
            try {
                return RevolverPerk.valueOf(name.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                return null;
            }
        }

        public static RevolverPerk getRandom(RandomSource rand) {
            int i = rand.m_188503_(RevolverPerk.values().length);
            return RevolverPerk.values()[i];
        }

        public static CompoundTag generatePerkSet(RandomSource rand, float luck) {
            RevolverPerk goodPerk = RevolverPerk.getRandom(rand);
            RevolverPerk badPerk = LUCK;
            double val = goodPerk.generateValue(rand, false, luck);
            CompoundTag perkCompound = new CompoundTag();
            if (goodPerk == badPerk) {
                val = (val + badPerk.generateValue(rand, true, luck)) / 2.0;
            } else {
                perkCompound.m_128347_(badPerk.getNBTKey(), badPerk.generateValue(rand, true, luck));
            }
            perkCompound.m_128347_(goodPerk.getNBTKey(), val);
            return perkCompound;
        }
    }

    public record SpecialRevolver(String[] uuid, String tag, String flavour, HashMap<String, Object> baseUpgrades, String[] renderAdditions) {
    }
}

