/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.network.MessageContainerData;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkDirection;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class IEContainerMenu
extends AbstractContainerMenu {
    private final List<GenericContainerData<?>> genericData = new ArrayList();
    private final List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();
    private final Runnable setChanged;
    private final Predicate<Player> isValid;
    public int ownSlotCount;

    protected IEContainerMenu(MenuContext ctx) {
        super(ctx.type, ctx.id);
        this.setChanged = ctx.setChanged;
        this.isValid = ctx.isValid;
    }

    public void addGenericData(GenericContainerData<?> newData) {
        this.genericData.add(newData);
    }

    public void m_38946_() {
        super.m_38946_();
        ArrayList toSync = new ArrayList();
        for (int i = 0; i < this.genericData.size(); ++i) {
            GenericContainerData<?> data = this.genericData.get(i);
            if (!data.needsUpdate()) continue;
            toSync.add(Pair.of((Object)i, data.dataPair()));
        }
        if (!toSync.isEmpty()) {
            for (ServerPlayer player : this.usingPlayers) {
                ImmersiveEngineering.packetHandler.sendTo((Object)new MessageContainerData(toSync), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    public void receiveSync(List<Pair<Integer, GenericDataSerializers.DataPair<?>>> synced) {
        for (Pair<Integer, GenericDataSerializers.DataPair<?>> syncElement : synced) {
            this.genericData.get((Integer)syncElement.getFirst()).processSync(((GenericDataSerializers.DataPair)syncElement.getSecond()).data());
        }
    }

    public void m_150399_(int id, int dragType, ClickType clickType, Player player) {
        Slot slot;
        Slot slot2 = slot = id < 0 ? null : (Slot)this.f_38839_.get(id);
        if (!(slot instanceof IESlot.ItemHandlerGhost)) {
            super.m_150399_(id, dragType, clickType, player);
            return;
        }
        ItemStack stackSlot = slot.m_7993_();
        if (dragType == 2) {
            slot.m_5852_(ItemStack.f_41583_);
        } else if (dragType == 0 || dragType == 1) {
            ItemStack stackHeld = this.m_142621_();
            int amount = Math.min(slot.m_6641_(), stackHeld.m_41613_());
            if (dragType == 1) {
                amount = 1;
            }
            if (stackSlot.m_41619_()) {
                if (!stackHeld.m_41619_() && slot.m_5857_(stackHeld)) {
                    slot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
                }
            } else if (stackHeld.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else if (slot.m_5857_(stackHeld)) {
                if (ItemStack.m_41656_((ItemStack)stackSlot, (ItemStack)stackHeld)) {
                    stackSlot.m_41769_(amount);
                } else {
                    slot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
                }
            }
            if (stackSlot.m_41613_() > slot.m_6641_()) {
                stackSlot.m_41764_(slot.m_6641_());
            }
        } else if (dragType == 5) {
            ItemStack stackHeld = this.m_142621_();
            int amount = Math.min(slot.m_6641_(), stackHeld.m_41613_());
            if (!slot.m_6657_()) {
                slot.m_5852_(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
            }
        }
    }

    @Nonnull
    public ItemStack m_7648_(Player player, int slot) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slotObject = (Slot)this.f_38839_.get(slot);
        if (slotObject != null && slotObject.m_6657_()) {
            ItemStack itemstack1 = slotObject.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (slot < this.ownSlotCount ? !this.m_38903_(itemstack1, this.ownSlotCount, this.f_38839_.size(), true) : !this.moveItemStackToWithMayPlace(itemstack1, 0, this.ownSlotCount)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slotObject.m_5852_(ItemStack.f_41583_);
            } else {
                slotObject.m_6654_();
            }
        }
        return itemstack;
    }

    protected boolean moveItemStackToWithMayPlace(ItemStack pStack, int pStartIndex, int pEndIndex) {
        return IEContainerMenu.moveItemStackToWithMayPlace((List<Slot>)this.f_38839_, (x$0, x$1, x$2, x$3) -> this.m_38903_(x$0, x$1, x$2, x$3), pStack, pStartIndex, pEndIndex);
    }

    public static boolean moveItemStackToWithMayPlace(List<Slot> slots, MoveItemsFunc move, ItemStack pStack, int pStartIndex, int pEndIndex) {
        boolean inAllowedRange = true;
        int allowedStart = pStartIndex;
        for (int i = pStartIndex; i < pEndIndex; ++i) {
            boolean mayplace = slots.get(i).m_5857_(pStack);
            if (inAllowedRange && !mayplace) {
                if (move.moveItemStackTo(pStack, allowedStart, i, false)) {
                    return true;
                }
                inAllowedRange = false;
                continue;
            }
            if (inAllowedRange || !mayplace) continue;
            allowedStart = i;
            inAllowedRange = true;
        }
        return inAllowedRange && move.moveItemStackTo(pStack, allowedStart, pEndIndex, false);
    }

    public void receiveMessageFromScreen(CompoundTag nbt) {
    }

    public void m_6877_(@Nonnull Player player) {
        super.m_6877_(player);
        this.setChanged.run();
    }

    public boolean m_6875_(@Nonnull Player pPlayer) {
        return this.isValid.test(pPlayer);
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open ev) {
        AbstractContainerMenu abstractContainerMenu = ev.getContainer();
        if (abstractContainerMenu instanceof IEContainerMenu) {
            IEContainerMenu ieContainer = (IEContainerMenu)abstractContainerMenu;
            abstractContainerMenu = ev.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                ieContainer.usingPlayers.add(serverPlayer);
                ArrayList list = new ArrayList();
                for (int i = 0; i < ieContainer.genericData.size(); ++i) {
                    list.add(Pair.of((Object)i, ieContainer.genericData.get(i).dataPair()));
                }
                ImmersiveEngineering.packetHandler.sendTo((Object)new MessageContainerData(list), serverPlayer.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        }
    }

    @SubscribeEvent
    public static void onContainerClosed(PlayerContainerEvent.Close ev) {
        AbstractContainerMenu abstractContainerMenu = ev.getContainer();
        if (abstractContainerMenu instanceof IEContainerMenu) {
            IEContainerMenu ieContainer = (IEContainerMenu)abstractContainerMenu;
            abstractContainerMenu = ev.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                ieContainer.usingPlayers.remove(serverPlayer);
            }
        }
    }

    public static MenuContext multiblockCtx(MenuType<?> pMenuType, int pContainerId, MultiblockMenuContext<?> ctx) {
        return new MenuContext(pMenuType, pContainerId, ctx.mbContext()::markMasterDirty, p -> {
            if (!ctx.mbContext().isValid().getAsBoolean()) {
                return false;
            }
            return p.m_20238_(Vec3.m_82512_((Vec3i)ctx.clickedPos)) <= 64.0;
        });
    }

    public static MenuContext blockCtx(MenuType<?> pMenuType, int pContainerId, BlockEntity be) {
        return new MenuContext(pMenuType, pContainerId, () -> {
            be.m_6596_();
            if (be instanceof IEBaseBlockEntity) {
                IEBaseBlockEntity ieBE = (IEBaseBlockEntity)be;
                ieBE.markContainingBlockForUpdate(null);
            }
        }, p -> {
            BlockPos pos = be.m_58899_();
            Level level = be.m_58904_();
            if (level == null || level.m_7702_(pos) != be) {
                return false;
            }
            return !(p.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) > 64.0);
        });
    }

    public static MenuContext itemCtx(MenuType<?> pMenuType, int pContainerId, Inventory playerInv, EquipmentSlot slot, ItemStack stack) {
        return new MenuContext(pMenuType, pContainerId, () -> {}, p -> {
            if (p != playerInv.f_35978_) {
                return false;
            }
            return ItemStack.m_41656_((ItemStack)p.m_6844_(slot), (ItemStack)stack);
        });
    }

    public static MenuContext clientCtx(MenuType<?> pMenuType, int pContainerId) {
        return new MenuContext(pMenuType, pContainerId, () -> {}, $ -> true);
    }

    protected record MenuContext(MenuType<?> type, int id, Runnable setChanged, Predicate<Player> isValid) {
    }

    public static interface MoveItemsFunc {
        public boolean moveItemStackTo(ItemStack var1, int var2, int var3, boolean var4);
    }

    public record MultiblockMenuContext<S extends IMultiblockState>(IMultiblockContext<S> mbContext, BlockPos clickedPos) {
    }
}

