/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.api.crafting.ClocheRenderFunction;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;

public class ClocheRecipeSerializer
extends IERecipeSerializer<ClocheRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(IEBlocks.MetalDevices.CLOCHE);
    }

    @Override
    public ClocheRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        JsonArray results = json.getAsJsonArray("results");
        ArrayList<Lazy<ItemStack>> outputs = new ArrayList<Lazy<ItemStack>>(results.size());
        for (int i = 0; i < results.size(); ++i) {
            outputs.add(ClocheRecipeSerializer.readOutput(results.get(i)));
        }
        Ingredient seed = Ingredient.m_43917_((JsonElement)json.get("input"));
        Ingredient soil = Ingredient.m_43917_((JsonElement)json.get("soil"));
        int time = GsonHelper.m_13927_((JsonObject)json, (String)"time");
        ClocheRenderFunction.ClocheRenderReference renderReference = ClocheRenderFunction.ClocheRenderReference.deserialize(GsonHelper.m_13930_((JsonObject)json, (String)"render"));
        return new ClocheRecipe(recipeId, outputs, seed, soil, time, renderReference);
    }

    @Nullable
    public ClocheRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int outputCount = buffer.readInt();
        ArrayList<Lazy<ItemStack>> outputs = new ArrayList<Lazy<ItemStack>>(outputCount);
        for (int i = 0; i < outputCount; ++i) {
            outputs.add(ClocheRecipeSerializer.readLazyStack(buffer));
        }
        Ingredient seed = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        Ingredient soil = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        int time = buffer.readInt();
        ClocheRenderFunction.ClocheRenderReference renderReference = ClocheRenderFunction.ClocheRenderReference.read(buffer);
        return new ClocheRecipe(recipeId, outputs, seed, soil, time, renderReference);
    }

    public void toNetwork(FriendlyByteBuf buffer, ClocheRecipe recipe) {
        buffer.writeInt(recipe.outputs.size());
        for (Lazy<ItemStack> stack : recipe.outputs) {
            buffer.m_130055_((ItemStack)stack.get());
        }
        recipe.seed.m_43923_(buffer);
        recipe.soil.m_43923_(buffer);
        buffer.writeInt(recipe.time);
        recipe.renderReference.write(buffer);
    }
}

