/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.process;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public class MultiblockProcessInMachine<R extends MultiblockRecipe>
extends MultiblockProcess<R, ProcessContext.ProcessContextInMachine<R>> {
    protected final int[] inputSlots;
    protected int[] inputAmounts = null;
    protected int[] inputTanks = new int[0];

    public MultiblockProcessInMachine(ResourceLocation recipeId, BiFunction<Level, ResourceLocation, R> getRecipe, int ... inputSlots) {
        super(recipeId, getRecipe);
        this.inputSlots = inputSlots;
    }

    public MultiblockProcessInMachine(R recipe, int ... inputSlots) {
        super(recipe);
        this.inputSlots = inputSlots;
    }

    public MultiblockProcessInMachine(BiFunction<Level, ResourceLocation, R> getRecipe, CompoundTag data) {
        super(getRecipe, data);
        this.inputSlots = data.m_128465_("process_inputSlots");
        this.setInputAmounts(data.m_128465_("process_inputAmounts"));
        this.setInputTanks(data.m_128465_("process_inputTanks"));
    }

    public MultiblockProcessInMachine<R> setInputTanks(int ... inputTanks) {
        this.inputTanks = inputTanks;
        return this;
    }

    public MultiblockProcessInMachine<R> setInputAmounts(int ... inputAmounts) {
        this.inputAmounts = inputAmounts;
        return this;
    }

    public int[] getInputSlots() {
        return this.inputSlots;
    }

    @Nullable
    public int[] getInputAmounts() {
        return this.inputAmounts;
    }

    public int[] getInputTanks() {
        return this.inputTanks;
    }

    protected List<IngredientWithSize> getRecipeItemInputs(ProcessContext.ProcessContextInMachine<R> context, Level level) {
        Object recipe = this.getLevelData(level).recipe();
        return recipe == null ? List.of() : ((MultiblockRecipe)recipe).getItemInputs();
    }

    protected List<FluidTagInput> getRecipeFluidInputs(ProcessContext.ProcessContextInMachine<R> context, Level level) {
        Object recipe = this.getLevelData(level).recipe();
        return recipe == null ? List.of() : ((MultiblockRecipe)recipe).getFluidInputs();
    }

    @Override
    protected boolean canOutputItem(ProcessContext.ProcessContextInMachine<R> context, ItemStack output) {
        int[] outputSlots;
        for (int iOutputSlot : outputSlots = context.getOutputSlots()) {
            IItemHandlerModifiable inv = context.getInventory();
            ItemStack s = inv.getStackInSlot(iOutputSlot);
            if (s.m_41619_()) {
                return true;
            }
            boolean match = ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)output);
            if (!match || s.m_41613_() + output.m_41613_() > inv.getSlotLimit(iOutputSlot)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canOutputFluid(ProcessContext.ProcessContextInMachine<R> context, FluidStack output) {
        int[] outputTanks;
        IFluidTank[] tanks = context.getInternalTanks();
        for (int iOutputTank : outputTanks = context.getOutputTanks()) {
            if (tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void outputFluid(ProcessContext.ProcessContextInMachine<R> context, FluidStack output) {
        int[] outputTanks;
        IFluidTank[] tanks = context.getInternalTanks();
        for (int iOutputTank : outputTanks = context.getOutputTanks()) {
            if (tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.SIMULATE) != output.getAmount()) continue;
            tanks[iOutputTank].fill(output, IFluidHandler.FluidAction.EXECUTE);
            break;
        }
    }

    @Override
    protected void outputItem(ProcessContext.ProcessContextInMachine<R> context, ItemStack output, IMultiblockLevel level) {
        int[] outputSlots;
        for (int iOutputSlot : outputSlots = context.getOutputSlots()) {
            IItemHandlerModifiable inv = context.getInventory();
            ItemStack s = inv.getStackInSlot(iOutputSlot);
            if (s.m_41619_()) {
                inv.setStackInSlot(iOutputSlot, output.m_41777_());
                break;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)output) || s.m_41613_() + output.m_41613_() > inv.getSlotLimit(iOutputSlot)) continue;
            s.m_41769_(output.m_41613_());
            break;
        }
    }

    @Override
    public void doProcessTick(ProcessContext.ProcessContextInMachine<R> context, IMultiblockLevel level) {
        Object recipe = this.getLevelData(level.getRawLevel()).recipe();
        if (recipe == null) {
            return;
        }
        IItemHandlerModifiable inv = context.getInventory();
        if (recipe.shouldCheckItemAvailability() && ((MultiblockRecipe)recipe).getItemInputs() != null && inv != null) {
            NonNullList query = NonNullList.m_122780_((int)this.inputSlots.length, (Object)ItemStack.f_41583_);
            for (int i = 0; i < this.inputSlots.length; ++i) {
                if (this.inputSlots[i] < 0 || this.inputSlots[i] >= inv.getSlots()) continue;
                query.set(i, (Object)context.getInventory().getStackInSlot(this.inputSlots[i]));
            }
            if (!IngredientUtils.stacksMatchIngredientWithSizeList(((MultiblockRecipe)recipe).getItemInputs(), (NonNullList<ItemStack>)query)) {
                this.clearProcess = true;
                return;
            }
        }
        super.doProcessTick(context, level);
    }

    @Override
    protected void processFinish(ProcessContext.ProcessContextInMachine<R> context, IMultiblockLevel level) {
        super.processFinish(context, level);
        IItemHandlerModifiable inv = context.getInventory();
        List<IngredientWithSize> itemInputList = this.getRecipeItemInputs(context, level.getRawLevel());
        if (inv != null && this.inputSlots != null && itemInputList != null) {
            if (this.inputAmounts != null && this.inputSlots.length == this.inputAmounts.length) {
                for (int i = 0; i < this.inputSlots.length; ++i) {
                    if (this.inputAmounts[i] <= 0) continue;
                    inv.getStackInSlot(this.inputSlots[i]).m_41774_(this.inputAmounts[i]);
                }
            } else {
                block1: for (IngredientWithSize ingr : new ArrayList<IngredientWithSize>(itemInputList)) {
                    int ingrSize = ingr.getCount();
                    for (int slot : this.inputSlots) {
                        if (inv.getStackInSlot(slot).m_41619_() || !ingr.test(inv.getStackInSlot(slot))) continue;
                        int taken = Math.min(inv.getStackInSlot(slot).m_41613_(), ingrSize);
                        inv.getStackInSlot(slot).m_41774_(taken);
                        if (inv.getStackInSlot(slot).m_41613_() <= 0) {
                            inv.setStackInSlot(slot, ItemStack.f_41583_);
                        }
                        if ((ingrSize -= taken) <= 0) continue block1;
                    }
                }
            }
        }
        IFluidTank[] tanks = context.getInternalTanks();
        List<FluidTagInput> fluidInputList = this.getRecipeFluidInputs(context, level.getRawLevel());
        if (tanks != null && this.inputTanks != null && fluidInputList != null) {
            block3: for (FluidTagInput ingr : new ArrayList<FluidTagInput>(fluidInputList)) {
                int ingrSize = ingr.getAmount();
                for (int tank : this.inputTanks) {
                    if (tanks[tank] == null || !ingr.testIgnoringAmount(tanks[tank].getFluid())) continue;
                    int taken = Math.min(tanks[tank].getFluidAmount(), ingrSize);
                    tanks[tank].drain(taken, IFluidHandler.FluidAction.EXECUTE);
                    if ((ingrSize -= taken) <= 0) continue block3;
                }
            }
        }
    }

    @Override
    public void writeExtraDataToNBT(CompoundTag nbt) {
        if (this.inputSlots != null) {
            nbt.m_128385_("process_inputSlots", this.inputSlots);
        }
        if (this.inputAmounts != null) {
            nbt.m_128385_("process_inputAmounts", this.inputAmounts);
        }
        if (this.inputTanks != null) {
            nbt.m_128385_("process_inputTanks", this.inputTanks);
        }
    }
}

