/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MetalLadderBlock
extends LadderBlock {
    private static final Map<Direction, VoxelShape> FRAMES = new EnumMap<Direction, VoxelShape>(Direction.class);
    private final CoverType type;

    private static VoxelShape merge(VoxelShape a, AABB b) {
        return Shapes.m_83148_((VoxelShape)a, (VoxelShape)Shapes.m_83064_((AABB)b), (BooleanOp)BooleanOp.f_82695_);
    }

    public MetalLadderBlock(CoverType type, BlockBehaviour.Properties props) {
        super(props);
        this.type = type;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        VoxelShape base = super.m_5940_(state, world, pos, ctx);
        if (this.type == CoverType.NONE) {
            return base;
        }
        Direction ladderSide = (Direction)state.m_61143_((Property)LadderBlock.f_54337_);
        return Shapes.m_83148_((VoxelShape)base, (VoxelShape)FRAMES.get(ladderSide), (BooleanOp)BooleanOp.f_82695_);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState baseState = super.m_5573_(ctx);
        if (this.type == CoverType.NONE || baseState == null) {
            return baseState;
        }
        return (BlockState)baseState.m_61124_((Property)LadderBlock.f_54337_, (Comparable)Direction.m_122364_((double)ctx.m_7074_()).m_122424_());
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        if (this.type == CoverType.NONE) {
            return super.m_7898_(state, world, pos);
        }
        return true;
    }

    static {
        for (Direction dir : DirectionUtils.BY_HORIZONTAL_INDEX) {
            VoxelShape forDir = Shapes.m_83040_();
            if (dir != Direction.NORTH) {
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0));
            }
            if (dir != Direction.EAST) {
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0));
            }
            if (dir != Direction.SOUTH) {
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625));
            }
            if (dir != Direction.WEST) {
                forDir = MetalLadderBlock.merge(forDir, new AABB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0));
            }
            FRAMES.put(dir, forDir);
        }
    }

    public static enum CoverType {
        NONE,
        ALU,
        STEEL;

    }
}

