/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.client.IModelOffsetProvider;
import blusunrize.immersiveengineering.api.utils.shapes.CachedVoxelShapes;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.doubles.DoubleListIterator;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EnergyMeterBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IHasDummyBlocks,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IComparatorOverride,
EnergyTransferHandler.EnergyConnector,
IEBlockInterfaces.IBlockBounds,
IModelOffsetProvider {
    public final DoubleList lastPackets = new DoubleArrayList(20);
    private int nextPacketIndex = 0;
    private int compVal = -1;
    private Connection shuntConnection;
    private static final CachedVoxelShapes<Boolean> SHAPES = new CachedVoxelShapes<Boolean>(EnergyMeterBlockEntity::getShape);

    public EnergyMeterBlockEntity(BlockEntityType<EnergyMeterBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean interact(Direction side, Player player, InteractionHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        BlockEntity below;
        if (!heldItem.m_41619_() && heldItem.m_41720_() instanceof IWireCoil) {
            return false;
        }
        int transfer = this.getAveragePower();
        int packets = this.lastPackets.size();
        if (this.isDummy() && (below = this.f_58857_.m_7702_(this.m_58899_().m_7495_())) instanceof EnergyMeterBlockEntity) {
            packets = ((EnergyMeterBlockEntity)below).lastPackets.size();
        }
        String transferred = "0";
        if (transfer > 0) {
            transferred = Utils.formatDouble(transfer, "0.###");
        }
        ChatUtils.sendServerNoSpamMessages(player, (Component)Component.m_237110_((String)"chat.immersiveengineering.info.energyTransfered", (Object[])new Object[]{packets, transferred}));
        return true;
    }

    @Override
    public void tickServer() {
        if ((this.f_58857_.m_46467_() & 0x1FL) == (this.f_58858_.m_121878_() & 0x1FL) || this.compVal < 0) {
            this.updateComparatorValues();
        }
        EnergyTransferHandler handler = this.globalNet.getLocalNet(this.f_58858_).getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class);
        double transferred = 0.0;
        if (handler != null) {
            Object2DoubleMap<Connection> map = handler.getTransferredLastTick();
            transferred = map.getDouble((Object)this.shuntConnection);
        }
        if (this.nextPacketIndex >= this.lastPackets.size()) {
            this.lastPackets.add(transferred);
        } else {
            this.lastPackets.set(this.nextPacketIndex, transferred);
        }
        this.nextPacketIndex = (this.nextPacketIndex + 1) % 20;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        BlockEntity below;
        if (this.isDummy() && (below = this.f_58857_.m_7702_(this.m_58899_().m_7495_())) instanceof EnergyMeterBlockEntity) {
            return ((EnergyMeterBlockEntity)below).canConnectCable(cableType, target, offset);
        }
        if (!(cableType instanceof EnergyTransferHandler.IEnergyWire)) {
            return false;
        }
        for (ConnectionPoint cp : this.getConnectionPoints()) {
            for (Connection c : this.globalNet.getLocalNet(this.f_58858_).getConnections(cp)) {
                if (c.isInternal() || !target.equals(cp) && c.type.getCategory().equals(cableType.getCategory())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<BlockPos> getIgnored(IImmersiveConnectable other) {
        if (this.isDummy()) {
            return ImmutableSet.of((Object)this.f_58858_, (Object)this.f_58858_.m_7495_());
        }
        return ImmutableSet.of((Object)this.f_58858_, (Object)this.f_58858_.m_7494_());
    }

    @Override
    @Nullable
    public ConnectionPoint getTargetedPoint(TargetingInfo info, Vec3i offset) {
        ConnectionPoint targetByHit;
        if (this.getFacing().m_122434_() == Direction.Axis.X) {
            targetByHit = (double)info.hitZ > 0.5 ? new ConnectionPoint(this.f_58858_, 0) : new ConnectionPoint(this.f_58858_, 1);
        } else {
            ConnectionPoint connectionPoint = targetByHit = (double)info.hitX > 0.5 ? new ConnectionPoint(this.f_58858_, 0) : new ConnectionPoint(this.f_58858_, 1);
        }
        if (!this.globalNet.getLocalNet(targetByHit).getConnections(targetByHit).stream().allMatch(Connection::isInternal)) {
            return new ConnectionPoint(this.f_58858_, 1 - targetByHit.index());
        }
        return targetByHit;
    }

    @Override
    public void connectCable(WireType cableType, ConnectionPoint target, IImmersiveConnectable other, ConnectionPoint otherTarget) {
        if (this.isDummy()) {
            BlockEntity below = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
            if (below instanceof EnergyMeterBlockEntity) {
                ((EnergyMeterBlockEntity)below).connectCable(cableType, target, other, otherTarget);
            }
        } else {
            super.connectCable(cableType, target, other, otherTarget);
        }
    }

    @Override
    public BlockPos getConnectionMaster(WireType cableType, TargetingInfo target) {
        if (this.isDummy()) {
            return this.f_58858_.m_7495_();
        }
        return this.f_58858_;
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        if (this.getFacing().m_122434_() == Direction.Axis.X) {
            return new Vec3(0.5, 1.4375, here.index() == 0 ? 0.8125 : 0.1875);
        }
        return new Vec3(here.index() == 0 ? 0.8125 : 0.1875, 1.4375, 0.5);
    }

    @Override
    @Nullable
    public IEBlockInterfaces.IGeneralMultiblock master() {
        if (!this.isDummy()) {
            return this;
        }
        BlockPos masterPos = this.m_58899_().m_7495_();
        BlockEntity te = Utils.getExistingTileEntity(this.f_58857_, masterPos);
        return this.getClass().isInstance(te) ? (IEBlockInterfaces.IGeneralMultiblock)te : null;
    }

    @Override
    public void placeDummies(BlockPlaceContext ctx, BlockState state) {
        BlockPos dummyPos = this.f_58858_.m_7494_();
        this.f_58857_.m_46597_(dummyPos, IEBaseBlock.applyLocationalWaterlogging((BlockState)state.m_61124_((Property)IEProperties.MULTIBLOCKSLAVE, (Comparable)Boolean.valueOf(true)), this.f_58857_, dummyPos));
        ((EnergyMeterBlockEntity)this.f_58857_.m_7702_(dummyPos)).setFacing(this.getFacing());
    }

    @Override
    public void breakDummies(BlockPos pos, BlockState state) {
        if (this.isDummy()) {
            this.f_58857_.m_7471_(pos.m_7495_(), false);
        } else {
            this.f_58857_.m_7471_(pos.m_7494_(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAveragePower() {
        EnergyMeterBlockEntity te = this;
        if (te.isDummy()) {
            BlockEntity below = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
            if (!(below instanceof EnergyMeterBlockEntity)) {
                return -1;
            }
            te = (EnergyMeterBlockEntity)below;
        }
        if (te.lastPackets.size() == 0) {
            return 0;
        }
        double sum = 0.0;
        DoubleList doubleList = te.lastPackets;
        synchronized (doubleList) {
            DoubleListIterator doubleListIterator = te.lastPackets.iterator();
            while (doubleListIterator.hasNext()) {
                double transfer = (Double)doubleListIterator.next();
                sum += transfer;
            }
        }
        return (int)Math.round(sum / (double)te.lastPackets.size());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return SHAPES.get(this.isDummy());
    }

    private static List<AABB> getShape(Boolean isDummy) {
        ArrayList list = Lists.newArrayList((Object[])new AABB[]{new AABB(0.1875, -0.625, 0.1875, 0.8125, 0.8125, 0.8125), new AABB(0.0, -1.0, 0.0, 1.0, -0.625, 1.0)});
        if (!isDummy.booleanValue()) {
            for (int i = 0; i < list.size(); ++i) {
                list.set(i, ((AABB)list.get(i)).m_82386_(0.0, 1.0, 0.0));
            }
        }
        return list;
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return IEProperties.FACING_HORIZONTAL;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.HORIZONTAL;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    private void updateComparatorValues() {
        int oldVal = this.compVal;
        int maxTrans = Integer.MAX_VALUE;
        for (ConnectionPoint cp : this.getConnectionPoints()) {
            int maxTransForPoint = 0;
            Collection<Connection> conns = this.globalNet.getLocalNet(cp).getConnections(this.f_58858_);
            for (Connection c : conns) {
                if (c.isInternal() || !(c.type instanceof EnergyTransferHandler.IEnergyWire)) continue;
                maxTransForPoint += ((EnergyTransferHandler.IEnergyWire)((Object)c.type)).getTransferRate();
            }
            maxTrans = Math.min(maxTrans, maxTransForPoint);
        }
        if (maxTrans == 0) {
            this.compVal = 0;
        } else {
            double val = (double)this.getAveragePower() / (double)maxTrans;
            this.compVal = (int)Math.ceil(15.0 * val);
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
            if (te instanceof EnergyMeterBlockEntity) {
                ((EnergyMeterBlockEntity)te).compVal = this.compVal;
            }
        }
        if (oldVal != this.compVal) {
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_46717_(this.f_58858_.m_7495_(), this.m_58900_().m_60734_());
        }
    }

    @Override
    public int getComparatorInputOverride() {
        return this.compVal;
    }

    @Override
    public boolean isSource(ConnectionPoint cp) {
        return false;
    }

    @Override
    public boolean isSink(ConnectionPoint cp) {
        return false;
    }

    @Override
    public void onLoad() {
        this.shuntConnection = new Connection(this.f_58858_, 0, 1);
        super.onLoad();
    }

    @Override
    public Iterable<? extends Connection> getInternalConnections() {
        if (this.shuntConnection != null) {
            return ImmutableList.of((Object)this.shuntConnection);
        }
        return ImmutableList.of();
    }

    @Override
    public Collection<ConnectionPoint> getConnectionPoints() {
        return ImmutableList.of((Object)new ConnectionPoint(this.f_58858_, 0), (Object)new ConnectionPoint(this.f_58858_, 1));
    }

    @Override
    public BlockPos getModelOffset(BlockState state, @Nullable Vec3i size) {
        if (this.isDummy()) {
            return BlockPos.f_121853_;
        }
        return new BlockPos(0, -1, 0);
    }
}

