/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.tool.assembler.AssemblerHandler;
import blusunrize.immersiveengineering.api.tool.assembler.RecipeQuery;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;

public class CrafterPatternInventory {
    private static final int NUM_SLOTS = 10;
    public final NonNullList<ItemStack> inv = NonNullList.m_122780_((int)10, (Object)ItemStack.f_41583_);
    public Recipe<CraftingContainer> recipe;

    public void recalculateOutput(@Nullable Level level) {
        if (level == null) {
            return;
        }
        CraftingContainer invC = Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, this.inv);
        this.recipe = Utils.findCraftingRecipe(invC, level).orElse(null);
        this.inv.set(9, (Object)(this.recipe != null ? this.recipe.m_5874_((Container)invC, level.m_9598_()) : ItemStack.f_41583_));
    }

    public ListTag writeToNBT() {
        ListTag list = new ListTag();
        for (int i = 0; i < this.inv.size(); ++i) {
            if (((ItemStack)this.inv.get(i)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)i);
            ((ItemStack)this.inv.get(i)).m_41739_(itemTag);
            list.add((Object)itemTag);
        }
        return list;
    }

    public void readFromNBT(ListTag list) {
        Collections.fill(this.inv, ItemStack.f_41583_);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag itemTag = list.m_128728_(i);
            int slot = itemTag.m_128445_("Slot") & 0xFF;
            if (slot >= 10) continue;
            this.inv.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTag));
        }
    }

    @Nullable
    public List<RecipeQuery> getQueries(Level level) {
        if (this.recipe == null) {
            this.recalculateOutput(level);
        }
        if (this.recipe == null) {
            return null;
        }
        return CrafterPatternInventory.getQueriesGeneric(this.recipe, this.inv, level);
    }

    @Nullable
    private static <R extends Recipe<CraftingContainer>> List<RecipeQuery> getQueriesGeneric(R recipe, NonNullList<ItemStack> inv, Level level) {
        AssemblerHandler.IRecipeAdapter<R> adapter = AssemblerHandler.findAdapter(recipe);
        return adapter.getQueriedInputs(recipe, inv, level);
    }
}

