/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils.shapes;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapeUtils {
    public static AABB transformAABB(AABB original, Direction facing) {
        Vec3 minOld = new Vec3(original.f_82288_ - 0.5, original.f_82289_ - 0.5, original.f_82290_ - 0.5);
        Vec3 maxOld = new Vec3(original.f_82291_ - 0.5, original.f_82292_ - 0.5, original.f_82293_ - 0.5);
        Vec3 firstNew = ShapeUtils.rotate(minOld, facing);
        Vec3 secondNew = ShapeUtils.rotate(maxOld, facing);
        return new AABB(firstNew.f_82479_ + 0.5, firstNew.f_82480_ + 0.5, firstNew.f_82481_ + 0.5, secondNew.f_82479_ + 0.5, secondNew.f_82480_ + 0.5, secondNew.f_82481_ + 0.5);
    }

    public static Vec3 rotate(Vec3 in, Direction to) {
        return switch (to) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> in;
            case Direction.SOUTH -> new Vec3(-in.m_7096_(), in.m_7098_(), -in.m_7094_());
            case Direction.EAST -> new Vec3(-in.m_7094_(), in.m_7098_(), in.m_7096_());
            case Direction.WEST -> new Vec3(in.m_7094_(), in.m_7098_(), -in.m_7096_());
            case Direction.DOWN, Direction.UP -> throw new RuntimeException("Unexpected direction: " + to);
        };
    }

    public static VoxelShape join(List<AABB> boxes) {
        VoxelShape ret = Shapes.m_83040_();
        for (AABB aabb : boxes) {
            ret = Shapes.m_83148_((VoxelShape)ret, (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82695_);
        }
        return ret.m_83296_();
    }
}

