/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool.conveyor;

import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorBelt;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.utils.SetRestrictedField;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import org.apache.commons.lang3.mutable.MutableLong;

public class ConveyorHandler {
    private static final Map<ResourceLocation, IConveyorType<?>> typeRegistry = new LinkedHashMap();
    private static final Set<BiConsumer<Entity, IConveyorBlockEntity<?>>> magnetSuppressionFunctions = new HashSet();
    private static final Set<BiConsumer<Entity, IConveyorBlockEntity<?>>> magnetSuppressionReverse = new HashSet();
    public static final SetRestrictedField<ItemAgeAccessor> ITEM_AGE_ACCESS = SetRestrictedField.common();
    public static final SetRestrictedField<Function<IConveyorType<?>, Block>> CONVEYOR_BLOCKS = SetRestrictedField.common();
    public static final SetRestrictedField<Function<IConveyorType<?>, BlockEntityType<?>>> BLOCK_ENTITY_TYPES = SetRestrictedField.common();
    public static final ResourceLocation textureConveyorColour = new ResourceLocation("immersiveengineering:block/conveyor/colour");
    private static final IntSet entitiesHandledInCurrentTickClient = new IntOpenHashSet();
    private static final MutableLong currentTickClient = new MutableLong();
    private static final IntSet entitiesHandledInCurrentTickServer = new IntOpenHashSet();
    private static final MutableLong currentTickServer = new MutableLong();

    public static boolean markEntityAsHandled(Entity e) {
        IntSet entitiesHandledInCurrentTick;
        MutableLong currentTick;
        if (e.m_9236_().f_46443_) {
            currentTick = currentTickClient;
            entitiesHandledInCurrentTick = entitiesHandledInCurrentTickClient;
        } else {
            currentTick = currentTickServer;
            entitiesHandledInCurrentTick = entitiesHandledInCurrentTickServer;
        }
        long now = e.m_9236_().m_46467_();
        if (now != currentTick.getValue()) {
            currentTick.setValue(now);
            entitiesHandledInCurrentTick.clear();
        }
        return entitiesHandledInCurrentTick.add(e.m_19879_());
    }

    public static boolean registerConveyorType(IConveyorType<?> type) {
        ResourceLocation key = type.getId();
        if (typeRegistry.containsKey(key)) {
            return false;
        }
        typeRegistry.put(key, type);
        return true;
    }

    public static <T extends IConveyorBelt> T getConveyor(IConveyorType<T> type, @Nonnull BlockEntity tile) {
        IConveyorBlockEntity convBE;
        Object fromTile;
        if (tile instanceof IConveyorBlockEntity && (fromTile = (convBE = (IConveyorBlockEntity)tile).getConveyorInstance()) != null) {
            return fromTile;
        }
        return type.makeInstance(tile);
    }

    public static IConveyorType<?> getConveyorType(ResourceLocation key) {
        return typeRegistry.get(key);
    }

    public static Collection<IConveyorType<?>> getConveyorTypes() {
        return typeRegistry.values();
    }

    public static BlockEntityType<? extends BlockEntity> getBEType(IConveyorType<?> type) {
        return BLOCK_ENTITY_TYPES.getValue().apply(type);
    }

    public static ResourceLocation getRegistryNameFor(ResourceLocation conveyorLoc) {
        Object path = "immersiveengineering".equals(conveyorLoc.m_135827_()) ? conveyorLoc.m_135815_() : conveyorLoc.m_135827_() + "_" + conveyorLoc.m_135815_();
        return new ResourceLocation("immersiveengineering", "conveyor_" + (String)path);
    }

    public static IConveyorType<?> getType(Block b) {
        if (b instanceof IConveyorBlock) {
            IConveyorBlock conveyorBlock = (IConveyorBlock)b;
            return conveyorBlock.getType();
        }
        return null;
    }

    public static Block getBlock(IConveyorType<?> type) {
        return CONVEYOR_BLOCKS.getValue().apply(type);
    }

    public static boolean isConveyorBlock(Block b) {
        for (IConveyorType<?> type : typeRegistry.values()) {
            if (b != ConveyorHandler.getBlock(type)) continue;
            return true;
        }
        return false;
    }

    public static void registerMagnetSuppression(BiConsumer<Entity, IConveyorBlockEntity<?>> function, @Nullable BiConsumer<Entity, IConveyorBlockEntity<?>> revert) {
        magnetSuppressionFunctions.add(function);
        if (revert != null) {
            magnetSuppressionReverse.add(revert);
        }
    }

    public static void applyMagnetSuppression(Entity entity, IConveyorBlockEntity<?> tile) {
        if (entity != null) {
            for (BiConsumer<Entity, IConveyorBlockEntity<?>> func : magnetSuppressionFunctions) {
                func.accept(entity, tile);
            }
        }
    }

    public static void revertMagnetSuppression(Entity entity, IConveyorBlockEntity<?> tile) {
        if (entity != null) {
            for (BiConsumer<Entity, IConveyorBlockEntity<?>> func : magnetSuppressionReverse) {
                func.accept(entity, tile);
            }
        }
    }

    public static boolean connectsToConveyor(Level level, BlockPos pos, Direction side) {
        BlockEntity te = SafeChunkUtils.getSafeBE((LevelAccessor)level, pos);
        if (te instanceof IConveyorAttachable) {
            boolean b = false;
            for (Direction f : ((IConveyorAttachable)te).sigOutputDirections()) {
                if (f == side.m_122424_()) {
                    b = true;
                    continue;
                }
                if (f != Direction.UP) continue;
                b = false;
            }
            return !b;
        }
        te = SafeChunkUtils.getSafeBE((LevelAccessor)level, pos.m_7918_(0, -1, 0));
        if (te instanceof IConveyorAttachable) {
            int b = 0;
            for (Direction f : ((IConveyorAttachable)te).sigOutputDirections()) {
                if (f == side.m_122424_()) {
                    ++b;
                    continue;
                }
                if (f != Direction.UP) continue;
                ++b;
            }
            return b < 2;
        }
        return true;
    }

    public static interface IConveyorBlockEntity<T extends IConveyorBelt>
    extends IConveyorAttachable {
        public T getConveyorInstance();

        @Override
        default public Direction[] sigOutputDirections() {
            T subtype = this.getConveyorInstance();
            if (subtype != null) {
                return subtype.sigTransportDirections();
            }
            return new Direction[0];
        }
    }

    public static interface IConveyorBlock {
        public IConveyorType<?> getType();
    }

    public static interface IConveyorAttachable {
        public Direction getFacing();

        public Direction[] sigOutputDirections();
    }

    public static interface ItemAgeAccessor {
        public void setAge(ItemEntity var1, int var2);
    }

    public static enum ConveyorDirection {
        HORIZONTAL,
        UP,
        DOWN;

    }
}

