/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.multiblocks;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.Event;

public class BlockMatcher {
    private static final List<MatcherPredicate> GLOBAL_MATCHERS = new ArrayList<MatcherPredicate>();
    private static final List<Preprocessor> PREPROCESSING = new ArrayList<Preprocessor>();

    public static void addPredicate(MatcherPredicate newPredicate) {
        GLOBAL_MATCHERS.add(newPredicate);
    }

    public static void addPreprocessor(Preprocessor preprocessor) {
        PREPROCESSING.add(preprocessor);
    }

    public static Result matches(BlockState expected, BlockState found, Level world, BlockPos pos) {
        return BlockMatcher.matches(expected, found, world, pos, (List<MatcherPredicate>)ImmutableList.of());
    }

    public static Result matches(BlockState expected, BlockState found, Level world, BlockPos pos, List<MatcherPredicate> additional) {
        for (Preprocessor p : PREPROCESSING) {
            found = p.preprocessFoundState(expected, found, world, pos);
        }
        BlockState finalFound = found;
        return Stream.concat(GLOBAL_MATCHERS.stream(), additional.stream()).map(pred -> pred.matches(expected, finalFound, world, pos)).reduce(Result.DEFAULT, Result::combine);
    }

    public static class Result {
        final int strength;
        final Event.Result type;
        public static final Result DEFAULT = new Result(0, Event.Result.DEFAULT);

        private Result(int strength, Event.Result type) {
            this.strength = strength;
            this.type = type;
        }

        public boolean isAllow() {
            return this.type == Event.Result.ALLOW;
        }

        public boolean isDefault() {
            return this.type == Event.Result.DEFAULT;
        }

        public boolean isDeny() {
            return this.type == Event.Result.DENY;
        }

        public static Result combine(Result a, Result b) {
            if (Math.abs(a.strength) > Math.abs(b.strength)) {
                return a;
            }
            if (Math.abs(a.strength) < Math.abs(b.strength)) {
                return b;
            }
            Preconditions.checkState((a.type == b.type ? 1 : 0) != 0, (Object)"Can't combine conflicting results of same strength");
            return a;
        }

        public static Result allow(int strength) {
            Preconditions.checkArgument((strength > 0 ? 1 : 0) != 0);
            return new Result(strength, Event.Result.ALLOW);
        }

        public static Result deny(int strength) {
            Preconditions.checkArgument((strength > 0 ? 1 : 0) != 0);
            return new Result(strength, Event.Result.DENY);
        }
    }

    public static interface Preprocessor {
        public BlockState preprocessFoundState(BlockState var1, BlockState var2, @Nullable Level var3, @Nullable BlockPos var4);
    }

    public static interface MatcherPredicate {
        public Result matches(BlockState var1, BlockState var2, @Nullable Level var3, @Nullable BlockPos var4);
    }
}

