/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting.cache;

import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.cache.IListRecipe;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class CachedRecipeList<R extends Recipe<?>> {
    public static final int INVALID_RELOAD_COUNT = -1;
    private static int reloadCount = 0;
    private final Supplier<RecipeType<R>> type;
    private final Class<R> recipeClass;
    private Map<ResourceLocation, R> recipes;
    private boolean cachedDataIsClient;
    private int cachedAtReloadCount = -1;

    public CachedRecipeList(Supplier<RecipeType<R>> type, Class<R> recipeClass) {
        this.type = type;
        this.recipeClass = recipeClass;
    }

    public CachedRecipeList(IERecipeTypes.TypeWithClass<R> type) {
        this((Supplier<RecipeType<R>>)type.type(), type.recipeClass());
    }

    @SubscribeEvent
    public static void onTagsUpdated(TagsUpdatedEvent ev) {
        ++reloadCount;
    }

    @SubscribeEvent
    public static void onRecipeUpdatedClient(RecipesUpdatedEvent ev) {
        ++reloadCount;
    }

    public static int getReloadCount() {
        return reloadCount;
    }

    public Collection<R> getRecipes(@Nonnull Level level) {
        this.updateCache(level.m_7465_(), level.m_5776_());
        return Objects.requireNonNull(this.recipes).values();
    }

    public Collection<ResourceLocation> getRecipeNames(@Nonnull Level level) {
        this.updateCache(level.m_7465_(), level.m_5776_());
        return Objects.requireNonNull(this.recipes).keySet();
    }

    public R getById(@Nonnull Level level, ResourceLocation name) {
        this.updateCache(level.m_7465_(), level.m_5776_());
        return (R)((Recipe)this.recipes.get(name));
    }

    private void updateCache(RecipeManager manager, boolean isClient) {
        if (this.recipes != null && this.cachedAtReloadCount == reloadCount && (!this.cachedDataIsClient || isClient)) {
            return;
        }
        this.recipes = manager.m_44051_().stream().filter(iRecipe -> iRecipe.m_6671_() == this.type.get()).flatMap(r -> {
            if (r instanceof IListRecipe) {
                IListRecipe listRecipe = (IListRecipe)r;
                return listRecipe.getSubRecipes().stream();
            }
            return Stream.of(r);
        }).map(this.recipeClass::cast).collect(Collectors.toMap(Recipe::m_6423_, Function.identity()));
        this.cachedDataIsClient = isClient;
        this.cachedAtReloadCount = reloadCount;
    }
}

