/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.patchouli;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import mythicbotany.MythicBotany;
import mythicbotany.patchouli.PageRuneRitualBase;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import vazkii.botania.client.patchouli.component.ManaComponent;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.gui.BookTextRenderer;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.gui.GuiBookEntry;

public class PageRitualInfo
extends PageRuneRitualBase {
    public static final ResourceLocation OVERLAY_TEXTURE = MythicBotany.getInstance().resource("textures/gui/patchouli_ritual_info.png");
    @SerializedName(value="text")
    public String text;
    private transient ManaComponent manaComponent;
    private transient BookTextRenderer desc;

    @Override
    public void build(Level level, BookEntry entry, BookContentsBuilder builder, int pageNum) {
        super.build(level, entry, builder, pageNum);
        this.manaComponent = new ManaComponent();
        this.manaComponent.build(7, 115, pageNum);
        if (this.recipe != null) {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            outputs.addAll(this.recipe.getOutputs());
            if (this.recipe.getSpecialOutput() != null) {
                outputs.addAll(this.recipe.getSpecialOutput().getJeiOutputItems());
            }
            for (ItemStack stack : outputs) {
                entry.addRelevantStack(builder, stack, pageNum);
            }
        }
    }

    public void onDisplayed(GuiBookEntry parent, int left, int top) {
        super.onDisplayed(parent, left, top);
        if (this.text != null) {
            MutableComponent tc = this.text.isEmpty() ? Component.m_237119_() : (parent.book.i18n ? Component.m_237115_((String)this.text) : Component.m_237113_((String)this.text));
            this.desc = new BookTextRenderer((GuiBook)parent, (Component)tc, 1, 64);
        }
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.enableBlend();
        graphics.m_280163_(OVERLAY_TEXTURE, 0, 0, 0.0f, 0.0f, 116, 156, 256, 256);
        this.renderInputs(graphics, mouseX, mouseY, partialTicks);
        this.renderOutputs(graphics, mouseX, mouseY, partialTicks);
        this.renderManaBar(graphics, mouseX, mouseY, partialTicks);
        if (this.desc != null) {
            this.desc.render(graphics, mouseX, mouseY);
        }
    }

    private void renderInputs(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.recipe != null) {
            ArrayList<Ingredient> inputs = new ArrayList<Ingredient>();
            inputs.addAll(this.recipe.getInputs());
            if (this.recipe.getSpecialInput() != null) {
                inputs.addAll(this.recipe.getSpecialInput().getJeiInputItems());
            }
            int startX = 58 - 8 * inputs.size();
            for (int i = 0; i < inputs.size(); ++i) {
                this.parent.renderIngredient(graphics, startX + 16 * i, 12, mouseX, mouseY, (Ingredient)inputs.get(i));
            }
        }
    }

    private void renderOutputs(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.recipe != null) {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            outputs.addAll(this.recipe.getOutputs());
            if (this.recipe.getSpecialOutput() != null) {
                outputs.addAll(this.recipe.getSpecialOutput().getJeiOutputItems());
            }
            int startX = 58 - 8 * outputs.size();
            for (int i = 0; i < outputs.size(); ++i) {
                this.parent.renderItemStack(graphics, startX + 16 * i, 41, mouseX, mouseY, (ItemStack)outputs.get(i));
            }
        }
    }

    private void renderManaBar(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.recipe != null && this.recipe.getMana() > 0) {
            this.manaComponent.mana = IVariable.wrap((Number)this.recipe.getMana());
            this.manaComponent.onVariablesAvailable(v -> v);
            this.manaComponent.render(graphics, (IComponentRenderContext)this.parent, partialTicks, mouseX, mouseY);
        }
    }
}

