/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.patchouli;

import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class MultipleInputsComponent
implements ICustomComponent {
    @SerializedName(value="recipe_name")
    public String recipeName;
    protected transient List<Ingredient> ingredients;
    protected transient int x;
    protected transient int y;

    public void build(int componentX, int componentY, int pageNum) {
        this.x = componentX != -1 ? componentX : 17;
        this.y = componentY;
        this.ingredients = this.makeIngredients();
    }

    private List<Ingredient> makeIngredients() {
        AtomicReference<Object> recipe = new AtomicReference<Object>(null);
        Minecraft.m_91087_().f_91073_.m_7465_().m_44043_(new ResourceLocation(this.recipeName)).ifPresent(recipe::set);
        if (recipe.get() == null) {
            throw new RuntimeException("Missing recipe: " + this.recipeName);
        }
        return ((Recipe)recipe.get()).m_7527_();
    }

    public void render(@Nonnull GuiGraphics graphics, @Nonnull IComponentRenderContext context, float pticks, int mouseX, int mouseY) {
        int widthHalf = 20 * this.ingredients.size() / 2;
        for (int i = 0; i < this.ingredients.size(); ++i) {
            context.renderIngredient(graphics, this.x - widthHalf + 9 + 20 * i, this.y, mouseX, mouseY, this.ingredients.get(i));
        }
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.recipeName = ((IVariable)lookup.apply(IVariable.wrap((String)this.recipeName))).asString();
    }
}

