/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.mjoellnir;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mythicbotany.EventListener;
import mythicbotany.advancement.ModCriteria;
import mythicbotany.config.MythicConfig;
import mythicbotany.mjoellnir.BlockMjoellnir;
import mythicbotany.register.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class Mjoellnir
extends Projectile {
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.m_135353_(Mjoellnir.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(Mjoellnir.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private boolean returning = false;
    private ItemStack stack = ItemStack.f_41583_;
    private UUID thrower = null;
    private Vec3 throwPos = null;
    private int hotbarSlot = 0;
    private int lifeLeft = 40;

    public Mjoellnir(Level level) {
        this(ModBlocks.mjoellnir.getEntityType(), level);
    }

    public Mjoellnir(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(RETURNING, (Object)false);
        this.f_19804_.m_135372_(STACK, (Object)ItemStack.f_41583_);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7350_(@Nonnull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (RETURNING.equals(key)) {
            this.returning = (Boolean)this.f_19804_.m_135370_(RETURNING);
        } else if (STACK.equals(key)) {
            this.stack = (ItemStack)this.f_19804_.m_135370_(STACK);
        }
    }

    public void m_8119_() {
        Vec3 position;
        super.m_8119_();
        boolean returningTickStart = this.returning;
        if (!this.returning) {
            this.checkForCollision();
        } else if (!this.m_9236_().f_46443_) {
            Vec3 returnPoint = this.getReturnPoint();
            if (returnPoint != null) {
                this.applyReturnMotion(returnPoint);
            }
            this.tryReturn(returnPoint);
        }
        Vec3 motion = this.m_20184_();
        if (returningTickStart) {
            position = this.m_20182_();
            this.m_6034_(position.f_82479_ + motion.f_82479_, position.f_82480_ + motion.f_82480_, position.f_82481_ + motion.f_82481_);
        } else {
            this.m_6478_(MoverType.SELF, motion);
        }
        --this.lifeLeft;
        if (this.lifeLeft <= 0) {
            this.startReturn();
        }
        position = this.m_20182_();
        this.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
    }

    private void checkForCollision() {
        Vec3 motion = this.m_20184_();
        Vec3 position = this.m_20182_();
        Vec3 rayCast = position.m_82549_(motion);
        if (this.m_6084_() && !((Boolean)this.f_19804_.m_135370_(RETURNING)).booleanValue()) {
            EntityHitResult result = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)position, (Vec3)rayCast, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), entity -> entity != this && !entity.m_5833_() && entity.m_6084_() && entity.m_6087_() && entity != this.getThrower());
            if (result == null || result.m_6662_() == HitResult.Type.MISS) {
                result = this.m_9236_().m_45547_(new ClipContext(position, rayCast, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            }
            if (result != null && result.m_6662_() != HitResult.Type.MISS) {
                if (!this.m_9236_().f_46443_) {
                    this.m_6532_((HitResult)result);
                } else {
                    Vec3 returnPoint = this.getReturnPoint();
                    if (returnPoint != null) {
                        this.applyReturnMotionClient(returnPoint);
                    }
                }
            }
        }
    }

    protected void m_6532_(@Nonnull HitResult result) {
        if (!this.returning) {
            super.m_6532_(result);
            this.startReturn();
        }
    }

    protected void m_5790_(@Nonnull EntityHitResult result) {
        if (result.m_82443_() instanceof LivingEntity) {
            this.attackEntities((LivingEntity)result.m_82443_());
        }
    }

    protected void m_8060_(@Nonnull BlockHitResult hit) {
        AABB aabb = new AABB(hit.m_82450_(), hit.m_82450_()).m_82400_(2.0);
        List living = this.m_9236_().m_6443_(LivingEntity.class, aabb, entity -> !entity.m_5833_() && entity.m_6084_() && entity != this.getThrower());
        if (!living.isEmpty()) {
            this.attackEntities((LivingEntity)living.get(this.m_9236_().f_46441_.m_188503_(living.size())));
        }
    }

    @Nullable
    protected PortalInfo m_7937_(@Nonnull ServerLevel level) {
        return null;
    }

    @Nullable
    private Vec3 getReturnPoint() {
        Player throwerEntity = this.getThrower();
        if (throwerEntity != null) {
            return throwerEntity.m_20182_();
        }
        if (this.throwPos != null) {
            return this.throwPos;
        }
        return null;
    }

    private void applyReturnMotion(@Nonnull Vec3 returnPoint) {
        if (!this.m_9236_().f_46443_) {
            Vec3 motion = this.m_20184_();
            Vec3 position = this.m_20182_();
            Vec3 returnVec = new Vec3(returnPoint.f_82479_ - position.f_82479_, returnPoint.f_82480_ - position.f_82480_, returnPoint.f_82481_ - position.f_82481_).m_82541_().m_82542_(0.6, 0.6, 0.6);
            double loyalty = 1.0 + 0.07 * (double)Mth.m_14045_((int)this.stack.getEnchantmentLevel(Enchantments.f_44955_), (int)0, (int)3);
            Vec3 newMotion = new Vec3((3.0 * motion.f_82479_ + returnVec.f_82479_) / 4.0, (3.0 * motion.f_82480_ + returnVec.f_82480_) / 4.0, (3.0 * motion.f_82481_ + returnVec.f_82481_) / 4.0).m_82542_(loyalty, loyalty, loyalty);
            this.m_20256_(newMotion);
        }
    }

    private void applyReturnMotionClient(@Nonnull Vec3 returnPoint) {
        if (this.m_9236_().f_46443_) {
            Vec3 motion = this.m_20184_();
            Vec3 position = this.m_20182_();
            Vec3 returnVec = new Vec3(returnPoint.f_82479_ - position.f_82479_, returnPoint.f_82480_ - position.f_82480_, returnPoint.f_82481_ - position.f_82481_).m_82541_().m_82542_(0.6, 0.6, 0.6);
            Vec3 newMotion = new Vec3((3.0 * motion.f_82479_ + returnVec.f_82479_) / 4.0, (3.0 * motion.f_82480_ + returnVec.f_82480_) / 4.0, (3.0 * motion.f_82481_ + returnVec.f_82481_) / 4.0);
            this.m_20256_(newMotion);
        }
    }

    private void tryReturn(@Nullable Vec3 returnPoint) {
        if (returnPoint == null) {
            BlockMjoellnir.putInWorld(this.stack, this.m_9236_(), this.m_20183_());
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        } else if (returnPoint.m_82557_(this.m_20182_()) < 2.0) {
            Player throwerEntity = this.getThrower();
            if (throwerEntity != null) {
                if (!BlockMjoellnir.putInInventory(throwerEntity, this.stack, this.hotbarSlot)) {
                    BlockMjoellnir.putInWorld(this.stack, this.m_9236_(), BlockPos.m_274446_((Position)returnPoint));
                }
            } else {
                BlockMjoellnir.putInWorld(this.stack, this.m_9236_(), BlockPos.m_274446_((Position)returnPoint));
            }
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    private void startReturn() {
        if (!this.returning) {
            this.setLifeLeft(0);
            this.setReturning(true);
        }
    }

    private void attackEntities(LivingEntity target) {
        AABB aabb = new AABB(target.m_20182_(), target.m_20182_()).m_82400_(4.0);
        List found = this.m_9236_().m_6443_(LivingEntity.class, aabb, entity -> !entity.m_5833_() && entity.m_6084_() && entity != this.getThrower());
        LightningBolt lightning = this.attackEntity(target);
        for (LivingEntity entity2 : found) {
            if (entity2 == target) continue;
            this.areaDamage(entity2, lightning);
        }
    }

    @Nullable
    private LightningBolt attackEntity(LivingEntity target) {
        if (!this.m_9236_().f_46443_) {
            Player thrower;
            Vec3 vector3d;
            int knockback;
            if (this.stack.getEnchantmentLevel(Enchantments.f_44990_) >= 1) {
                target.m_20254_(5);
            }
            if ((knockback = this.stack.getEnchantmentLevel(Enchantments.f_44989_)) > 0 && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)knockback * 0.6)).m_82556_() > 0.0) {
                target.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
            }
            int power = this.stack.getEnchantmentLevel(Enchantments.f_44988_);
            float dmg = MythicConfig.mjoellnir.base_damage_ranged + 1.0f;
            if (power > 0) {
                dmg += MythicConfig.mjoellnir.enchantment_multiplier * Enchantments.f_44977_.getDamageBonus(power, target.m_6336_(), this.stack);
            }
            if ((thrower = this.getThrower()) instanceof ServerPlayer) {
                ModCriteria.MJOELLNIR.trigger((ServerPlayer)thrower, this.getStack(), (Entity)target);
            }
            target.m_6469_(thrower == null ? this.m_9236_().m_269111_().m_269264_() : this.m_9236_().m_269111_().m_269299_((Entity)this, (LivingEntity)thrower), dmg);
            LightningBolt lightning = new LightningBolt(EntityType.f_20465_, this.m_9236_());
            lightning.m_6034_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            lightning.m_20874_(true);
            lightning.m_20879_(thrower instanceof ServerPlayer ? (ServerPlayer)thrower : null);
            this.m_9236_().m_7967_((Entity)lightning);
            if (this.m_9236_() instanceof ServerLevel && !ForgeEventFactory.onEntityStruckByLightning((Entity)target, (LightningBolt)lightning)) {
                int fireTicks = target.m_20094_();
                LivingEntity oldImmune = EventListener.lightningImmuneEntity;
                EventListener.lightningImmuneEntity = target;
                target.m_8038_((ServerLevel)this.m_9236_(), lightning);
                EventListener.lightningImmuneEntity = oldImmune;
                target.m_7311_(fireTicks);
            }
            return lightning;
        }
        return null;
    }

    private void areaDamage(LivingEntity target, @Nullable LightningBolt lightning) {
        Player thrower;
        if (this.stack.getEnchantmentLevel(Enchantments.f_44990_) >= 1) {
            target.m_20254_(2);
        }
        int power = this.stack.getEnchantmentLevel(Enchantments.f_44988_);
        float dmg = MythicConfig.mjoellnir.base_damage_ranged + 1.0f;
        if (power > 0) {
            dmg += MythicConfig.mjoellnir.enchantment_multiplier * Enchantments.f_44977_.getDamageBonus(power, target.m_6336_(), this.stack);
        }
        target.m_6469_((thrower = this.getThrower()) == null ? this.m_9236_().m_269111_().m_269264_() : this.m_9236_().m_269111_().m_269299_((Entity)this, (LivingEntity)thrower), dmg *= MythicConfig.mjoellnir.secondary_target_multiplier);
        if (lightning != null && this.m_9236_().f_46441_.m_188501_() < MythicConfig.mjoellnir.secondary_lightning_chance) {
            int fireTicks = target.m_20094_();
            LivingEntity oldImmune = EventListener.lightningImmuneEntity;
            EventListener.lightningImmuneEntity = target;
            target.m_8038_((ServerLevel)this.m_9236_(), lightning);
            EventListener.lightningImmuneEntity = oldImmune;
            target.m_7311_(fireTicks);
        }
    }

    public boolean isReturning() {
        return this.returning;
    }

    public void setReturning(boolean returning) {
        this.f_19804_.m_135381_(RETURNING, (Object)returning);
        this.returning = returning;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(ItemStack stack) {
        this.f_19804_.m_135381_(STACK, (Object)stack);
        this.stack = stack;
    }

    @Nullable
    public Player getThrower() {
        if (this.thrower == null) {
            return null;
        }
        return this.m_9236_().m_46003_(this.thrower);
    }

    @Nullable
    public UUID getThrowerId() {
        return this.thrower;
    }

    public void setThrower(@Nullable Player thrower) {
        this.setThrowerId(thrower == null ? null : thrower.m_36316_().getId());
    }

    public void setThrowerId(@Nullable UUID thrower) {
        this.thrower = thrower;
    }

    @Nullable
    public Entity m_19749_() {
        return this.getThrower();
    }

    @Nullable
    public Vec3 getThrowPos() {
        return this.throwPos;
    }

    public void setThrowPos(@Nullable Vec3 throwPos) {
        this.throwPos = throwPos;
    }

    public int getHotBarSlot() {
        return this.hotbarSlot;
    }

    public void setHotBarSlot(int hotBarSlot) {
        this.hotbarSlot = hotBarSlot;
    }

    public int getLifeLeft() {
        return this.lifeLeft;
    }

    public void setLifeLeft(int lifeLeft) {
        this.lifeLeft = lifeLeft;
    }

    protected void m_7380_(@Nonnull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("Stack", (Tag)this.stack.m_41739_(new CompoundTag()));
        if (this.thrower != null) {
            compound.m_128379_("thrower", true);
            compound.m_128356_("throwerl", this.thrower.getLeastSignificantBits());
            compound.m_128356_("throwerm", this.thrower.getMostSignificantBits());
        } else {
            compound.m_128379_("thrower", false);
        }
        if (this.throwPos != null) {
            compound.m_128379_("throwPos", true);
            compound.m_128347_("throwX", this.throwPos.f_82479_);
            compound.m_128347_("throwY", this.throwPos.f_82480_);
            compound.m_128347_("throwZ", this.throwPos.f_82481_);
        } else {
            compound.m_128379_("throwPos", false);
        }
        compound.m_128347_("hotbar", (double)this.hotbarSlot);
        compound.m_128347_("lifeTime", (double)this.lifeLeft);
        compound.m_128379_("returning", this.returning);
    }

    protected void m_7378_(@Nonnull CompoundTag compound) {
        super.m_7378_(compound);
        this.setStack(ItemStack.m_41712_((CompoundTag)compound.m_128469_("Stack")));
        if (compound.m_128471_("thrower")) {
            this.setThrowerId(new UUID(compound.m_128454_("throwerm"), compound.m_128454_("throwerl")));
        } else {
            this.setThrowerId(null);
        }
        if (compound.m_128471_("throwPos")) {
            this.setThrowPos(new Vec3(compound.m_128459_("throwX"), compound.m_128459_("throwY"), compound.m_128459_("throwZ")));
        } else {
            this.setThrowPos(null);
        }
        this.setHotBarSlot(compound.m_128451_("hotbar"));
        this.setLifeLeft(compound.m_128451_("lifeTime"));
        this.setReturning(compound.m_128471_("returning"));
    }
}

