/*
 * Decompiled with CFR 0.152.
 */
package mythicbotany.alfheim.datagen;

import mythicbotany.alfheim.datagen.AlfheimFeatures;
import mythicbotany.alfheim.datagen.AlfheimPlacements;
import mythicbotany.register.ModEntities;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import org.moddingx.libx.datagen.DatagenContext;
import org.moddingx.libx.datagen.provider.sandbox.BiomeProviderBase;

public class AlfheimBiomes
extends BiomeProviderBase {
    private final AlfheimFeatures features;
    private final AlfheimPlacements placements;
    public final Holder<Biome> alfheimPlains;
    public final Holder<Biome> alfheimHills;
    public final Holder<Biome> dreamwoodForest;
    public final Holder<Biome> goldenFields;
    public final Holder<Biome> alfheimLakes;

    public AlfheimBiomes(DatagenContext ctx) {
        super(ctx);
        this.features = (AlfheimFeatures)this.context.findRegistryProvider(AlfheimFeatures.class);
        this.placements = (AlfheimPlacements)this.context.findRegistryProvider(AlfheimPlacements.class);
        this.alfheimPlains = this.alfheimBiome(0.9f, 1.0f).generation(this.alfheimGen().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.alfheimGrass).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.looseDreamwoodTrees).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.motifFlowers).m_255419_(GenerationStep.Decoration.SURFACE_STRUCTURES, this.placements.abandonedApothecaries)).build();
        this.alfheimHills = this.alfheimBiome(0.9f, 1.0f).generation(this.alfheimGen().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.alfheimGrass).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.looseDreamwoodTrees).m_255419_(GenerationStep.Decoration.SURFACE_STRUCTURES, this.placements.manaCrystals).m_255419_(GenerationStep.Decoration.SURFACE_STRUCTURES, this.placements.abandonedApothecaries)).build();
        this.dreamwoodForest = this.alfheimBiome(0.9f, 1.0f).generation(this.alfheimGen().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.alfheimGrass).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.denseDreamwoodTrees).m_255419_(GenerationStep.Decoration.SURFACE_STRUCTURES, this.placements.abandonedApothecaries)).build();
        this.goldenFields = this.alfheimBiome(0.8f, 0.4f).effects(this.alfheimEffects().m_48034_(4566514).m_48037_(267827).m_48019_(12638463)).generation(this.alfheimGen().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.wheatFields).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.extraGoldOre).m_255419_(GenerationStep.Decoration.SURFACE_STRUCTURES, this.placements.abandonedApothecaries)).build();
        this.alfheimLakes = this.alfheimBiome(0.9f, 1.0f).effects(this.alfheimEffects().m_48034_(4566514).m_48037_(267827).m_48019_(12638463)).generation(this.alfheimGen().m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.alfheimGrass).m_255419_(GenerationStep.Decoration.VEGETAL_DECORATION, this.placements.motifFlowers)).build();
    }

    public BiomeProviderBase.BiomeBuilder alfheimBiome(float temperature, float downfall) {
        return this.biome(temperature, downfall).effects(this.alfheimEffects()).mobSpawns(this.alfheimSpawns());
    }

    public BiomeSpecialEffects.Builder alfheimEffects() {
        return this.effects().m_48034_(4445678).m_48037_(270131).m_48019_(12638463);
    }

    public MobSpawnSettings.Builder alfheimSpawns() {
        MobSpawnSettings.Builder builder = this.spawns().m_48368_(0.2f);
        BiomeDefaultFeatures.m_126734_((MobSpawnSettings.Builder)builder);
        return builder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(ModEntities.alfPixie, 5, 4, 10)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 2, 1, 2)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20459_, 1, 1, 1));
    }

    public BiomeGenerationSettings.PlainBuilder alfheimGen() {
        return this.generation().m_254863_(GenerationStep.Carving.AIR, this.features.cave).m_254863_(GenerationStep.Carving.AIR, this.features.canyon).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicForestStone).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicMountainStone).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicFungalStone).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicSwampStone).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicDesertStone).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicTaigaStone).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.metamorphicMesaStone).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.elementiumOre).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.dragonstoneOre).m_255419_(GenerationStep.Decoration.UNDERGROUND_ORES, this.placements.goldOre);
    }
}

