/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.item;

import com.mojang.datafixers.util.Pair;
import com.tom.createores.Config;
import com.tom.createores.OreDataCapability;
import com.tom.createores.OreVeinGenerator;
import com.tom.createores.Registration;
import com.tom.createores.network.NetworkHandler;
import com.tom.createores.network.OreVeinInfoPacket;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.ComponentJoiner;
import com.tom.createores.util.RandomSpreadGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class OreVeinFinderItem
extends Item {
    public OreVeinFinderItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        if (!level.f_46443_) {
            this.detect(level, player.m_20183_(), player);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(interactionHand));
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        if (!ctx.m_43725_().f_46443_) {
            this.detect(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43723_());
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack pStack, Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (pStack.m_41782_() && pStack.m_41783_().m_128471_("isFiltered")) {
            pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.coe.vein_finder.filtered"));
        }
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.f_46443_ && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            if (pLevel.m_46467_() % 20L == 10L) {
                boolean hasAtlas = false;
                for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                    ItemStack is = player.m_150109_().m_8020_(i);
                    if (is.m_41720_() != Registration.VEIN_ATLAS_ITEM.get()) continue;
                    hasAtlas = true;
                    break;
                }
                pStack.m_41784_().m_128379_("isFiltered", hasAtlas);
            }
        }
    }

    public boolean m_5812_(ItemStack pStack) {
        return pStack.m_41782_() && pStack.m_41783_().m_128471_("isFiltered") || super.m_5812_(pStack);
    }

    private void detect(Level level, BlockPos pos, Player player) {
        CompoundTag atlasTag;
        ItemStack atlas = ItemStack.f_41583_;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack is = player.m_150109_().m_8020_(i);
            if (is.m_41720_() != Registration.VEIN_ATLAS_ITEM.get()) continue;
            atlas = is;
            break;
        }
        Predicate<VeinRecipe> filter = (atlasTag = atlas.m_41783_()) != null ? this.makeFilter(atlasTag) : a -> true;
        ChunkPos center = new ChunkPos(pos);
        OreDataCapability.OreData found = null;
        ArrayList<OreDataCapability.OreData> nearby = new ArrayList<OreDataCapability.OreData>();
        int near = Config.veinFinderNear;
        for (int x = -near; x <= near; ++x) {
            for (int z = -near; z <= near; ++z) {
                OreDataCapability.OreData d2 = OreDataCapability.getData(level.m_6325_(center.f_45578_ + x, center.f_45579_ + z));
                if (x == 0 && z == 0) {
                    found = d2;
                    continue;
                }
                nearby.add(d2);
            }
        }
        player.m_5661_((Component)Component.m_237115_((String)"chat.coe.veinFinder.info"), false);
        player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.pos", (Object[])new Object[]{center.f_45578_, center.f_45579_}), false);
        RecipeManager m = level.m_7465_();
        MutableComponent nothing = Component.m_237115_((String)"chat.coe.veinFinder.nothing");
        MutableComponent comma = Component.m_237113_((String)", ");
        Object f = found != null && found.getRecipe(m) != null ? found.getRecipe(m).getName() : nothing;
        player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.found", (Object[])new Object[]{f}), false);
        CompoundTag infoTag = new CompoundTag();
        ResourceLocation id = found.getRecipeId();
        if (id != null) {
            infoTag.m_128359_("found", id.toString());
        }
        infoTag.m_128405_("x", pos.m_123341_());
        infoTag.m_128405_("z", pos.m_123343_());
        ResourceLocation rl = nearby.stream().map(d -> d.getRecipe(m)).filter(r -> r != null).map(VeinRecipe::m_6423_).findFirst().orElse(null);
        if (rl != null) {
            infoTag.m_128359_("nearby", rl.toString());
        }
        f = nearby.stream().map(d -> d.getRecipe(m)).filter(r -> r != null).map(r -> r.getName()).collect(ComponentJoiner.joining((Component)nothing, (Component)comma));
        player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.nearby", (Object[])new Object[]{f}), false);
        Pair<BlockPos, VeinRecipe> nearest = OreVeinGenerator.getPicker((ServerLevel)level).locate(pos, (ServerLevel)level, 16, filter);
        if (nearest != null) {
            BlockPos at = (BlockPos)nearest.getFirst();
            int i = Math.round(RandomSpreadGenerator.distance2d(at, pos) / (float)Config.veinFinderFar) * Config.veinFinderFar;
            player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.far", (Object[])new Object[]{Component.m_237110_((String)"chat.coe.veinFinder.distance", (Object[])new Object[]{((VeinRecipe)nearest.getSecond()).getName(), i})}), false);
            infoTag.m_128359_("far", ((VeinRecipe)nearest.getSecond()).m_6423_().toString());
            infoTag.m_128405_("dist", i);
        } else {
            player.m_5661_((Component)Component.m_237110_((String)"chat.coe.veinFinder.far", (Object[])new Object[]{nothing}), false);
        }
        NetworkHandler.sendTo((ServerPlayer)player, new OreVeinInfoPacket(infoTag));
        player.m_36335_().m_41524_((Item)this, Config.veinFinderCd);
    }

    private Predicate<VeinRecipe> makeFilter(CompoundTag atlasTag) {
        String vt = atlasTag.m_128461_("veinTarget");
        ResourceLocation target = ResourceLocation.m_135820_((String)vt);
        if (!vt.isEmpty() && target != null) {
            return v -> target.equals((Object)v.m_6423_());
        }
        HashSet<ResourceLocation> exclude = new HashSet<ResourceLocation>();
        ListTag ex = atlasTag.m_128437_("exclude", 8);
        for (int i = 0; i < ex.size(); ++i) {
            ResourceLocation v2 = ResourceLocation.m_135820_((String)ex.m_128778_(i));
            if (v2 == null) continue;
            exclude.add(v2);
        }
        if (exclude.isEmpty()) {
            return a -> true;
        }
        return v -> !exclude.contains(v.m_6423_());
    }
}

