/*
 * Decompiled with CFR 0.152.
 */
package com.dannyandson.tinyredstone.gui;

import com.dannyandson.tinyredstone.blocks.PanelTile;
import com.dannyandson.tinyredstone.blocks.panelcells.Repeater;
import com.dannyandson.tinyredstone.gui.ModWidget;
import com.dannyandson.tinyredstone.network.ModNetworkHandler;
import com.dannyandson.tinyredstone.network.RepeaterTickSync;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class RepeaterCellGUI
extends Screen {
    private static final int WIDTH = 190;
    private static final int HEIGHT = 100;
    private final PanelTile panelTile;
    private final Integer cellIndex;
    private final Repeater repeaterCell;
    private ModWidget tickCount;
    private final ResourceLocation GUI = new ResourceLocation("tinyredstone", "textures/gui/transparent.png");

    protected RepeaterCellGUI(PanelTile panelTile, Integer cellIndex, Repeater repeaterCell) {
        super((Component)Component.m_237115_((String)"tinyredstone:repeaterGUI"));
        this.panelTile = panelTile;
        this.cellIndex = cellIndex;
        this.repeaterCell = repeaterCell;
    }

    protected void m_7856_() {
        int relX = (this.f_96543_ - 190) / 2;
        int relY = (this.f_96544_ - 100) / 2;
        Integer redstoneTicks = this.repeaterCell.getTicks() / 2;
        Float tSeconds = Float.valueOf(redstoneTicks.floatValue() / 10.0f);
        this.tickCount = new ModWidget(relX, relY + 38, 190, 20, Component.m_130674_((String)(redstoneTicks.toString() + " ticks (" + tSeconds.toString() + " seconds)"))).setTextHAlignment(ModWidget.HAlignment.CENTER).setTextVAlignment(ModWidget.VAlignment.MIDDLE);
        this.m_142416_((GuiEventListener)new ModWidget(relX - 1, relY - 1, 192, 102, -1442840576));
        this.m_142416_((GuiEventListener)new ModWidget(relX, relY, 190, 100, -1997607186));
        this.m_142416_((GuiEventListener)ModWidget.buildButton(relX + 55, relY + 48, 80, 20, (Component)Component.m_237115_((String)"tinyredstone.close"), button -> this.close()));
        this.m_142416_((GuiEventListener)this.tickCount);
        ((ModWidget)this.m_142416_((GuiEventListener)new ModWidget(relX, relY + 3, 188, 20, (Component)Component.m_237115_((String)"tinyredstone.gui.repeater.msg")))).setTextHAlignment(ModWidget.HAlignment.CENTER);
        this.m_142416_((GuiEventListener)ModWidget.buildButton(relX + 15, relY + 15, 20, 20, Component.m_130674_((String)"---"), button -> this.changeTicks(-200)));
        this.m_142416_((GuiEventListener)ModWidget.buildButton(relX + 40, relY + 15, 20, 20, Component.m_130674_((String)"--"), button -> this.changeTicks(-20)));
        this.m_142416_((GuiEventListener)ModWidget.buildButton(relX + 65, relY + 15, 20, 20, Component.m_130674_((String)"-"), button -> this.changeTicks(-2)));
        this.m_142416_((GuiEventListener)ModWidget.buildButton(relX + 105, relY + 15, 20, 20, Component.m_130674_((String)"+"), button -> this.changeTicks(2)));
        this.m_142416_((GuiEventListener)ModWidget.buildButton(relX + 130, relY + 15, 20, 20, Component.m_130674_((String)"++"), button -> this.changeTicks(20)));
        this.m_142416_((GuiEventListener)ModWidget.buildButton(relX + 155, relY + 15, 20, 20, Component.m_130674_((String)"+++"), button -> this.changeTicks(200)));
        ((ModWidget)this.m_142416_((GuiEventListener)new ModWidget(relX, relY + 73, 188, 20, (Component)Component.m_237115_((String)"tinyredstone.gui.repeater.msg2"), -1))).setTextHAlignment(ModWidget.HAlignment.CENTER);
        ((ModWidget)this.m_142416_((GuiEventListener)new ModWidget(relX, relY + 88, 188, 20, (Component)Component.m_237115_((String)"tinyredstone.gui.repeater.msg3"), -1))).setTextHAlignment(ModWidget.HAlignment.CENTER);
    }

    public boolean m_6050_(double mouseX, double mouseY, double scroll) {
        if (mouseX > (double)((this.f_96543_ - 190) / 2) && mouseX < (double)((this.f_96543_ + 190) / 2) && mouseY > (double)((this.f_96544_ - 100) / 2) && mouseY < (double)((this.f_96544_ + 100) / 2)) {
            if (scroll != 0.0) {
                Double dScroll = scroll * 2.0;
                if (RepeaterCellGUI.m_96638_()) {
                    dScroll = dScroll * 10.0;
                }
                this.changeTicks(dScroll.intValue());
                return true;
            }
            return false;
        }
        return super.m_6050_(mouseX, mouseY, scroll);
    }

    private void close() {
        this.f_96541_.m_91152_(null);
    }

    private void changeTicks(int change) {
        this.repeaterCell.setTicks(this.repeaterCell.getTicks() + change);
        ModNetworkHandler.sendToServer(new RepeaterTickSync(this.panelTile.m_58899_(), this.cellIndex, this.repeaterCell.getTicks()));
        int relX = (this.f_96543_ - 190) / 2;
        int relY = (this.f_96544_ - 100) / 2;
        Integer redstoneTicks = this.repeaterCell.getTicks() / 2;
        this.m_169411_((GuiEventListener)this.tickCount);
        Float tSeconds = Float.valueOf(redstoneTicks.floatValue() / 10.0f);
        this.tickCount = new ModWidget(relX, relY + 38, 190, 20, Component.m_130674_((String)(redstoneTicks.toString() + " ticks (" + tSeconds.toString() + " seconds)"))).setTextHAlignment(ModWidget.HAlignment.CENTER).setTextVAlignment(ModWidget.VAlignment.MIDDLE);
        this.m_142416_((GuiEventListener)this.tickCount);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.GUI);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.f_96541_.m_91097_().m_174784_(this.GUI);
        int relX = (this.f_96543_ - 190) / 2;
        int relY = (this.f_96544_ - 100) / 2;
        guiGraphics.m_280218_(this.GUI, relX, relY, 0, 0, 190, 100);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public static void open(PanelTile panelTile, Integer cellIndex, Repeater repeaterCell) {
        Minecraft.m_91087_().m_91152_((Screen)new RepeaterCellGUI(panelTile, cellIndex, repeaterCell));
    }
}

