/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.mobs.wizards;

import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface IMerchantWizard
extends Merchant {
    default public void serializeMerchant(CompoundTag pCompound, @Nullable MerchantOffers offers, long lastRestockGameTime, int numberOfRestocksToday) {
        if (offers != null && !offers.isEmpty()) {
            pCompound.m_128365_("Offers", (Tag)offers.m_45388_());
        }
        pCompound.m_128356_("LastRestock", lastRestockGameTime);
        pCompound.m_128405_("RestocksToday", numberOfRestocksToday);
    }

    default public void deserializeMerchant(CompoundTag pCompound, Consumer<MerchantOffers> setOffers) {
        if (pCompound.m_128425_("Offers", 10)) {
            setOffers.accept(new MerchantOffers(pCompound.m_128469_("Offers")));
        }
        this.setLastRestockGameTime(pCompound.m_128454_("LastRestock"));
        this.setRestocksToday(pCompound.m_128451_("RestocksToday"));
    }

    default public boolean isTrading() {
        return this.m_7962_() != null;
    }

    default public boolean needsToRestock() {
        for (MerchantOffer merchantoffer : this.m_6616_()) {
            if (!merchantoffer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    default public boolean allowedToRestock() {
        return this.getRestocksToday() == 0 && this.merchantLevel().m_46467_() > this.getLastRestockGameTime() + 2400L;
    }

    default public boolean shouldRestock() {
        boolean shouldRestock;
        long timeToNextRestock = this.getLastRestockGameTime() + 12000L;
        long currentGameTime = this.merchantLevel().m_46467_();
        boolean hasDayElapsed = currentGameTime > timeToNextRestock;
        long currentDayTime = this.merchantLevel().m_46468_();
        if (this.getLastRestockCheckDayTime() > 0L) {
            long currentDay = currentDayTime / 24000L;
            long lastRestockDay = this.getLastRestockCheckDayTime() / 24000L;
            hasDayElapsed |= currentDay > lastRestockDay;
        } else {
            this.setLastRestockCheckDayTime(currentDayTime);
        }
        if (hasDayElapsed) {
            this.setLastRestockCheckDayTime(currentDayTime);
            this.setRestocksToday(0);
        }
        boolean bl = shouldRestock = this.needsToRestock() && this.allowedToRestock();
        if (shouldRestock) {
            this.setLastRestockGameTime(currentGameTime);
        }
        return shouldRestock;
    }

    default public void restock() {
        for (MerchantOffer offer : this.m_6616_()) {
            offer.m_45369_();
            offer.m_45372_();
        }
        this.setRestocksToday(this.getRestocksToday() + 1);
    }

    public int getRestocksToday();

    public void setRestocksToday(int var1);

    public long getLastRestockGameTime();

    public void setLastRestockGameTime(long var1);

    public long getLastRestockCheckDayTime();

    public void setLastRestockCheckDayTime(long var1);

    public Level merchantLevel();

    default public int m_7809_() {
        return 0;
    }

    default public void m_6621_(int pXp) {
    }

    default public boolean m_7826_() {
        return false;
    }

    default public boolean m_183595_() {
        return this.merchantLevel().m_5776_();
    }
}

